/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.cypher.operations.GraphFunctions;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.security.DatabaseAccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.MapValue;

public class GraphFunctionsTest
extends CypherFunSuite {
    private static SecurityContext securityContext;
    private static DatabaseReferenceImpl.Composite composite;
    private static DatabaseReferenceImpl.Composite emptyComposite;
    private static final UUID compositeId;
    private static final UUID emptyCompositeId;
    private static final UUID localId;
    private static final UUID remoteId;
    private static final UUID hiddenLocalId;
    private static final UUID hiddenRemoteId;

    @BeforeAll
    public static void setup() {
        HashSet<DatabaseReference> constituents = new HashSet<DatabaseReference>();
        constituents.add(GraphFunctionsTest.internalConstituent("local", localId));
        constituents.add(GraphFunctionsTest.internalConstituent("hiddenLocal", hiddenLocalId));
        constituents.add(GraphFunctionsTest.remoteConstituent("remote", remoteId));
        constituents.add(GraphFunctionsTest.remoteConstituent("hiddenRemote", hiddenRemoteId));
        composite = new DatabaseReferenceImpl.Composite(new NormalizedDatabaseName("composite"), GraphFunctionsTest.mockId(compositeId), constituents);
        emptyComposite = new DatabaseReferenceImpl.Composite(new NormalizedDatabaseName("empty"), GraphFunctionsTest.mockId(emptyCompositeId), new HashSet());
        securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        DatabaseAccessMode accessMode = (DatabaseAccessMode)Mockito.mock(DatabaseAccessMode.class);
        Mockito.when((Object)securityContext.databaseAccessMode()).thenReturn((Object)accessMode);
        composite.constituents().forEach(constituent -> Mockito.when((Object)accessMode.canAccessDatabase(constituent)).thenReturn((Object)(!constituent.fullName().name().contains("hidden") ? 1 : 0)));
    }

    private static NamedDatabaseId mockId(UUID id) {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)Mockito.mock(NamedDatabaseId.class);
        Mockito.when((Object)namedDatabaseId.databaseId()).thenReturn((Object)DatabaseIdFactory.from((UUID)id));
        return namedDatabaseId;
    }

    @Test
    public void graphNames() {
        AnyValue names = GraphFunctions.names((DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext);
        Assertions.assertThat((Object[])((StringArray)names).asObjectCopy()).containsExactly((Object[])new String[]{"composite.local", "composite.remote"});
    }

    @Test
    public void graphNamesEmptyConstituents() {
        AnyValue names = GraphFunctions.names((DatabaseReferenceImpl.Composite)emptyComposite, (SecurityContext)securityContext);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((StringArray)names).intSize());
    }

    @ParameterizedTest
    @ValueSource(strings={"composite.local", "composite.remote"})
    public void graphByName(String name) {
        DatabaseReference graph = GraphFunctions.graphByName((String)name, (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext);
        org.junit.jupiter.api.Assertions.assertEquals((Object)name, (Object)graph.fullName().name());
    }

    @ParameterizedTest
    @ValueSource(strings={"composite.local", "composite.remote"})
    public void graphByNameUpperCase(String name) {
        DatabaseReference graph = GraphFunctions.graphByName((String)name.toUpperCase(), (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext);
        org.junit.jupiter.api.Assertions.assertEquals((Object)name, (Object)graph.fullName().name());
    }

    @ParameterizedTest
    @ValueSource(strings={"local", "composite.hiddenLocal", "composite.hiddenRemote", "composite", ""})
    public void graphByNameInvalid(String name) {
        org.junit.jupiter.api.Assertions.assertThrows(EntityNotFoundException.class, () -> GraphFunctions.graphByName((String)name, (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext));
    }

    @Test
    public void graphByNameEmptyConstituents() {
        org.junit.jupiter.api.Assertions.assertThrows(EntityNotFoundException.class, () -> GraphFunctions.graphByName((String)"invalid", (DatabaseReferenceImpl.Composite)emptyComposite, (SecurityContext)securityContext));
    }

    @Test
    public void graphById() {
        for (UUID id : Arrays.asList(localId, remoteId)) {
            DatabaseReference graph = GraphFunctions.graphById((UUID)id, (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext);
            org.junit.jupiter.api.Assertions.assertEquals((Object)id, (Object)graph.id());
        }
    }

    @Test
    public void graphByIdInvalid() {
        for (UUID id : Arrays.asList(hiddenLocalId, hiddenRemoteId, compositeId, emptyCompositeId, UUID.randomUUID())) {
            org.junit.jupiter.api.Assertions.assertThrows(EntityNotFoundException.class, () -> GraphFunctions.graphById((UUID)id, (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext));
        }
    }

    @Test
    public void graphByIdInvalidEmptyConstituents() {
        org.junit.jupiter.api.Assertions.assertThrows(EntityNotFoundException.class, () -> GraphFunctions.graphById((UUID)UUID.randomUUID(), (DatabaseReferenceImpl.Composite)emptyComposite, (SecurityContext)securityContext));
    }

    @ParameterizedTest
    @ValueSource(strings={"local", "composite.hiddenLocal", "composite.hiddenRemote", "composite", ""})
    public void graphPropertiesInvalidGraph(String name) {
        org.junit.jupiter.api.Assertions.assertThrows(EntityNotFoundException.class, () -> GraphFunctions.graphProperties((String)name, (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext, (TopologyGraphDbmsModel)((TopologyGraphDbmsModel)Mockito.mock(TopologyGraphDbmsModel.class))));
    }

    @Test
    public void graphPropertiesNonEmpty() {
        TopologyGraphDbmsModel topologyGraphDbmsModel = (TopologyGraphDbmsModel)Mockito.mock(TopologyGraphDbmsModel.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("prop", "val");
        Mockito.when((Object)topologyGraphDbmsModel.getAliasProperties(Mockito.anyString(), Mockito.anyString())).thenReturn(Optional.of(properties));
        MapValue result = GraphFunctions.graphProperties((String)"composite.local", (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext, (TopologyGraphDbmsModel)topologyGraphDbmsModel);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"val", (Object)((StringValue)result.get("prop")).stringValue());
    }

    @Test
    public void graphPropertiesEmpty() {
        TopologyGraphDbmsModel topologyGraphDbmsModel = (TopologyGraphDbmsModel)Mockito.mock(TopologyGraphDbmsModel.class);
        Mockito.when((Object)topologyGraphDbmsModel.getAliasProperties(Mockito.anyString(), Mockito.anyString())).thenReturn(Optional.empty());
        MapValue result = GraphFunctions.graphProperties((String)"composite.remote", (DatabaseReferenceImpl.Composite)composite, (SecurityContext)securityContext, (TopologyGraphDbmsModel)topologyGraphDbmsModel);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.size());
    }

    private static DatabaseReference internalConstituent(String name, UUID id) {
        return new DatabaseReferenceImpl.Internal(new NormalizedDatabaseName(name), new NormalizedDatabaseName("composite"), GraphFunctionsTest.mockId(id), false);
    }

    private static DatabaseReference remoteConstituent(String alias, UUID id) {
        return new DatabaseReferenceImpl.External(new NormalizedDatabaseName("remoteDb"), new NormalizedDatabaseName(alias), new NormalizedDatabaseName("composite"), (RemoteUri)Mockito.mock(RemoteUri.class), id);
    }

    static {
        compositeId = UUID.randomUUID();
        emptyCompositeId = UUID.randomUUID();
        localId = UUID.randomUUID();
        remoteId = UUID.randomUUID();
        hiddenLocalId = UUID.randomUUID();
        hiddenRemoteId = UUID.randomUUID();
    }
}

