/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.operations.PathValueBuilder;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

class PathValueBuilderTest {
    private Map<Long, RelatedTo> relations = new HashMap<Long, RelatedTo>();

    PathValueBuilderTest() {
    }

    @BeforeEach
    void setup() {
        this.relations.clear();
    }

    @Test
    void shouldComplainOnEmptyPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PathValueBuilder((DbAccess)Mockito.mock(DbAccess.class), (RelationshipScanCursor)Mockito.mock(RelationshipScanCursor.class)).build());
    }

    @Test
    void shouldHandleSingleNode() {
        VirtualNodeValue node = this.node(42L);
        PathValueBuilder builder = this.builder(new AnyValue[]{node});
        builder.addNode(node);
        Assertions.assertEquals((Object)this.path(new AnyValue[]{node}), (Object)builder.build());
    }

    @Test
    void shouldHandleLongerPath() {
        VirtualNodeValue n1 = this.node(42L);
        VirtualNodeValue n2 = this.node(43L);
        VirtualNodeValue n3 = this.node(44L);
        VirtualRelationshipValue r1 = this.relationship(1337L, n2, n1);
        VirtualRelationshipValue r2 = this.relationship(1338L, n2, n3);
        PathValueBuilder builder = this.builder(new AnyValue[]{n1, n2, n3, r1, r2});
        builder.addNode(n1);
        builder.addIncoming(r1);
        builder.addUndirected(r2);
        Assertions.assertEquals((Object)this.path(new AnyValue[]{n1, r1, n2, r2, n3}), (Object)builder.build());
    }

    @Test
    void shouldHandleEmptyMultiRel() {
        VirtualNodeValue n1 = this.node(42L);
        PathValueBuilder builder = this.builder(new AnyValue[]{n1});
        builder.addNode(n1);
        builder.addMultipleUndirected(VirtualValues.EMPTY_LIST);
        Assertions.assertEquals((Object)this.path(new AnyValue[]{n1}), (Object)builder.build());
    }

    @Test
    void shouldHandleLongerPathWithMultiRel() {
        VirtualNodeValue n1 = this.node(42L);
        VirtualNodeValue n2 = this.node(43L);
        VirtualNodeValue n3 = this.node(44L);
        VirtualRelationshipValue r1 = this.relationship(1337L, n2, n1);
        VirtualRelationshipValue r2 = this.relationship(1338L, n2, n3);
        PathValueBuilder builder = this.builder(new AnyValue[]{n1, n2, n3, r1, r2});
        builder.addNode(n1);
        builder.addMultipleUndirected(VirtualValues.list((AnyValue[])new AnyValue[]{r1, r2}));
        Assertions.assertEquals((Object)this.path(new AnyValue[]{n1, r1, n2, r2, n3}), (Object)builder.build());
    }

    @Test
    void shouldHandleNoValue() {
        VirtualNodeValue node = this.node(42L);
        VirtualRelationshipValue relationship = this.relationship(1337L, this.node(43L), node);
        PathValueBuilder builder = this.builder(new AnyValue[]{node, relationship});
        builder.addNode(node);
        builder.addIncoming(relationship);
        builder.addUndirected((AnyValue)Values.NO_VALUE);
        Assertions.assertEquals((Object)Values.NO_VALUE, (Object)builder.build());
    }

    @Test
    void shouldHandleNoValueInMultiRel() {
        VirtualNodeValue node1 = this.node(42L);
        VirtualNodeValue node2 = this.node(43L);
        VirtualNodeValue node3 = this.node(44L);
        VirtualRelationshipValue relationship1 = this.relationship(1337L, node2, node1);
        VirtualRelationshipValue relationship2 = this.relationship(1338L, node2, node3);
        PathValueBuilder builder = this.builder(new AnyValue[]{node1, node2, node3, relationship1, relationship2});
        builder.addNode(node1);
        builder.addMultipleUndirected(VirtualValues.list((AnyValue[])new AnyValue[]{relationship1, relationship2, Values.NO_VALUE}));
        Assertions.assertEquals((Object)Values.NO_VALUE, (Object)builder.build());
    }

    @Test
    void shouldHandleLongerPathWithMultiRelWhereEndNodeIsKnown() {
        VirtualNodeValue n1 = this.node(42L);
        VirtualNodeValue n2 = this.node(43L);
        VirtualNodeValue n3 = this.node(44L);
        VirtualRelationshipValue r1 = this.relationship(1337L, n2, n1);
        VirtualRelationshipValue r2 = this.relationship(1338L, n2, n3);
        PathValueBuilder builder = this.builder(new AnyValue[]{n1, n2, n3, r1, r2});
        builder.addNode(n1);
        builder.addMultipleUndirected(VirtualValues.list((AnyValue[])new AnyValue[]{r1, r2}), n3);
        Assertions.assertEquals((Object)this.path(new AnyValue[]{n1, r1, n2, r2, n3}), (Object)builder.build());
    }

    private VirtualNodeValue node(long id) {
        return VirtualValues.node((long)id);
    }

    private VirtualRelationshipValue relationship(long id, VirtualNodeValue from, VirtualNodeValue to) {
        this.relations.put(id, new RelatedTo(from, to));
        return VirtualValues.relationship((long)id);
    }

    private PathReference path(AnyValue ... nodeAndRel) {
        VirtualNodeValue[] nodes = new VirtualNodeValue[nodeAndRel.length / 2 + 1];
        VirtualRelationshipValue[] rels = new VirtualRelationshipValue[nodeAndRel.length / 2];
        for (int i = 0; i < nodeAndRel.length; ++i) {
            if (i % 2 == 0) {
                nodes[i / 2] = (VirtualNodeValue)nodeAndRel[i];
                continue;
            }
            rels[i / 2] = (VirtualRelationshipValue)nodeAndRel[i];
        }
        return VirtualValues.pathReference(Arrays.asList(nodes), Arrays.asList(rels));
    }

    private PathValueBuilder builder(AnyValue ... values) {
        DbAccess dbAccess = (DbAccess)Mockito.mock(DbAccess.class);
        RelationshipScanCursor cursors = (RelationshipScanCursor)Mockito.mock(RelationshipScanCursor.class);
        for (AnyValue value : values) {
            if (value instanceof VirtualNodeValue) {
                VirtualNodeValue nodeValue = (VirtualNodeValue)value;
                Mockito.when((Object)dbAccess.nodeById(nodeValue.id())).thenReturn((Object)nodeValue);
            } else if (value instanceof VirtualRelationshipValue) {
                VirtualRelationshipValue relationshipValue = (VirtualRelationshipValue)value;
                Mockito.when((Object)dbAccess.relationshipById(relationshipValue.id())).thenReturn((Object)relationshipValue);
            } else {
                throw new AssertionError((Object)"invalid input");
            }
            ((DbAccess)Mockito.doAnswer(invocationOnMock -> {
                long id = (Long)invocationOnMock.getArgument(0);
                RelationshipScanCursor cursor = (RelationshipScanCursor)invocationOnMock.getArgument(1);
                RelatedTo relatedTo = this.relations.get(id);
                if (relatedTo != null) {
                    Mockito.when((Object)cursor.next()).thenReturn((Object)true);
                    Mockito.when((Object)cursor.sourceNodeReference()).thenReturn((Object)relatedTo.start.id());
                    Mockito.when((Object)cursor.targetNodeReference()).thenReturn((Object)relatedTo.end.id());
                }
                return null;
            }).when((Object)dbAccess)).singleRelationship(ArgumentMatchers.anyLong(), (RelationshipScanCursor)ArgumentMatchers.any(RelationshipScanCursor.class));
        }
        return new PathValueBuilder(dbAccess, cursors);
    }

    private static class RelatedTo {
        private final VirtualNodeValue start;
        private final VirtualNodeValue end;

        private RelatedTo(VirtualNodeValue start, VirtualNodeValue end) {
            this.start = start;
            this.end = end;
        }
    }
}

