/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.io.Serializable;
import java.util.function.LongPredicate;
import org.github.jamm.MemoryMeter;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Propagator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TargetTracker;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.PGStateBuilder;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.collection.compat.immutable.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u3Aa\u0002\u0005\u00013!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001a\u0001A\u0003%1\u0006C\u00035\u0001\u0011%Q\u0007C\u0003E\u0001\u0011%Q\tC\u0004R\u0001E\u0005I\u0011\u0002*\u0003\u001b9{G-Z*uCR,G+Z:u\u0015\tI!\"A\u0003qa\n47O\u0003\u0002\f\u0019\u0005IAO]1wKJ\u001c\u0018\r\u001c\u0006\u0003\u001b9\tq\u0001[3ma\u0016\u00148O\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012AB6fe:,GN\u0003\u0002\u0014)\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0016-\u0005)a.Z85U*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00015A\u00111dI\u0007\u00029)\u0011QDH\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003?\u0001\nA!\u001e;jY*\u00111#\t\u0006\u0003EQ\taaY=qQ\u0016\u0014\u0018B\u0001\u0013\u001d\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u0014\u0011\u0005!\u0002Q\"\u0001\u0005\u0002\u000b5,G/\u001a:\u0016\u0003-\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t)\fW.\u001c\u0006\u0003aY\taaZ5uQV\u0014\u0017B\u0001\u001a.\u0005-iU-\\8ss6+G/\u001a:\u0002\r5,G/\u001a:!\u0003A!W\rZ;qY&\u001c\u0017\r^3e'&TX\r\u0006\u00027yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t!Aj\u001c8h\u0011\u0015iD\u00011\u0001?\u0003\u0005y\u0007cA\u001c@\u0003&\u0011\u0001\t\u000f\u0002\u000byI,\u0007/Z1uK\u0012t\u0004CA\u001cC\u0013\t\u0019\u0005H\u0001\u0004B]f\u0014VMZ\u0001\fO2|'-\u00197Ti\u0006$X\r\u0006\u0002G\u0013B\u0011\u0001fR\u0005\u0003\u0011\"\u00111b\u00127pE\u0006d7\u000b^1uK\"9!*\u0002I\u0001\u0002\u0004Y\u0015AA7u!\tau*D\u0001N\u0015\tqE#\u0001\u0004nK6|'/_\u0005\u0003!6\u0013Q\"T3n_JLHK]1dW\u0016\u0014\u0018!F4m_\n\fGn\u0015;bi\u0016$C-\u001a4bk2$H%M\u000b\u0002'*\u00121\nV\u0016\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u0017\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002]/\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class NodeStateTest
extends CypherFunSuite {
    private final MemoryMeter meter = MemoryMeter.builder().build();

    private MemoryMeter meter() {
        return this.meter;
    }

    private long deduplicatedSize(Seq<Object> o) {
        return this.meter().measureDeep(o) - this.meter().measureDeep((Object)package$.MODULE$.ArraySeq().fill(o.size(), (Function0 & Serializable)() -> null, ClassTag$.MODULE$.Null()));
    }

    private GlobalState globalState(MemoryTracker mt) {
        PPBFSHooks.NULL$ hooks = PPBFSHooks.NULL$.MODULE$;
        return new GlobalState(new Propagator((MemoryTracker)EmptyMemoryTracker.INSTANCE, (PPBFSHooks)hooks), new TargetTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE, (PPBFSHooks)hooks), SearchMode.Unidirectional, mt, (PPBFSHooks)hooks, 1);
    }

    private MemoryTracker globalState$default$1() {
        return EmptyMemoryTracker.INSTANCE;
    }

    public NodeStateTest() {
        this.test("isTarget() returns true for a final state if there is no intoTarget", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PGStateBuilder stateBuilder = new PGStateBuilder();
            boolean x$1 = true;
            String x$2 = stateBuilder.newState$default$1();
            boolean x$3 = stateBuilder.newState$default$2();
            LongPredicate x$4 = stateBuilder.newState$default$4();
            PGStateBuilder.BuilderState state = stateBuilder.newState(x$2, x$3, true, x$4);
            NodeState nodeData = new NodeState(this.globalState(this.globalState$default$1()), 1L, state.state(), -1L, Lengths.trailMode());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)nodeData.isTarget()), new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("isTarget() returns false if intoTarget does not match the node", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PGStateBuilder stateBuilder = new PGStateBuilder();
            boolean x$5 = true;
            String x$6 = stateBuilder.newState$default$1();
            boolean x$7 = stateBuilder.newState$default$2();
            LongPredicate x$8 = stateBuilder.newState$default$4();
            PGStateBuilder.BuilderState state = stateBuilder.newState(x$6, x$7, true, x$8);
            NodeState nodeData = new NodeState(this.globalState(this.globalState$default$1()), 1L, state.state(), 2L, Lengths.trailMode());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)nodeData.isTarget()), new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("isTarget() returns true if intoTarget matches the node", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PGStateBuilder stateBuilder = new PGStateBuilder();
            boolean x$9 = true;
            String x$10 = stateBuilder.newState$default$1();
            boolean x$11 = stateBuilder.newState$default$2();
            LongPredicate x$12 = stateBuilder.newState$default$4();
            PGStateBuilder.BuilderState state = stateBuilder.newState(x$10, x$11, true, x$12);
            NodeState nodeData = new NodeState(this.globalState(this.globalState$default$1()), 1L, state.state(), 1L, Lengths.trailMode());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)nodeData.isTarget()), new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("memory allocation on construction", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalMemoryTracker mt = new LocalMemoryTracker();
            PGStateBuilder qual$1 = new PGStateBuilder();
            String x$13 = qual$1.newState$default$1();
            boolean x$14 = qual$1.newState$default$2();
            boolean x$15 = qual$1.newState$default$3();
            LongPredicate x$16 = qual$1.newState$default$4();
            State state = qual$1.newState(x$13, x$14, x$15, x$16).state();
            GlobalState gs = this.globalState((MemoryTracker)mt);
            NodeState ns = new NodeState(gs, 0L, state, -1L, Lengths.trailMode());
            long actual = this.meter().measureDeep((Object)ns) - this.deduplicatedSize((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{gs, state}));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)mt.estimatedHeapMemory()), new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)actual));
        }, new Position("NodeStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }
}

