/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.collection;

import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.cypher.internal.collection.DefaultComparatorSortTable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class DefaultComparatorSortTableTest {
    @Inject
    private RandomSupport random;
    private static final List<Long> TEST_VALUES = List.of(7L, 4L, 5L, 0L, 3L, 4L, 8L, 6L, 1L, 9L, 2L);
    private static final long[] EXPECTED_VALUES = new long[]{0L, 1L, 2L, 3L, 4L, 4L, 5L, 6L, 7L, 8L, 9L};
    private static final Comparator<MeasurableLong> comparator = Comparator.comparingLong(MeasurableLong::getValue);
    private static final long MEASURABLE_LONG_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MeasurableLong.class);

    DefaultComparatorSortTableTest() {
    }

    @Test
    void shouldHandleAddingMoreValuesThanCapacity() {
        DefaultComparatorSortTable table = new DefaultComparatorSortTable(comparator, 7);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        for (int i = 0; i < EXPECTED_VALUES.length; ++i) {
            MeasurableLong next = (MeasurableLong)table.poll();
            Assertions.assertNotNull((Object)next);
            long value = next.getValue();
            Assertions.assertEquals((long)EXPECTED_VALUES[i], (long)value);
        }
        DefaultComparatorSortTableTest.assertEmpty(table);
    }

    @Test
    void shouldHandleWhenNotCompletelyFilledToCapacity() {
        DefaultComparatorSortTable table = new DefaultComparatorSortTable(comparator, 20);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        for (int i = 0; i < TEST_VALUES.size(); ++i) {
            MeasurableLong next = (MeasurableLong)table.poll();
            Assertions.assertNotNull((Object)next);
            long value = next.getValue();
            Assertions.assertEquals((long)EXPECTED_VALUES[i], (long)value);
        }
        DefaultComparatorSortTableTest.assertEmpty(table);
    }

    @Test
    void shouldHandleWhenEmpty() {
        DefaultComparatorSortTable table = new DefaultComparatorSortTable(comparator, 10);
        DefaultComparatorSortTableTest.assertEmpty(table);
    }

    @Test
    void shouldThrowOnInitializeToZeroCapacity() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultComparatorSortTable(comparator, 0));
    }

    @Test
    void shouldThrowOnInitializeToNegativeCapacity() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultComparatorSortTable(comparator, -1));
    }

    @Test
    void boundCheck() {
        DefaultComparatorSortTable sortTable = new DefaultComparatorSortTable(comparator, 5);
        Assertions.assertThrows(NoSuchElementException.class, () -> sortTable.unorderedIterator().next());
    }

    @Test
    void randomizedTest() {
        int i;
        int n = this.random.nextInt(1000, 5000);
        DefaultComparatorSortTable table = new DefaultComparatorSortTable(Long::compareTo, n);
        PriorityQueue<Long> priorityQueue = new PriorityQueue<Long>(Long::compareTo);
        for (int i2 = 0; i2 < n; ++i2) {
            long l = this.random.nextInt(n / 10);
            table.add((Object)l);
            DefaultComparatorSortTableTest.add(priorityQueue, l, n);
        }
        Assertions.assertEquals((int)n, (int)priorityQueue.size());
        long[] longsFromTable = new long[n];
        for (int i3 = 0; i3 < n; ++i3) {
            longsFromTable[i3] = (Long)table.poll();
        }
        DefaultComparatorSortTableTest.assertEmpty(table);
        long[] longsFromPriorityQueue = new long[n];
        for (i = 0; i < n; ++i) {
            longsFromPriorityQueue[i] = priorityQueue.poll();
        }
        Assertions.assertTrue((boolean)priorityQueue.isEmpty());
        for (i = 0; i < n; ++i) {
            Assertions.assertEquals((long)longsFromPriorityQueue[i], (long)longsFromTable[i]);
        }
    }

    @Test
    void shouldHandleAddingValuesAfterReset() {
        DefaultComparatorSortTable table = new DefaultComparatorSortTable(comparator, 20);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong(l * 100L)));
        table.reset();
        Assertions.assertEquals((int)0, (int)table.getSize());
        Assertions.assertTrue((boolean)table.isEmpty());
        Assertions.assertNull((Object)table.peek());
        Assertions.assertNull((Object)table.poll());
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        for (int i = 0; i < TEST_VALUES.size(); ++i) {
            MeasurableLong next = (MeasurableLong)table.poll();
            Assertions.assertNotNull((Object)next);
            long value = next.getValue();
            Assertions.assertEquals((long)EXPECTED_VALUES[i], (long)value);
        }
        DefaultComparatorSortTableTest.assertEmpty(table);
    }

    private static void add(PriorityQueue<Long> priorityQueue, long e, int limit) {
        if (priorityQueue.size() < limit) {
            priorityQueue.offer(e);
        } else {
            long head = priorityQueue.peek();
            if (head > e) {
                priorityQueue.poll();
                priorityQueue.offer(e);
            }
        }
    }

    private static void assertEmpty(DefaultComparatorSortTable<?> table) {
        Assertions.assertTrue((boolean)table.isEmpty());
        Assertions.assertEquals((int)0, (int)table.getSize());
        Assertions.assertNull((Object)table.peek());
        Assertions.assertNull((Object)table.poll());
    }

    private static class MeasurableLong
    implements Measurable {
        private final long value;

        private MeasurableLong(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public long estimatedHeapUsage() {
            return MEASURABLE_LONG_SHALLOW_SIZE;
        }
    }
}

