/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.kernel.api.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.helpers.TransactionDependenciesResolver;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.impl.api.TestKernelTransactionHandle;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.Clocks;
import org.neo4j.values.virtual.VirtualValues;

class TransactionDependenciesResolverTest {
    TransactionDependenciesResolverTest() {
    }

    @Test
    void detectIndependentTransactionsAsNotBlocked() {
        HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>> map = new HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>>();
        TestKernelTransactionHandleWithLocks handle1 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        TestKernelTransactionHandleWithLocks handle2 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        map.put(handle1, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(1L)));
        map.put(handle2, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(2L)));
        TransactionDependenciesResolver resolver = new TransactionDependenciesResolver(map);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)resolver.isBlocked((KernelTransactionHandle)handle1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)resolver.isBlocked((KernelTransactionHandle)handle2));
    }

    @Test
    void detectBlockedTransactionsByExclusiveLock() {
        HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>> map = new HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>>();
        TestKernelTransactionHandleWithLocks handle1 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class), 0L, Collections.singletonList(new ActiveLock(ResourceType.NODE, LockType.EXCLUSIVE, 1L, 1L)));
        TestKernelTransactionHandleWithLocks handle2 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        map.put(handle1, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(1L)));
        map.put(handle2, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshotWaitingForLock(2L, LockType.SHARED, ResourceType.NODE, 1L, 1L)));
        TransactionDependenciesResolver resolver = new TransactionDependenciesResolver(map);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)resolver.isBlocked((KernelTransactionHandle)handle1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)resolver.isBlocked((KernelTransactionHandle)handle2));
    }

    @Test
    void detectBlockedTransactionsBySharedLock() {
        HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>> map = new HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>>();
        TestKernelTransactionHandleWithLocks handle1 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class), 0L, Collections.singletonList(new ActiveLock(ResourceType.NODE, LockType.SHARED, 1L, 1L)));
        TestKernelTransactionHandleWithLocks handle2 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        map.put(handle1, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(1L)));
        map.put(handle2, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshotWaitingForLock(2L, LockType.EXCLUSIVE, ResourceType.NODE, 1L, 1L)));
        TransactionDependenciesResolver resolver = new TransactionDependenciesResolver(map);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)resolver.isBlocked((KernelTransactionHandle)handle1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)resolver.isBlocked((KernelTransactionHandle)handle2));
    }

    @Test
    void blockingChainDescriptionForIndependentTransactionsIsEmpty() {
        HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>> map = new HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>>();
        TestKernelTransactionHandleWithLocks handle1 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        TestKernelTransactionHandleWithLocks handle2 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        map.put(handle1, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(1L)));
        map.put(handle2, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(2L)));
        TransactionDependenciesResolver resolver = new TransactionDependenciesResolver(map);
        Assertions.assertThat((String)resolver.describeBlockingTransactions((KernelTransactionHandle)handle1)).isEmpty();
        Assertions.assertThat((String)resolver.describeBlockingTransactions((KernelTransactionHandle)handle2)).isEmpty();
    }

    @Test
    void blockingChainDescriptionForDirectlyBlockedTransaction() {
        HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>> map = new HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>>();
        TestKernelTransactionHandleWithLocks handle1 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class), 3L, Collections.singletonList(new ActiveLock(ResourceType.NODE, LockType.EXCLUSIVE, 1L, 1L)));
        TestKernelTransactionHandleWithLocks handle2 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class));
        map.put(handle1, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(1L)));
        map.put(handle2, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshotWaitingForLock(2L, LockType.SHARED, ResourceType.NODE, 1L, 1L)));
        TransactionDependenciesResolver resolver = new TransactionDependenciesResolver(map);
        Assertions.assertThat((String)resolver.describeBlockingTransactions((KernelTransactionHandle)handle1)).isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[transaction-3]", (Object)resolver.describeBlockingTransactions((KernelTransactionHandle)handle2));
    }

    @Test
    void blockingChainDescriptionForChainedBlockedTransaction() {
        HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>> map = new HashMap<TestKernelTransactionHandleWithLocks, Optional<QuerySnapshot>>();
        TestKernelTransactionHandleWithLocks handle1 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class), 4L, Collections.singletonList(new ActiveLock(ResourceType.NODE, LockType.EXCLUSIVE, 4L, 1L)));
        TestKernelTransactionHandleWithLocks handle2 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class), 5L, Collections.singletonList(new ActiveLock(ResourceType.NODE, LockType.SHARED, 5L, 2L)));
        TestKernelTransactionHandleWithLocks handle3 = new TestKernelTransactionHandleWithLocks((KernelTransaction)Mockito.mock(KernelTransaction.class), 6L);
        map.put(handle1, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshot(1L)));
        map.put(handle2, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshotWaitingForLock(2L, LockType.EXCLUSIVE, ResourceType.NODE, 5L, 1L)));
        map.put(handle3, Optional.of(TransactionDependenciesResolverTest.createQuerySnapshotWaitingForLock(3L, LockType.EXCLUSIVE, ResourceType.NODE, 6L, 2L)));
        TransactionDependenciesResolver resolver = new TransactionDependenciesResolver(map);
        Assertions.assertThat((String)resolver.describeBlockingTransactions((KernelTransactionHandle)handle1)).isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[transaction-4]", (Object)resolver.describeBlockingTransactions((KernelTransactionHandle)handle2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[transaction-4, transaction-5]", (Object)resolver.describeBlockingTransactions((KernelTransactionHandle)handle3));
    }

    private static QuerySnapshot createQuerySnapshot(long queryId) {
        return TransactionDependenciesResolverTest.createExecutingQuery(queryId).snapshot();
    }

    private static QuerySnapshot createQuerySnapshotWaitingForLock(long queryId, LockType lockType, ResourceType resourceType, long transactionId, long id) {
        ExecutingQuery executingQuery = TransactionDependenciesResolverTest.createExecutingQuery(queryId);
        executingQuery.lockTracer().waitForLock(lockType, resourceType, transactionId, new long[]{id});
        return executingQuery.snapshot();
    }

    private static ExecutingQuery createExecutingQuery(long queryId) {
        return new ExecutingQuery(queryId, ClientConnectionInfo.EMBEDDED_CONNECTION, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()), "test", "test", "testQuery", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> 1L, () -> 1L, () -> 2L, Thread.currentThread().getId(), Thread.currentThread().getName(), LockTracer.NONE, Clocks.nanoClock(), CpuClock.NOT_AVAILABLE);
    }

    private static class TestKernelTransactionHandleWithLocks
    extends TestKernelTransactionHandle {
        private final long userTxId;
        private final List<ActiveLock> locks;

        TestKernelTransactionHandleWithLocks(KernelTransaction tx) {
            this(tx, 0L, Collections.emptyList());
        }

        TestKernelTransactionHandleWithLocks(KernelTransaction tx, long userTxId) {
            this(tx, userTxId, Collections.emptyList());
        }

        TestKernelTransactionHandleWithLocks(KernelTransaction tx, long userTxId, List<ActiveLock> locks) {
            super(tx);
            this.userTxId = userTxId;
            this.locks = locks;
        }

        public Collection<ActiveLock> activeLocks() {
            return this.locks;
        }

        public long getTransactionSequenceNumber() {
            return this.userTxId;
        }
    }
}

