/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.ClosingIteratorTest$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.StructuralCallSite;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\u0014)\u0001MBQ\u0001\u0010\u0001\u0005\u0002u:Q\u0001\u0011\u0015\t\u0002\u00053Qa\n\u0015\t\u0002\tCQ\u0001P\u0002\u0005\u0002E3QAU\u0002\u0002\u0002MCQ\u0001P\u0003\u0005\u0002\rDqAZ\u0003A\u0002\u0013\u0005q\rC\u0004l\u000b\u0001\u0007I\u0011\u00017\t\rI,\u0001\u0015)\u0003i\u0011\u0015\u0019X\u0001\"\u0011u\u0011\u0015)8\u0001\"\u0001w\u0011\u0019y8\u0001\"\u0001\u0002\u0002\u00191\u0011qB\u0002A\u0003#A!\"!\u0010\u000e\u0005+\u0007I\u0011AA \u0011)\t\u0019%\u0004B\tB\u0003%\u0011\u0011\t\u0005\u0007y5!\t!!\u0012\t\u0011\u0005-S\u00021A\u0005\u0002\u001dD\u0011\"!\u0014\u000e\u0001\u0004%\t!a\u0014\t\u000f\u0005MS\u0002)Q\u0005Q\"9\u0011QK\u0007\u0005B\u0005]\u0003\"CA-\u001b\u0005\u0005I\u0011AA.\u0011%\tI'DI\u0001\n\u0003\tY\u0007C\u0005\u0002\u00066\t\t\u0011\"\u0011\u0002\b\"I\u0011QS\u0007\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003?k\u0011\u0011!C\u0001\u0003CC\u0011\"!*\u000e\u0003\u0003%\t%a*\t\u0013\u0005UV\"!A\u0005\u0002\u0005]\u0006\"CA^\u001b\u0005\u0005I\u0011IA_\u0011%\t\t-DA\u0001\n\u0003\n\u0019\rC\u0005\u0002F6\t\t\u0011\"\u0011\u0002H\u001eI\u00111Z\u0002\u0002\u0002#\u0005\u0011Q\u001a\u0004\n\u0003\u001f\u0019\u0011\u0011!E\u0001\u0003\u001fDa\u0001\u0010\u0011\u0005\u0002\u0005E\u0007\"CAjA\u0005\u0005IQIAk\u0011%\t)\u0006IA\u0001\n\u0003\u000b9\u000eC\u0005\u0002f\u0002\n\t\u0011\"!\u0002h\"I\u0011Q \u0011\u0002\u0002\u0013%\u0011q \u0005\n\u0003{\u001c\u0011\u0011!C\u0005\u0003\u007f\u00141c\u00117pg&tw-\u0013;fe\u0006$xN\u001d+fgRT!!\u000b\u0016\u0002\u000fI,h\u000e^5nK*\u00111\u0006L\u0001\tS:$XM\u001d8bY*\u0011QFL\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0002\u0014!\u00028f_RR'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\tI$&\u0001\u0003vi&d\u0017BA\u001e7\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001 \u0011\u0005}\u0002Q\"\u0001\u0015\u0002'\rcwn]5oO&#XM]1u_J$Vm\u001d;\u0011\u0005}\u001a1cA\u0002D\u0013B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u0005%|'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\u0012!\u0011\u0002\u0014)\u0016\u001cHo\u00117pg&tw-\u0013;fe\u0006$xN]\u000b\u0003)j\u001b\"!B+\u0011\u0007}2\u0006,\u0003\u0002XQ\ty1\t\\8tS:<\u0017\n^3sCR|'\u000f\u0005\u0002Z52\u0001AAB.\u0006\t\u000b\u0007ALA\u0001U#\ti\u0006\r\u0005\u0002E=&\u0011q,\u0012\u0002\b\u001d>$\b.\u001b8h!\t!\u0015-\u0003\u0002c\u000b\n\u0019\u0011I\\=\u0015\u0003\u0011\u00042!Z\u0003Y\u001b\u0005\u0019\u0011AB2m_N,G-F\u0001i!\t!\u0015.\u0003\u0002k\u000b\n9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u0011Q\u000e\u001d\t\u0003\t:L!a\\#\u0003\tUs\u0017\u000e\u001e\u0005\bc\"\t\t\u00111\u0001i\u0003\rAH%M\u0001\bG2|7/\u001a3!\u0003%\u0019Gn\\:f\u001b>\u0014X\rF\u0001n\u0003\u00191\u0018\r\\;fgV\u0011qO\u001f\u000b\u0003qn\u00042!Z\u0003z!\tI&\u0010B\u0003\\\u0017\t\u0007A\fC\u0003v\u0017\u0001\u0007A\u0010E\u0002E{fL!A`#\u0003\u0015q\u0012X\r]3bi\u0016$g(A\u0004g_J,g/\u001a:\u0016\t\u0005\r\u0011\u0011\u0002\u000b\u0005\u0003\u000b\tY\u0001\u0005\u0003f\u000b\u0005\u001d\u0001cA-\u0002\n\u0011)1\f\u0004b\u00019\"9\u0011Q\u0002\u0007A\u0002\u0005\u001d\u0011!\u0002<bYV,'\u0001\u0004+fgR\u001cV\u000f\u001d9mS\u0016\u0014X\u0003BA\n\u0003?\u0019\u0002\"D\"\u0002\u0016\u0005\u0005\u0012q\u0005\t\u0006\t\u0006]\u00111D\u0005\u0004\u00033)%!\u0003$v]\u000e$\u0018n\u001c81!\u0011yd+!\b\u0011\u0007e\u000by\u0002B\u0003\\\u001b\t\u0007A\fE\u0002E\u0003GI1!!\nF\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u000b\u0002:9!\u00111FA\u001b\u001d\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019e\u00051AH]8pizJ\u0011AR\u0005\u0004\u0003o)\u0015a\u00029bG.\fw-Z\u0005\u0004!\u0006m\"bAA\u001c\u000b\u0006!\u0011\u000e^3s+\t\t\t\u0005\u0005\u0003f\u000b\u0005u\u0011!B5uKJ\u0004C\u0003BA$\u0003\u0013\u0002B!Z\u0007\u0002\u001e!9\u0011Q\b\tA\u0002\u0005\u0005\u0013AB5t+N,G-\u0001\u0006jgV\u001bX\rZ0%KF$2!\\A)\u0011\u001d\t(#!AA\u0002!\fq![:Vg\u0016$\u0007%A\u0003baBd\u0017\u0010\u0006\u0002\u0002\u001c\u0005!1m\u001c9z+\u0011\ti&a\u0019\u0015\t\u0005}\u0013Q\r\t\u0005K6\t\t\u0007E\u0002Z\u0003G\"QaW\u000bC\u0002qC\u0011\"!\u0010\u0016!\u0003\u0005\r!a\u001a\u0011\t\u0015,\u0011\u0011M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\ti'a!\u0016\u0005\u0005=$\u0006BA!\u0003cZ#!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{*\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011QA<\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u00067Z\u0011\r\u0001X\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=U*\u0001\u0003mC:<\u0017\u0002BAJ\u0003\u001b\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAM!\r!\u00151T\u0005\u0004\u0003;+%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00011\u0002$\"A\u0011/GA\u0001\u0002\u0004\tI*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000bE\u0003\u0002,\u0006E\u0006-\u0004\u0002\u0002.*\u0019\u0011qV#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00024\u00065&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001[A]\u0011\u001d\t8$!AA\u0002\u0001\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011RA`\u0011!\tH$!AA\u0002\u0005e\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0015AB3rk\u0006d7\u000fF\u0002i\u0003\u0013Dq!\u001d\u0010\u0002\u0002\u0003\u0007\u0001-\u0001\u0007UKN$8+\u001e9qY&,'\u000f\u0005\u0002fAM\u0019\u0001eQ%\u0015\u0005\u00055\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%U\u0003BAm\u0003?$B!a7\u0002bB!Q-DAo!\rI\u0016q\u001c\u0003\u00067\u000e\u0012\r\u0001\u0018\u0005\b\u0003{\u0019\u0003\u0019AAr!\u0011)W!!8\u0002\u000fUt\u0017\r\u001d9msV!\u0011\u0011^A{)\u0011\tY/a>\u0011\u000b\u0011\u000bi/!=\n\u0007\u0005=XI\u0001\u0004PaRLwN\u001c\t\u0005K\u0016\t\u0019\u0010E\u0002Z\u0003k$Qa\u0017\u0013C\u0002qC\u0011\"!?%\u0003\u0003\u0005\r!a?\u0002\u0007a$\u0003\u0007\u0005\u0003f\u001b\u0005M\u0018\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0001!\u0011\tYIa\u0001\n\t\t\u0015\u0011Q\u0012\u0002\u0007\u001f\nTWm\u0019;")
public class ClosingIteratorTest
extends CypherFunSuite {
    public static <T> TestClosingIterator<T> forever(T value) {
        return ClosingIteratorTest$.MODULE$.forever(value);
    }

    public static <T> TestClosingIterator<T> values(Seq<T> values) {
        return ClosingIteratorTest$.MODULE$.values(values);
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closed", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closed", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        CallSite methodCache3 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method3 = methodCache3.find(x$1);
        if (method3 != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closeCount", methodCache3.parameterTypes()));
        methodCache3.add(x$1, method3);
        return method3;
    }

    public static Method reflMethod$Method4(Class x$1) {
        CallSite methodCache4 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method4 = methodCache4.find(x$1);
        if (method4 != null) {
            return method4;
        }
        method4 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closeCount", methodCache4.parameterTypes()));
        methodCache4.add(x$1, method4);
        return method4;
    }

    public static final /* synthetic */ TestClosingIterator $anonfun$new$9(Iterator nextInner$1, int x$3) {
        return (TestClosingIterator)((Object)nextInner$1.next());
    }

    public static final /* synthetic */ ClosingIterator $anonfun$new$11(ClosingIterator nextInner$2, int x$4) {
        return (ClosingIterator)nextInner$2.next();
    }

    private static final TestClosingIterator countingValues$1(Seq v, IntRef c$1) {
        ++c$1.elem;
        return ClosingIteratorTest$.MODULE$.values(v);
    }

    private static final TestClosingIterator rememberingValues$1(Seq v, BooleanRef created$1) {
        created$1.elem = true;
        return ClosingIteratorTest$.MODULE$.values(v);
    }

    public ClosingIteratorTest() {
        this.test("closes resources when depleted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object object;
            AutoCloseable resource = new AutoCloseable(null){
                private boolean closed;

                public boolean closed() {
                    return this.closed;
                }

                public void closed_$eq(boolean x$1) {
                    this.closed = x$1;
                }

                public void close() {
                    this.closed_$eq(true);
                }
                {
                    this.closed = false;
                }
            };
            ClosingIterator iter = ClosingIterator$.MODULE$.empty().closing(resource);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            AutoCloseable qual1 = resource;
            try {
                object = ClosingIteratorTest.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Boolean)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("closeMore when depleted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object object;
            ClosingIterator<Object> iter = new ClosingIterator<Object>(null){
                private boolean closed;

                public boolean closed() {
                    return this.closed;
                }

                public void closed_$eq(boolean x$1) {
                    this.closed = x$1;
                }

                public boolean innerHasNext() {
                    return false;
                }

                public void closeMore() {
                    this.closed_$eq(true);
                }

                public int next() {
                    return 0;
                }
                {
                    this.closed = false;
                }
            };
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            ClosingIterator<Object> qual2 = iter;
            try {
                object = ClosingIteratorTest.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Boolean)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("closes resources only once", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object object;
            AutoCloseable resource = new AutoCloseable(null){
                private int closeCount;

                public int closeCount() {
                    return this.closeCount;
                }

                public void closeCount_$eq(int x$1) {
                    this.closeCount = x$1;
                }

                public void close() {
                    this.closeCount_$eq(this.closeCount() + 1);
                }
                {
                    this.closeCount = 0;
                }
            };
            ClosingIterator iter = ClosingIterator$.MODULE$.empty().closing(resource);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            iter.close();
            iter.close();
            AutoCloseable qual3 = resource;
            try {
                object = ClosingIteratorTest.reflMethod$Method3(qual3.getClass()).invoke((Object)qual3, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Integer)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("closeMore only once", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object object;
            ClosingIterator<Object> iter = new ClosingIterator<Object>(null){
                private int closeCount;

                public int closeCount() {
                    return this.closeCount;
                }

                public void closeCount_$eq(int x$1) {
                    this.closeCount = x$1;
                }

                public boolean innerHasNext() {
                    return false;
                }

                public void closeMore() {
                    this.closeCount_$eq(this.closeCount() + 1);
                }

                public int next() {
                    return 0;
                }
                {
                    this.closeCount = 0;
                }
            };
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            iter.close();
            iter.close();
            ClosingIterator<Object> qual4 = iter;
            try {
                object = ClosingIteratorTest.reflMethod$Method4(qual4.getClass()).invoke((Object)qual4, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Integer)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("flatMap explicit close closes current inner", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator<Integer> outer = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)0));
            TestClosingIterator<Integer> inner = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)1));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable)x$1 -> inner);
            package$.MODULE$.Range().apply(0, 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)x$2 -> {
                flatMapped.hasNext();
                return BoxesRunTime.unboxToInt((Object)flatMapped.next());
            });
            flatMapped.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("flatMap inner iterators are closed when depleted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator<Integer> outer = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)0));
            TestClosingIterator inner1 = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            TestClosingIterator<Integer> inner2 = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)2));
            Iterator nextInner = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestClosingIterator[]{inner1, inner2}));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable)x$3 -> ClosingIteratorTest.$anonfun$new$9(nextInner, BoxesRunTime.unboxToInt((Object)x$3)));
            flatMapped.hasNext();
            flatMapped.next();
            flatMapped.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner1.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("flatMap inner iterators of mixed types are closed when depleted and on explicit closed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator<Integer> outer = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)0));
            TestClosingIterator inner1 = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            ClosingIterator inner2 = ClosingIterator$.MODULE$.asClosingIterator((IterableOnce)Option$.MODULE$.empty());
            ClosingIterator inner3 = ClosingIterator$.MODULE$.asClosingIterator((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 3})));
            TestClosingIterator<Integer> inner4 = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)4));
            ClosingIterator nextInner = ClosingIterator$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClosingIterator[]{inner1, inner2, inner3, inner4}));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable)x$4 -> ClosingIteratorTest.$anonfun$new$11(nextInner, BoxesRunTime.unboxToInt((Object)x$4)));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner1.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner4.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            flatMapped.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner4.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("flatMap outer and inner iterators are closed when depleted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            TestClosingIterator inner = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable)x$5 -> inner);
            flatMapped.hasNext();
            flatMapped.next();
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("flatMap with empty outer should not call inner lambda", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            ClosingIterator outer = ClosingIterator$.MODULE$.empty();
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable)x$6 -> this.fail("should not call inner lambda", new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162)));
            return flatMapped.hasNext();
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("filter should close when depleted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            ClosingIterator filtered = outer.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> false);
            filtered.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("filter should not close in the middle", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
            ClosingIterator filtered = outer.filter((Function1)(JFunction1.mcZI.sp & Serializable)i -> i % 2 == 0);
            filtered.hasNext();
            filtered.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            filtered.hasNext();
            filtered.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            filtered.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("map should close on explicit close", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            ClosingIterator mapped = outer.map((Function1)(JFunction1.mcII.sp & Serializable)i -> i + 1);
            mapped.hasNext();
            mapped.next();
            mapped.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("addAllLazy closes when depleted and returns correct results", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
            ClosingIterator concatted = first.addAllLazy(second);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.iter().closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("addAllLazy when first is empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(Nil$.MODULE$);
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
            ClosingIterator concatted = first.addAllLazy(second);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.iter().closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("addAllLazy when second is empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}));
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(Nil$.MODULE$));
            ClosingIterator concatted = first.addAllLazy(second);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.iter().closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("addAllLazy closes on explicit close while iterating over second", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
            ClosingIterator concatted = first.addAllLazy(second);
            concatted.next();
            concatted.next();
            concatted.next();
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.iter().closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("addAllLazy close should not regenerate iterator", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IntRef c = IntRef.create((int)0);
            ClosingIterator concatted = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})).addAllLazy((Function0 & Serializable)() -> ClosingIteratorTest.countingValues$1((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}), c));
            concatted.next();
            concatted.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290), Prettifier$.MODULE$.default()).should(this.be().apply(false));
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295), Prettifier$.MODULE$.default()).should(this.be().apply(false));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)c.elem), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        this.test("addAllLazy close should not eagerize second iterator", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BooleanRef created = BooleanRef.create((boolean)false);
            ClosingIterator concatted = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})).addAllLazy((Function0 & Serializable)() -> ClosingIteratorTest.rememberingValues$1((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}), created));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)created.elem), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            concatted.next();
            concatted.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)created.elem), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("addAllLazy close should not close rhs if not initialised", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
            ClosingIterator concatted = first.addAllLazy(second);
            concatted.next();
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("addAllLazy close should close rhs if initialised", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
            ClosingIterator concatted = first.addAllLazy(second);
            concatted.next();
            concatted.next();
            concatted.next();
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.iter().closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        this.test("addAllLazy close should close rhs if initialised 2", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestSupplier second = new TestSupplier(ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
            ClosingIterator concatted = first.addAllLazy(second);
            concatted.next();
            concatted.next();
            concatted.hasNext();
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.isUsed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.iter().closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("single returns one element", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ClosingIterator single = ClosingIterator$.MODULE$.single((Object)BoxesRunTime.boxToInteger((int)1));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)single.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(single.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)single.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        this.test("collect should close on explicit close", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "and", BoxesRunTime.boxToInteger((int)2), "and", BoxesRunTime.boxToInteger((int)3)}));
            ClosingIterator collected = outer.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt(A1);
                        return (B1)BoxesRunTime.boxToInteger((int)n);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof Integer;
                }
            });
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)collected.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            collected.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("collect should close on exhaustion", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "and", BoxesRunTime.boxToInteger((int)2), "and", BoxesRunTime.boxToInteger((int)3)}));
            ClosingIterator collected = outer.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt(A1);
                        return (B1)BoxesRunTime.boxToInteger((int)n);
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    return object instanceof Integer;
                }
            });
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)collected.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(collected.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)collected.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(collected.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)collected.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(collected.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)collected.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        this.test("collect with empty outer should not call inner lambda", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ClosingIterator outer = ClosingIterator$.MODULE$.empty();
            ClosingIterator collected = outer.collect((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ ClosingIteratorTest $outer;

                public final <A1 extends Nothing$, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    throw this.$outer.fail("should not call inner lambda", new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
                }

                public final boolean isDefinedAt(Nothing$ x3) {
                    Nothing$ nothing$ = x3;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)collected.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
    }

    public static abstract class TestClosingIterator<T>
    extends ClosingIterator<T> {
        private boolean closed = false;

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void closeMore() {
            this.closed_$eq(true);
        }
    }

    public static class TestSupplier<T>
    implements Function0<ClosingIterator<T>>,
    Product,
    Serializable {
        private final TestClosingIterator<T> iter;
        private boolean isUsed;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean apply$mcZ$sp() {
            return Function0.apply$mcZ$sp$((Function0)this);
        }

        public byte apply$mcB$sp() {
            return Function0.apply$mcB$sp$((Function0)this);
        }

        public char apply$mcC$sp() {
            return Function0.apply$mcC$sp$((Function0)this);
        }

        public double apply$mcD$sp() {
            return Function0.apply$mcD$sp$((Function0)this);
        }

        public float apply$mcF$sp() {
            return Function0.apply$mcF$sp$((Function0)this);
        }

        public int apply$mcI$sp() {
            return Function0.apply$mcI$sp$((Function0)this);
        }

        public long apply$mcJ$sp() {
            return Function0.apply$mcJ$sp$((Function0)this);
        }

        public short apply$mcS$sp() {
            return Function0.apply$mcS$sp$((Function0)this);
        }

        public void apply$mcV$sp() {
            Function0.apply$mcV$sp$((Function0)this);
        }

        public String toString() {
            return Function0.toString$((Function0)this);
        }

        public TestClosingIterator<T> iter() {
            return this.iter;
        }

        public boolean isUsed() {
            return this.isUsed;
        }

        public void isUsed_$eq(boolean x$1) {
            this.isUsed = x$1;
        }

        public ClosingIterator<T> apply() {
            Predef$.MODULE$.assert(!this.isUsed());
            this.isUsed_$eq(true);
            return this.iter();
        }

        public <T> TestSupplier<T> copy(TestClosingIterator<T> iter) {
            return new TestSupplier<T>(iter);
        }

        public <T> TestClosingIterator<T> copy$default$1() {
            return this.iter();
        }

        public String productPrefix() {
            return "TestSupplier";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.iter();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestSupplier;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "iter";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestSupplier)) return false;
            boolean bl = true;
            if (!bl) return false;
            TestSupplier testSupplier = (TestSupplier)x$1;
            TestClosingIterator<T> testClosingIterator = this.iter();
            TestClosingIterator<T> testClosingIterator2 = testSupplier.iter();
            if (testClosingIterator == null) {
                if (testClosingIterator2 != null) {
                    return false;
                }
            } else if (!((Object)testClosingIterator).equals(testClosingIterator2)) return false;
            if (!testSupplier.canEqual(this)) return false;
            return true;
        }

        public TestSupplier(TestClosingIterator<T> iter) {
            this.iter = iter;
            Function0.$init$((Function0)this);
            Product.$init$((Product)this);
            this.isUsed = false;
        }
    }
}

