/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.runtime.DummyResource;
import org.neo4j.cypher.internal.runtime.DummyResource$;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.ResourceManager$;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.SingleThreadedResourcePool;
import org.neo4j.cypher.internal.runtime.ThrowingDummyResource;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Containing$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005m1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\t\u0019\"+Z:pkJ\u001cW-T1oC\u001e,'\u000fV3ti*\u0011A!B\u0001\beVtG/[7f\u0015\t1q!\u0001\u0005j]R,'O\\1m\u0015\tA\u0011\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u0015-\tQA\\3pi)T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0001\"\u0001E\u000b\u000e\u0003EQ!AE\n\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005Q)\u0011\u0001B;uS2L!AF\t\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011a\u0001")
public class ResourceManagerTest
extends CypherFunSuite {
    public static final /* synthetic */ Assertion $anonfun$new$13(ResourceManagerTest $this, DummyResource[] resources$2, SingleThreadedResourcePool pool$1, int i) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])resources$2), (Function1 & Serializable)resource -> {
            pool$1.add(resource);
            return BoxedUnit.UNIT;
        });
        DummyResource toRemove = resources$2[i];
        pool$1.remove((AutoCloseablePlus)toRemove);
        List closeables = pool$1.all().toList();
        $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)closeables.size()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
        return $this.convertToAnyShouldWrapper(closeables, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206), Prettifier$.MODULE$.default()).shouldNot($this.contain().apply((Object)toRemove), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
    }

    public static final /* synthetic */ Assertion $anonfun$new$18(ResourceManagerTest $this, int i$1, DummyResource[] resources$3, int j) {
        if (i$1 == j) {
            return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)resources$3[j].isClosed()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)resources$3[j].isClosed()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public ResourceManagerTest() {
        this.test("should be able to trace and release a resource", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource resource = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource, monitor, resources);
            resources.onClosed((AutoCloseablePlus)resource);
            DummyResource$.MODULE$.verifyMonitorClose(resource, monitor);
            resources.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)resource.getToken()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)-1));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("should close the unreleased resource when closed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource resource = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource, monitor, resources);
            resources.close();
            DummyResource$.MODULE$.verifyClose(resource, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("should not close resources multiple times when closed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource resource = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource, monitor, resources);
            resources.close();
            DummyResource$.MODULE$.verifyClose(resource, monitor);
            resources.close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("should be able to trace and release multiple resources", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource resource1 = new DummyResource();
            DummyResource resource2 = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource1, monitor, resources);
            DummyResource$.MODULE$.verifyTrace(resource2, monitor, resources);
            resources.onClosed((AutoCloseablePlus)resource1);
            DummyResource$.MODULE$.verifyMonitorClose(resource1, monitor);
            resources.onClosed((AutoCloseablePlus)resource2);
            DummyResource$.MODULE$.verifyMonitorClose(resource2, monitor);
            resources.close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("should close the unreleased resources when closed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource resource1 = new DummyResource();
            DummyResource resource2 = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource1, monitor, resources);
            DummyResource$.MODULE$.verifyTrace(resource2, monitor, resources);
            resources.close();
            DummyResource$.MODULE$.verifyClose(resource1, monitor);
            DummyResource$.MODULE$.verifyClose(resource2, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("should close only the unreleased resources when closed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource resource1 = new DummyResource();
            DummyResource resource2 = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource1, monitor, resources);
            DummyResource$.MODULE$.verifyTrace(resource2, monitor, resources);
            resources.onClosed((AutoCloseablePlus)resource2);
            DummyResource$.MODULE$.verifyMonitorClose(resource2, monitor);
            resources.close();
            DummyResource$.MODULE$.verifyClose(resource1, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("should close all the resources even in case of exceptions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RuntimeException exception1 = new RuntimeException();
            RuntimeException exception2 = new RuntimeException();
            ThrowingDummyResource resource1 = new ThrowingDummyResource(exception1);
            ThrowingDummyResource resource2 = new ThrowingDummyResource(exception2);
            DummyResource resource3 = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            DummyResource$.MODULE$.verifyTrace(resource1, monitor, resources);
            DummyResource$.MODULE$.verifyTrace(resource2, monitor, resources);
            DummyResource$.MODULE$.verifyTrace(resource3, monitor, resources);
            Throwable throwable = (Throwable)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> resources.close()).failed().get();
            DummyResource$.MODULE$.verifyClose(resource1, monitor);
            DummyResource$.MODULE$.verifyClose(resource2, monitor);
            DummyResource$.MODULE$.verifyClose(resource3, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
            return this.convertToAnyShouldWrapper(((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{throwable}))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])throwable.getSuppressed())), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RuntimeException[]{exception1, exception2})));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("Resource pool should be able to grow beyond initial capacity", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            pool.add((AutoCloseablePlus)new DummyResource());
            pool.add((AutoCloseablePlus)new DummyResource());
            pool.add((AutoCloseablePlus)new DummyResource());
            pool.add((AutoCloseablePlus)new DummyResource());
            pool.add((AutoCloseablePlus)new DummyResource());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.all().size()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)5));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("Resource pool shouldn't grow if we add the same resource multiple times", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            DummyResource resource = new DummyResource();
            pool.add((AutoCloseablePlus)resource);
            pool.add((AutoCloseablePlus)resource);
            pool.add((AutoCloseablePlus)resource);
            pool.add((AutoCloseablePlus)resource);
            pool.add((AutoCloseablePlus)resource);
            pool.add((AutoCloseablePlus)resource);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.all().size()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)resource.getToken()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("Should handle removing the same item multiple times", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            DummyResource resource = new DummyResource();
            pool.add((AutoCloseablePlus)resource);
            pool.remove((AutoCloseablePlus)resource);
            pool.remove((AutoCloseablePlus)resource);
            pool.remove((AutoCloseablePlus)resource);
            pool.remove((AutoCloseablePlus)resource);
            pool.remove((AutoCloseablePlus)resource);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.all().size()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)resource.getToken()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)-1));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("Should be able to remove resource", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DummyResource[] resources = (DummyResource[])((Object[])new DummyResource[]{new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource()});
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])resources)).foreach((Function1 & Serializable)i -> ResourceManagerTest.$anonfun$new$13(this, resources, pool, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("Should not call close on removed item", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            DummyResource[] resources = (DummyResource[])((Object[])new DummyResource[]{new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource()});
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])resources), (Function1 & Serializable)resource -> {
                pool.add(resource);
                return BoxedUnit.UNIT;
            });
            pool.remove((AutoCloseablePlus)resources[i]);
            pool.closeAll();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)j -> ResourceManagerTest.$anonfun$new$18(this, i, resources, BoxesRunTime.unboxToInt((Object)j)));
        }), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("Resource pool new size should not overflow", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)this.mock(ClassTag$.MODULE$.apply(MemoryTracker.class)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(1)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(2)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(5)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)10));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(0x3FFFFFFF)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0x7FFFFFFE));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(0x40000000)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0x40000001));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(0x7FFFFFFE)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("Resource pool attempt not to create holes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)this.mock(ClassTag$.MODULE$.apply(MemoryTracker.class)));
            DummyResource r1 = new DummyResource();
            DummyResource r2 = new DummyResource();
            DummyResource r3 = new DummyResource();
            DummyResource r4 = new DummyResource();
            pool.add((AutoCloseablePlus)r1);
            pool.add((AutoCloseablePlus)r2);
            pool.add((AutoCloseablePlus)r3);
            pool.add((AutoCloseablePlus)r4);
            pool.remove((AutoCloseablePlus)r3);
            pool.remove((AutoCloseablePlus)r4);
            pool.add((AutoCloseablePlus)r4);
            pool.add((AutoCloseablePlus)r3);
            return this.convertToAnyShouldWrapper(pool.allIncludingNullValues(), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)r1, (List)new .colon.colon((Object)r2, (List)new .colon.colon((Object)r4, (List)new .colon.colon((Object)r3, (List)Nil$.MODULE$))))), (Object)Equality$.MODULE$.default());
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
    }
}

