/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.graphtemplate;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.graphtemplate.GraphTemplate;
import org.neo4j.cypher.internal.runtime.graphtemplate.InstantiatedGraph;
import org.neo4j.cypher.internal.runtime.graphtemplate.TemplateInstantiator;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.enablers.Aggregating$;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\f\u0018\u0001\u0011BQ!\f\u0001\u0005\u000292A!\r\u0001\u0005e!A\u0011H\u0001BC\u0002\u0013\u0005!\b\u0003\u0005P\u0005\t\u0005\t\u0015!\u0003<\u0011\u0015i#\u0001\"\u0001Q\r\u0011!\u0006\u0001B+\t\u0011Y3!Q1A\u0005\u0002]C\u0001\u0002\u0017\u0004\u0003\u0002\u0003\u0006I!\u0015\u0005\t3\u001a\u0011)\u0019!C\u0001/\"A!L\u0002B\u0001B\u0003%\u0011\u000b\u0003\u0005\\\r\t\u0015\r\u0011\"\u0001]\u0011!\u0001gA!A!\u0002\u0013i\u0006\"B\u0017\u0007\t\u0003\tg\u0001\u00024\u0001\t\u001dDQ!\f\b\u0005\u0002-Dq!\u001c\bC\u0002\u0013\u0005a\u000e\u0003\u0004x\u001d\u0001\u0006Ia\u001c\u0005\bq:\u0011\r\u0011\"\u0001z\u0011\u0019Yh\u0002)A\u0005u\")AP\u0004C\u0001{\"1qP\u0004C\u0001\u0003\u0003\u0011\u0011c\u0012:ba\"$V-\u001c9mCR,G+Z:u\u0015\tA\u0012$A\u0007he\u0006\u0004\b\u000e^3na2\fG/\u001a\u0006\u00035m\tqA];oi&lWM\u0003\u0002\u001d;\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001f?\u000511-\u001f9iKJT!\u0001I\u0011\u0002\u000b9,w\u000e\u000e6\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(B\u0001\u0016\u001c\u0003\u0011)H/\u001b7\n\u00051:#AD\"za\",'OR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003]\u0011AAT8eKN\u0011!a\r\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\r1\f'-\u001a7t+\u0005Y\u0004c\u0001\u001fE\u000f:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u000e\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005\r+\u0014a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u00131aU3r\u0015\t\u0019U\u0007\u0005\u0002I\u0019:\u0011\u0011J\u0013\t\u0003}UJ!aS\u001b\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017V\nq\u0001\\1cK2\u001c\b\u0005\u0006\u0002R'B\u0011!KA\u0007\u0002\u0001!)\u0011(\u0002a\u0001w\t\u0019!+\u001a7\u0014\u0005\u0019\u0019\u0014\u0001\u00024s_6,\u0012!U\u0001\u0006MJ|W\u000eI\u0001\u0003i>\f1\u0001^8!\u0003\u001d\u0011X\r\u001c+za\u0016,\u0012!\u0018\t\u0004iy;\u0015BA06\u0005\u0019y\u0005\u000f^5p]\u0006A!/\u001a7UsB,\u0007\u0005\u0006\u0003cG\u0012,\u0007C\u0001*\u0007\u0011\u00151V\u00021\u0001R\u0011\u0015IV\u00021\u0001R\u0011\u0015YV\u00021\u0001^\u0005\u00159%/\u00199i'\rq1\u0007\u001b\t\u0005a%\f&-\u0003\u0002k/\t!B+Z7qY\u0006$X-\u00138ti\u0006tG/[1u_J$\u0012\u0001\u001c\t\u0003%:\tQA\\8eKN,\u0012a\u001c\t\u0004aV\fV\"A9\u000b\u0005I\u001c\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003iV\n!bY8mY\u0016\u001cG/[8o\u0013\t1\u0018OA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018A\u00028pI\u0016\u001c\b%\u0001\u0003sK2\u001cX#\u0001>\u0011\u0007A,(-A\u0003sK2\u001c\b%\u0001\u0006de\u0016\fG/\u001a(pI\u0016$\"!\u0015@\t\u000be\"\u0002\u0019A\u001e\u0002\u0013\r\u0014X-\u0019;f%\u0016dGc\u00022\u0002\u0004\u0005\u0015\u0011q\u0001\u0005\u0006-V\u0001\r!\u0015\u0005\u00063V\u0001\r!\u0015\u0005\u00067V\u0001\r!\u0018")
public class GraphTemplateTest
extends CypherFunSuite {
    public GraphTemplateTest() {
        this.test("node label propagated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = new GraphTemplate().addNode("a", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"L1", "L2"}));
            Seq<String> labels = template.instantiate(new Graph()).node("a").labels();
            return this.convertToAnyShouldWrapper(labels, new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204), Prettifier$.MODULE$.default()).should(this.contain()).only((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"L1", "L2"}), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("rel type propagated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = new GraphTemplate().addNode("a").addNode("b").addRel("r", (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b"), "R1");
            Option<String> relType = template.instantiate(new Graph()).rel("r").relType();
            return this.convertToAnyShouldWrapper(relType, new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217), Prettifier$.MODULE$.default()).shouldBe((Object)new Some((Object)"R1"));
        }, new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("rel from propagated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = new GraphTemplate().addNode("a").addNode("b").addRel("r", (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b"));
            InstantiatedGraph<Node, Rel> res = template.instantiate(new Graph());
            return this.convertToAnyShouldWrapper(res.rel("r").from(), new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228), Prettifier$.MODULE$.default()).shouldBe((Object)res.node("a"));
        }, new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("rel to propagated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = new GraphTemplate().addNode("a").addNode("b").addRel("r", (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b"));
            InstantiatedGraph<Node, Rel> res = template.instantiate(new Graph());
            return this.convertToAnyShouldWrapper(res.rel("r").to(), new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239), Prettifier$.MODULE$.default()).shouldBe((Object)res.node("b"));
        }, new Position("GraphTemplate.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
    }

    private class Graph
    implements TemplateInstantiator<Node, Rel> {
        private final ArrayBuffer<Node> nodes;
        private final ArrayBuffer<Rel> rels;

        public ArrayBuffer<Node> nodes() {
            return this.nodes;
        }

        public ArrayBuffer<Rel> rels() {
            return this.rels;
        }

        @Override
        public Node createNode(Seq<String> labels) {
            Node n = new Node(this.org$neo4j$cypher$internal$runtime$graphtemplate$GraphTemplateTest$Graph$$$outer(), labels);
            this.nodes().$plus$eq((Object)n);
            return n;
        }

        @Override
        public Rel createRel(Node from, Node to, Option<String> relType) {
            Rel r = new Rel(this.org$neo4j$cypher$internal$runtime$graphtemplate$GraphTemplateTest$Graph$$$outer(), from, to, relType);
            this.rels().$plus$eq((Object)r);
            return r;
        }

        public /* synthetic */ GraphTemplateTest org$neo4j$cypher$internal$runtime$graphtemplate$GraphTemplateTest$Graph$$$outer() {
            return GraphTemplateTest.this;
        }

        public Graph() {
            if (GraphTemplateTest.this == null) {
                throw null;
            }
            this.nodes = ArrayBuffer$.MODULE$.empty();
            this.rels = ArrayBuffer$.MODULE$.empty();
        }
    }

    private class Node {
        private final Seq<String> labels;
        public final /* synthetic */ GraphTemplateTest $outer;

        public Seq<String> labels() {
            return this.labels;
        }

        public /* synthetic */ GraphTemplateTest org$neo4j$cypher$internal$runtime$graphtemplate$GraphTemplateTest$Node$$$outer() {
            return this.$outer;
        }

        public Node(GraphTemplateTest $outer, Seq<String> labels) {
            this.labels = labels;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class Rel {
        private final Node from;
        private final Node to;
        private final Option<String> relType;
        public final /* synthetic */ GraphTemplateTest $outer;

        public Node from() {
            return this.from;
        }

        public Node to() {
            return this.to;
        }

        public Option<String> relType() {
            return this.relType;
        }

        public /* synthetic */ GraphTemplateTest org$neo4j$cypher$internal$runtime$graphtemplate$GraphTemplateTest$Rel$$$outer() {
            return this.$outer;
        }

        public Rel(GraphTemplateTest $outer, Node from, Node to, Option<String> relType) {
            this.from = from;
            this.to = to;
            this.relType = relType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

