/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.graphtemplate.parsing;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Direction$Down$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Direction$Left$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Direction$Right$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Direction$Up$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.MultiLineParsedRelFinder;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.ParsedRel;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Projection$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Vec2d;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.enablers.Aggregating$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u2Aa\u0001\u0003\u0001'!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C\taR*\u001e7uS2Kg.\u001a)beN,GMU3m\r&tG-\u001a:UKN$(BA\u0003\u0007\u0003\u001d\u0001\u0018M]:j]\u001eT!a\u0002\u0005\u0002\u001b\u001d\u0014\u0018\r\u001d5uK6\u0004H.\u0019;f\u0015\tI!\"A\u0004sk:$\u0018.\\3\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u00033)\tA!\u001e;jY&\u00111D\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\tA!\u0001\u0003gS:$GC\u0001\u00124!\r\u0019S\u0006\r\b\u0003I)r!!\n\u0015\u000e\u0003\u0019R!a\n\n\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013!B:dC2\f\u0017BA\u0016-\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!K\u0005\u0003]=\u00121aU3r\u0015\tYC\u0006\u0005\u0002 c%\u0011!\u0007\u0002\u0002\n!\u0006\u00148/\u001a3SK2DQ\u0001\u000e\u0002A\u0002U\n1a\u001d;s!\t1$H\u0004\u00028qA\u0011Q\u0005L\u0005\u0003s1\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011\b\f")
public class MultiLineParsedRelFinderTest
extends CypherFunSuite {
    private Seq<ParsedRel> find(String str) {
        return new MultiLineParsedRelFinder((Set<Vec2d>)Predef$.MODULE$.Set().empty()).extract(str).toSeq();
    }

    public MultiLineParsedRelFinderTest() {
        this.test("single rightward line", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find("->");
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(0, 1), new Vec2d(0, 0)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(0, 0, Direction$Left$.MODULE$), Projection$.MODULE$.apply(0, 1, Direction$Right$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), (List)Nil$.MODULE$), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("multiple horizontal lines", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" <-\n        | -->\n        |")));
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(0, 2), new Vec2d(0, 1)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(0, 1, Direction$Left$.MODULE$), Projection$.MODULE$.apply(0, 2, Direction$Right$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$), (List)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(1, 3), new Vec2d(1, 2), new Vec2d(1, 1)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(1, 1, Direction$Left$.MODULE$), Projection$.MODULE$.apply(1, 3, Direction$Right$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), (List)Nil$.MODULE$)), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        this.test("single upward line", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" ^\n        | |\n        |")));
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(1, 1), new Vec2d(0, 1)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(0, 1, Direction$Up$.MODULE$), Projection$.MODULE$.apply(1, 1, Direction$Down$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$), (List)Nil$.MODULE$), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("multiple vertical lines", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" ^ |\n        | | v\n        |")));
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(1, 1), new Vec2d(0, 1)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(0, 1, Direction$Up$.MODULE$), Projection$.MODULE$.apply(1, 1, Direction$Down$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$), (List)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(1, 3), new Vec2d(0, 3)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(0, 3, Direction$Up$.MODULE$), Projection$.MODULE$.apply(1, 3, Direction$Down$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), (List)Nil$.MODULE$)), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        this.test("curved line", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |   .--. .--.\n        | --'  | |  '->\n        |      '-'\n        |      ")));
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(2, 1), new Vec2d(1, 5), new Vec2d(3, 8), new Vec2d(2, 3), new Vec2d(3, 6), new Vec2d(1, 3), new Vec2d(1, 11), new Vec2d(3, 7), new Vec2d(2, 2), new Vec2d(1, 4), new Vec2d(1, 6), new Vec2d(1, 9), new Vec2d(2, 12), new Vec2d(2, 11), new Vec2d(1, 8), new Vec2d(2, 6), new Vec2d(2, 8), new Vec2d(1, 10), new Vec2d(2, 13)}))), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, Projection$.MODULE$.apply(2, 1, Direction$Left$.MODULE$), Projection$.MODULE$.apply(2, 13, Direction$Right$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), (List)Nil$.MODULE$), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("horizontal line with name and type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find("-[r:Rel]->");
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(0, 9), new Vec2d(0, 2), new Vec2d(0, 6), new Vec2d(0, 1), new Vec2d(0, 8), new Vec2d(0, 4), new Vec2d(0, 0), new Vec2d(0, 3), new Vec2d(0, 5), new Vec2d(0, 7)}))), (Option<String>)new Some((Object)"r"), (Option<String>)new Some((Object)"Rel"), Projection$.MODULE$.apply(0, 0, Direction$Left$.MODULE$), Projection$.MODULE$.apply(0, 9, Direction$Right$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), (List)Nil$.MODULE$), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.test("vertical line with name and type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<ParsedRel> rels = this.find(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |   |\n        | [r:Rel]\n        |   |\n        |   v\n        |")));
            return this.convertToAnyShouldWrapper(rels, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)new .colon.colon((Object)new ParsedRel((Set<Vec2d>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vec2d[]{new Vec2d(2, 1), new Vec2d(1, 3), new Vec2d(2, 4), new Vec2d(2, 2), new Vec2d(4, 3), new Vec2d(2, 6), new Vec2d(2, 3), new Vec2d(2, 7), new Vec2d(2, 5), new Vec2d(3, 3)}))), (Option<String>)new Some((Object)"r"), (Option<String>)new Some((Object)"Rel"), Projection$.MODULE$.apply(1, 3, Direction$Up$.MODULE$), Projection$.MODULE$.apply(4, 3, Direction$Down$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), (List)Nil$.MODULE$), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
        }, new Position("MultiLineParsedRelFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
    }
}

