/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.assertj.core.api.AssertionsForClassTypes;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTraceStep;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTracingIterator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

class PathTracingIteratorTest {
    PathTracingIteratorTest() {
    }

    @Test
    void shouldOnlyGiveOnePathWhenGivenOneNode() {
        HeapTrackingLongObjectHashMap emptyPathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)new LocalMemoryTracker());
        LongIterator intersection = this.longIterator(10L);
        PathTracingIterator.MultiPathTracingIterator pti = new PathTracingIterator.MultiPathTracingIterator(intersection, 0, 0, emptyPathTraceData, emptyPathTraceData);
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
        AssertionsForClassTypes.assertThat((Object)((PathReference)pti.next())).isEqualTo((Object)VirtualValues.pathReference((long[])new long[]{10L}, (long[])new long[0]));
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldOnlyGiveOneLongerPath() {
        int sourceLength = 10;
        int targetLength = 5;
        int totalLength = sourceLength + targetLength;
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.singlePath(sourceLength, targetLength);
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
        AssertionsForClassTypes.assertThat((Object)((PathReference)pti.next())).isEqualTo((Object)VirtualValues.pathReference((long[])this.longRange(totalLength + 1), (long[])this.longRange(totalLength)));
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldOnlyGiveOneLongerPathEmptySourcePart() {
        int sourceLength = 0;
        int targetLength = 15;
        int totalLength = sourceLength + targetLength;
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.singlePath(sourceLength, targetLength);
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
        AssertionsForClassTypes.assertThat((Object)((PathReference)pti.next())).isEqualTo((Object)VirtualValues.pathReference((long[])this.longRange(totalLength + 1), (long[])this.longRange(totalLength)));
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldOnlyGiveOneLongerPathEmptyTargetPart() {
        int sourceLength = 15;
        int targetLength = 0;
        int totalLength = sourceLength + targetLength;
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.singlePath(sourceLength, targetLength);
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
        AssertionsForClassTypes.assertThat((Object)((PathReference)pti.next())).isEqualTo((Object)VirtualValues.pathReference((long[])this.longRange(totalLength + 1), (long[])this.longRange(totalLength)));
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldGiveCorrectCardinalityForMultiplePaths() {
        int sourceLength = 4;
        int targetLength = 3;
        int width = 4;
        int degree = 3;
        int expectedCardinality = this.expectedCardinalityOfRectangularPathSet(sourceLength, targetLength, width, degree);
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.rectangularPathSet(sourceLength, targetLength, width, degree);
        HashSet<PathReference> paths = new HashSet<PathReference>(expectedCardinality);
        for (int i = 0; i < expectedCardinality; ++i) {
            AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
            PathReference nextPath = (PathReference)pti.next();
            AssertionsForClassTypes.assertThat((Object)nextPath).isNotIn(paths);
            paths.add(nextPath);
        }
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldGiveCorrectCardinalityForMultiplePathsZeroSourceLength() {
        int sourceLength = 0;
        int targetLength = 3;
        int width = 4;
        int degree = 3;
        int expectedCardinality = this.expectedCardinalityOfRectangularPathSet(sourceLength, targetLength, width, degree);
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.rectangularPathSet(sourceLength, targetLength, width, degree);
        HashSet<PathReference> paths = new HashSet<PathReference>(expectedCardinality);
        for (int i = 0; i < expectedCardinality; ++i) {
            AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
            PathReference nextPath = (PathReference)pti.next();
            AssertionsForClassTypes.assertThat((Object)nextPath).isNotIn(paths);
            paths.add(nextPath);
        }
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldGiveCorrectCardinalityForMultiplePathsZeroTargetLength() {
        int sourceLength = 3;
        int targetLength = 0;
        int width = 4;
        int degree = 3;
        int expectedCardinality = this.expectedCardinalityOfRectangularPathSet(sourceLength, targetLength, width, degree);
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.rectangularPathSet(sourceLength, targetLength, width, degree);
        HashSet<PathReference> paths = new HashSet<PathReference>(expectedCardinality);
        for (int i = 0; i < expectedCardinality; ++i) {
            AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
            PathReference nextPath = (PathReference)pti.next();
            AssertionsForClassTypes.assertThat((Object)nextPath).isNotIn(paths);
            paths.add(nextPath);
        }
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldGiveCorrectCardinalityForMultiplePathsSourceLengthOne() {
        int sourceLength = 1;
        int targetLength = 3;
        int width = 4;
        int degree = 3;
        int expectedCardinality = this.expectedCardinalityOfRectangularPathSet(sourceLength, targetLength, width, degree);
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.rectangularPathSet(sourceLength, targetLength, width, degree);
        HashSet<PathReference> paths = new HashSet<PathReference>(expectedCardinality);
        for (int i = 0; i < expectedCardinality; ++i) {
            AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
            PathReference nextPath = (PathReference)pti.next();
            AssertionsForClassTypes.assertThat((Object)nextPath).isNotIn(paths);
            paths.add(nextPath);
        }
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldGiveCorrectCardinalityForMultiplePathsTargetLengthOne() {
        int sourceLength = 3;
        int targetLength = 1;
        int width = 4;
        int degree = 3;
        int expectedCardinality = this.expectedCardinalityOfRectangularPathSet(sourceLength, targetLength, width, degree);
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.rectangularPathSet(sourceLength, targetLength, width, degree);
        HashSet<PathReference> paths = new HashSet<PathReference>(expectedCardinality);
        for (int i = 0; i < expectedCardinality; ++i) {
            AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
            PathReference nextPath = (PathReference)pti.next();
            AssertionsForClassTypes.assertThat((Object)nextPath).isNotIn(paths);
            paths.add(nextPath);
        }
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    @Test
    void shouldGiveCorrectCardinalityForMultiplePathsManyRelsBetweenNodes() {
        int sourceLength = 3;
        int targetLength = 2;
        int width = 2;
        int degree = 4;
        int expectedCardinality = this.expectedCardinalityOfRectangularPathSet(sourceLength, targetLength, width, degree);
        PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> pti = this.rectangularPathSet(sourceLength, targetLength, width, degree);
        HashSet<PathReference> paths = new HashSet<PathReference>(expectedCardinality);
        for (int i = 0; i < expectedCardinality; ++i) {
            AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isTrue();
            PathReference nextPath = (PathReference)pti.next();
            AssertionsForClassTypes.assertThat((Object)nextPath).isNotIn(paths);
            paths.add(nextPath);
        }
        AssertionsForClassTypes.assertThat((boolean)pti.hasNext()).isFalse();
    }

    private PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> singlePath(int sourceLength, int targetLength) {
        long i;
        int totalLength = sourceLength + targetLength;
        LocalMemoryTracker mt = new LocalMemoryTracker();
        HeapTrackingLongObjectHashMap sourcePathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)mt);
        HeapTrackingLongObjectHashMap targetPathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)mt);
        LongIterator single = this.longIterator(sourceLength);
        for (i = (long)sourceLength; i > 0L; --i) {
            HeapTrackingArrayList sourceStep = HeapTrackingCollections.newArrayList((MemoryTracker)mt);
            sourceStep.add((Object)new PathTraceStep(i - 1L, i - 1L));
            sourcePathTraceData.put(i, (Object)sourceStep);
        }
        for (i = (long)sourceLength; i < (long)totalLength; ++i) {
            HeapTrackingArrayList targetStep = HeapTrackingCollections.newArrayList((MemoryTracker)mt);
            targetStep.add((Object)new PathTraceStep(i, i + 1L));
            targetPathTraceData.put(i, (Object)targetStep);
        }
        PathTracingIterator.MultiPathTracingIterator pti = new PathTracingIterator.MultiPathTracingIterator(single, sourceLength, targetLength, sourcePathTraceData, targetPathTraceData);
        return pti;
    }

    private PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> rectangularPathSet(int sourceLength, int targetLength, int width, int degree) {
        int k;
        int j;
        LocalMemoryTracker mt = new LocalMemoryTracker();
        HeapTrackingLongObjectHashMap sourcePathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)mt);
        HeapTrackingLongObjectHashMap targetPathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)mt);
        int incrementingNodeId = 0;
        int incrementingRelId = 0;
        long[] previousLevel = new long[]{incrementingNodeId++};
        long[] currentLevel = new long[width];
        for (int i = 1; i < sourceLength; ++i) {
            for (int j2 = 0; j2 < width; ++j2) {
                int nodeId = incrementingNodeId++;
                currentLevel[j2] = nodeId;
                HeapTrackingArrayList pathsToNode = HeapTrackingCollections.newArrayList((int)width, (MemoryTracker)mt);
                for (int k2 = 0; k2 < degree; ++k2) {
                    pathsToNode.add((Object)new PathTraceStep((long)incrementingRelId++, previousLevel[k2 % previousLevel.length]));
                }
                sourcePathTraceData.put((long)nodeId, (Object)pathsToNode);
            }
            previousLevel = currentLevel;
            currentLevel = new long[width];
        }
        long[] lastSourceLevel = previousLevel;
        previousLevel = new long[]{incrementingNodeId++};
        for (int i = 1; i < targetLength; ++i) {
            for (j = 0; j < width; ++j) {
                int nodeId = incrementingNodeId++;
                currentLevel[j] = nodeId;
                HeapTrackingArrayList pathsToNode = HeapTrackingCollections.newArrayList((int)width, (MemoryTracker)mt);
                for (k = 0; k < degree; ++k) {
                    pathsToNode.add((Object)new PathTraceStep((long)incrementingRelId++, previousLevel[k % previousLevel.length]));
                }
                targetPathTraceData.put((long)nodeId, (Object)pathsToNode);
            }
            previousLevel = currentLevel;
            currentLevel = new long[width];
        }
        int intersectionWidth = sourceLength == 0 || targetLength == 0 ? 1 : width;
        currentLevel = new long[intersectionWidth];
        for (j = 0; j < intersectionWidth; ++j) {
            int nodeId = incrementingNodeId++;
            currentLevel[j] = nodeId;
            if (sourceLength > 0) {
                HeapTrackingArrayList pathsToNodeSourceSide = HeapTrackingCollections.newArrayList((int)width, (MemoryTracker)mt);
                for (k = 0; k < degree; ++k) {
                    pathsToNodeSourceSide.add((Object)new PathTraceStep((long)incrementingRelId++, lastSourceLevel[k % lastSourceLevel.length]));
                }
                sourcePathTraceData.put((long)nodeId, (Object)pathsToNodeSourceSide);
            }
            if (targetLength <= 0) continue;
            HeapTrackingArrayList pathsToNodeTargetSide = HeapTrackingCollections.newArrayList((int)width, (MemoryTracker)mt);
            for (k = 0; k < degree; ++k) {
                pathsToNodeTargetSide.add((Object)new PathTraceStep((long)incrementingRelId++, previousLevel[k % previousLevel.length]));
            }
            targetPathTraceData.put((long)nodeId, (Object)pathsToNodeTargetSide);
        }
        LongIterator intersectionIterator = this.longIterator(currentLevel);
        return new PathTracingIterator.MultiPathTracingIterator(intersectionIterator, sourceLength, targetLength, sourcePathTraceData, targetPathTraceData);
    }

    private int expectedCardinalityOfRectangularPathSet(int sourceLength, int targetLength, int width, int degree) {
        int nSourcePartsPerIntersectionNode = (int)Math.pow(degree, sourceLength);
        int nTargetPartsPerIntersectionNode = (int)Math.pow(degree, targetLength);
        int intersectionWidth = sourceLength == 0 || targetLength == 0 ? 1 : width;
        return nSourcePartsPerIntersectionNode * nTargetPartsPerIntersectionNode * intersectionWidth;
    }

    private long[] longRange(long exclusiveStop) {
        return this.longRange(0L, exclusiveStop);
    }

    private long[] longRange(long inclusiveStart, long exclusiveStop) {
        long[] ls = new long[(int)(exclusiveStop - inclusiveStart)];
        Arrays.setAll(ls, i -> inclusiveStart + (long)i);
        return ls;
    }

    private LongIterator longIterator(final long ... ls) {
        return new LongIterator(){
            int i = 0;

            public long next() {
                return ls[this.i++];
            }

            public boolean hasNext() {
                return this.i < ls.length;
            }
        };
    }
}

