/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.io.Serializable;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.github.jamm.MemoryMeter;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName$;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.MultiRelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.PGStateBuilder;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.PGStateBuilder$MultiRelationshipBuilder$;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.collection.compat.immutable.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005)3Aa\u0002\u0005\u00013!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001a\u0001A\u0003%1\u0006C\u00035\u0001\u0011%Q\u0007C\u0004E\u0001\t\u0007I\u0011B#\t\r%\u0003\u0001\u0015!\u0003G\u0005I!vo\\,bsNKwM\u001c9pgR$Vm\u001d;\u000b\u0005%Q\u0011!\u00029qE\u001a\u001c(BA\u0006\r\u0003%!(/\u0019<feN\fGN\u0003\u0002\u000e\u001d\u00059\u0001.\u001a7qKJ\u001c(BA\b\u0011\u0003\r\t\u0007/\u001b\u0006\u0003#I\taa[3s]\u0016d'BA\n\u0015\u0003!Ig\u000e^3s]\u0006d'BA\u000b\u0017\u0003\u0015qWm\u001c\u001bk\u0015\u00059\u0012aA8sO\u000e\u00011C\u0001\u0001\u001b!\tY2%D\u0001\u001d\u0015\tib$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002 A\u0005!Q\u000f^5m\u0015\t\u0019\u0012E\u0003\u0002#)\u000511-\u001f9iKJL!\u0001\n\u000f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011\u0001C\u0001\u0006[\u0016$XM]\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005U\u0006lWN\u0003\u00021-\u00051q-\u001b;ik\nL!AM\u0017\u0003\u00175+Wn\u001c:z\u001b\u0016$XM]\u0001\u0007[\u0016$XM\u001d\u0011\u0002!\u0011,G-\u001e9mS\u000e\fG/\u001a3TSj,GC\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0011auN\\4\t\u000bu\"\u0001\u0019\u0001 \u0002\u0003=\u00042aN B\u0013\t\u0001\u0005H\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"a\u000e\"\n\u0005\rC$AB!osJ+g-\u0001\u0002mgV\ta\t\u0005\u0002)\u000f&\u0011\u0001\n\u0003\u0002\b\u0019\u0016tw\r\u001e5t\u0003\ra7\u000f\t")
public class TwoWaySignpostTest
extends CypherFunSuite {
    private final MemoryMeter meter = MemoryMeter.builder().build();
    private final Lengths ls = Lengths.trailMode();

    private MemoryMeter meter() {
        return this.meter;
    }

    private long deduplicatedSize(Seq<Object> o) {
        return this.meter().measureDeep(o) - this.meter().measureDeep((Object)package$.MODULE$.ArraySeq().fill(o.size(), (Function0 & Serializable)() -> null, ClassTag$.MODULE$.Null()));
    }

    private Lengths ls() {
        return this.ls;
    }

    public TwoWaySignpostTest() {
        this.test("memory allocation on construction of node signpost", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalMemoryTracker mt = new LocalMemoryTracker();
            GlobalState gs = new GlobalState(null, null, SearchMode.Unidirectional, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (PPBFSHooks)PPBFSHooks.NULL$.MODULE$, 1);
            State s1 = new State(1, SlotOrName$.MODULE$.none(), Predicates.ALWAYS_TRUE_LONG, false, false);
            State s2 = new State(2, SlotOrName$.MODULE$.none(), Predicates.ALWAYS_TRUE_LONG, false, false);
            NodeState prevNode = new NodeState(gs, 1L, s1, 3L, this.ls());
            NodeState forwardNode = new NodeState(gs, 1L, s2, 3L, this.ls());
            TwoWaySignpost.NodeSignpost signpost = TwoWaySignpost.fromNodeJuxtaposition((MemoryTracker)mt, (NodeState)prevNode, (NodeState)forwardNode, (int)0, (Lengths)this.ls());
            long actual = this.meter().measureDeep((Object)signpost) - this.deduplicatedSize((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{prevNode, forwardNode}));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)mt.estimatedHeapMemory()), new Position("TwoWaySignpostTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)actual));
        }, new Position("TwoWaySignpostTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("memory allocation on construction of rel signpost", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalMemoryTracker mt = new LocalMemoryTracker();
            GlobalState gs = new GlobalState(null, null, SearchMode.Unidirectional, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (PPBFSHooks)PPBFSHooks.NULL$.MODULE$, 1);
            State s1 = new State(1, SlotOrName$.MODULE$.none(), Predicates.ALWAYS_TRUE_LONG, false, false);
            State s2 = new State(2, SlotOrName$.MODULE$.none(), Predicates.ALWAYS_TRUE_LONG, false, false);
            NodeState prevNode = new NodeState(gs, 1L, s1, 3L, this.ls());
            NodeState forwardNode = new NodeState(gs, 2L, s2, 3L, this.ls());
            RelationshipExpansion re = new RelationshipExpansion(s1, Predicates.alwaysTrue(), null, Direction.BOTH, SlotOrName$.MODULE$.none(), s2);
            TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion((MemoryTracker)mt, (NodeState)prevNode, (long)1L, (NodeState)forwardNode, (RelationshipExpansion)re, (int)0, (Lengths)this.ls());
            long actual = this.meter().measureDeep((Object)signpost) - this.deduplicatedSize((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{prevNode, forwardNode, re}));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)mt.estimatedHeapMemory()), new Position("TwoWaySignpostTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)actual));
        }, new Position("TwoWaySignpostTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("memory allocation on construction of multi rel signpost", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalMemoryTracker mt = new LocalMemoryTracker();
            GlobalState gs = new GlobalState(null, null, SearchMode.Unidirectional, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (PPBFSHooks)PPBFSHooks.NULL$.MODULE$, 1);
            State s1 = new State(1, SlotOrName$.MODULE$.none(), Predicates.ALWAYS_TRUE_LONG, false, false);
            State s2 = new State(2, SlotOrName$.MODULE$.none(), Predicates.ALWAYS_TRUE_LONG, false, false);
            NodeState prevNode = new NodeState(gs, 1L, s1, 3L, this.ls());
            NodeState forwardNode = new NodeState(gs, 2L, s2, 3L, this.ls());
            PGStateBuilder.MultiRelationshipBuilder qual$1 = PGStateBuilder$MultiRelationshipBuilder$.MODULE$.empty();
            String x$1 = qual$1.r$default$1();
            Predicate<RelationshipTraversalEntities> x$2 = qual$1.r$default$2();
            int[] x$3 = qual$1.r$default$3();
            Direction x$4 = qual$1.r$default$4();
            PGStateBuilder.MultiRelationshipBuilder qual$2 = qual$1.r(x$1, x$2, x$3, x$4);
            String x$5 = qual$2.n$default$1();
            LongPredicate x$6 = qual$2.n$default$2();
            PGStateBuilder.MultiRelationshipBuilder qual$3 = qual$2.n(x$5, x$6);
            String x$7 = qual$3.r$default$1();
            Predicate<RelationshipTraversalEntities> x$8 = qual$3.r$default$2();
            int[] x$9 = qual$3.r$default$3();
            Direction x$10 = qual$3.r$default$4();
            PGStateBuilder.MultiRelationshipBuilder builder = qual$3.r(x$7, x$8, x$9, x$10);
            MultiRelationshipExpansion mre = new MultiRelationshipExpansion(s1, (MultiRelationshipExpansion.Rel[])builder.rels().toArray(ClassTag$.MODULE$.apply(MultiRelationshipExpansion.Rel.class)), (MultiRelationshipExpansion.Node[])builder.nodes().toArray(ClassTag$.MODULE$.apply(MultiRelationshipExpansion.Node.class)), MultiRelationshipExpansion.CompoundPredicate.ALWAYS_TRUE, s2);
            TwoWaySignpost.MultiRelSignpost signpost = TwoWaySignpost.fromMultiRel((MemoryTracker)mt, (NodeState)prevNode, (long[])new long[]{1L, 2L}, (long[])new long[]{3L}, (MultiRelationshipExpansion)mre, (NodeState)forwardNode, (int)0, (Lengths)this.ls());
            long actual = this.meter().measureDeep((Object)signpost) - this.deduplicatedSize((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{prevNode, forwardNode, mre}));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)mt.estimatedHeapMemory()), new Position("TwoWaySignpostTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)actual));
        }, new Position("TwoWaySignpostTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }
}

