/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.collector.CollectorStateMachine;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

class CollectorStateMachineTest {
    CollectorStateMachineTest() {
    }

    @Test
    void shouldHandleStress() throws ExecutionException, InterruptedException {
        int n = 1000;
        TestStateMachine stateMachine = new TestStateMachine();
        ExecutorService executor = Executors.newFixedThreadPool(3);
        Future<?> collect = executor.submit(this.stress(n, () -> this.collect(stateMachine)));
        Future<?> stop = executor.submit(this.stress(n, () -> stateMachine.stop(Long.MAX_VALUE)));
        Future<?> clear = executor.submit(this.stress(n, () -> ((TestStateMachine)stateMachine).clear()));
        Future<?> status = executor.submit(this.stress(n, () -> ((TestStateMachine)stateMachine).status()));
        collect.get();
        stop.get();
        clear.get();
        status.get();
        executor.shutdown();
    }

    private <T> Runnable stress(int n, Supplier<T> action) {
        return () -> {
            for (int i = 0; i < n; ++i) {
                action.get();
            }
        };
    }

    public CollectorStateMachine.Result collect(CollectorStateMachine stateMachine) {
        try {
            return stateMachine.collect(Collections.emptyMap());
        }
        catch (InvalidArgumentsException e) {
            throw new IllegalStateException(e);
        }
    }

    static class TestStateMachine
    extends CollectorStateMachine<String> {
        volatile State state = State.IDLE;

        TestStateMachine() {
            super(false);
        }

        protected CollectorStateMachine.Result doCollect(Map<String, Object> config, long collectionId) {
            Assertions.assertSame((Object)((Object)this.state), (Object)((Object)State.IDLE));
            this.state = State.COLLECTING;
            return null;
        }

        protected CollectorStateMachine.Result doStop() {
            Assertions.assertSame((Object)((Object)this.state), (Object)((Object)State.COLLECTING));
            this.state = State.IDLE;
            return null;
        }

        protected CollectorStateMachine.Result doClear() {
            Assertions.assertSame((Object)((Object)this.state), (Object)((Object)State.IDLE));
            return null;
        }

        protected String doGetData() {
            Assertions.assertSame((Object)((Object)this.state), (Object)((Object)State.IDLE));
            return "Data";
        }

        static enum State {
            IDLE,
            COLLECTING;

        }
    }
}

