/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.github.jamm.MemoryMeter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.internal.collector.RecentQueryBuffer;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class RecentQueryBufferTest {
    public static final NamedDatabaseId DATABASE_ID = DatabaseIdFactory.from((String)"", (UUID)UUID.randomUUID());
    private final MemoryMeter meter = new MemoryMeter();
    private final long EMPTY_MAP_SIZE = this.meter.measureDeep((Object)VirtualValues.EMPTY_MAP);
    private final long DATABASE_ID_SIZE = this.meter.measureDeep((Object)DATABASE_ID);

    RecentQueryBufferTest() {
    }

    @Test
    void shouldEstimateHeapOfEmptyBuffer() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        RecentQueryBuffer buffer = new RecentQueryBuffer(4, (MemoryTracker)memoryTracker);
        this.assertEstimatedMemory(memoryTracker, buffer, new TruncatedQuerySnapshot[0]);
    }

    @Test
    void shouldEstimateHeapOfAddedQuery() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        RecentQueryBuffer buffer = new RecentQueryBuffer(4, (MemoryTracker)memoryTracker);
        TruncatedQuerySnapshot q = this.query("RETURN 1", VirtualValues.EMPTY_MAP);
        buffer.produce(q);
        this.assertEstimatedMemory(memoryTracker, buffer, q);
    }

    @Test
    void shouldEstimateHeapOfFullBuffer() {
        TruncatedQuerySnapshot[] queries;
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        RecentQueryBuffer buffer = new RecentQueryBuffer(4, (MemoryTracker)memoryTracker);
        for (TruncatedQuerySnapshot q : queries = new TruncatedQuerySnapshot[]{this.query("RETURN 1", VirtualValues.EMPTY_MAP), this.query("RETURN 2", VirtualValues.EMPTY_MAP), this.query("RETURN 3", VirtualValues.EMPTY_MAP), this.query("RETURN 4", VirtualValues.EMPTY_MAP)}) {
            buffer.produce(q);
        }
        this.assertEstimatedMemory(memoryTracker, buffer, queries);
        TruncatedQuerySnapshot q2 = this.query("RETURN 'I'm a longer query' AS x", VirtualValues.EMPTY_MAP);
        buffer.produce(q2);
        queries[0] = q2;
        this.assertEstimatedMemory(memoryTracker, buffer, queries);
    }

    @Test
    void shouldEstimateHeapOfFilledEmptiedBuffer() {
        TruncatedQuerySnapshot[] queries;
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        RecentQueryBuffer buffer = new RecentQueryBuffer(4, (MemoryTracker)memoryTracker);
        for (TruncatedQuerySnapshot q : queries = new TruncatedQuerySnapshot[]{this.query("RETURN 1", VirtualValues.EMPTY_MAP), this.query("RETURN 2", VirtualValues.EMPTY_MAP), this.query("RETURN 3", VirtualValues.EMPTY_MAP), this.query("RETURN 4", VirtualValues.EMPTY_MAP)}) {
            buffer.produce(q);
        }
        buffer.clear(DATABASE_ID);
        this.assertEstimatedMemory(memoryTracker, buffer, new TruncatedQuerySnapshot[0]);
    }

    @Test
    void shouldEstimateHeapOfQueryText() {
        TruncatedQuerySnapshot q1 = this.query("RETURN 1", VirtualValues.EMPTY_MAP);
        TruncatedQuerySnapshot q2 = this.query("RETURN 2 AS x", VirtualValues.EMPTY_MAP);
        MatcherAssert.assertThat((Object)q2.estimatedHeap, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(q1.estimatedHeap)));
        MatcherAssert.assertThat((Object)q1.estimatedHeap, (Matcher)Matchers.equalTo((Object)(this.meter.measureDeep((Object)q1) - this.EMPTY_MAP_SIZE - this.DATABASE_ID_SIZE)));
        MatcherAssert.assertThat((Object)q2.estimatedHeap, (Matcher)Matchers.equalTo((Object)(this.meter.measureDeep((Object)q2) - this.EMPTY_MAP_SIZE - this.DATABASE_ID_SIZE)));
    }

    @Test
    void shouldEstimateHeapOfQueryParameters() {
        TruncatedQuerySnapshot q1 = this.query("RETURN 1", VirtualValues.EMPTY_MAP);
        TruncatedQuerySnapshot q2 = this.query("RETURN 2", VirtualValues.map((String[])new String[]{"hi"}, (AnyValue[])new AnyValue[]{Values.longValue((long)42L)}));
        MatcherAssert.assertThat((Object)q2.estimatedHeap, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(q1.estimatedHeap)));
        MatcherAssert.assertThat((Object)q2.estimatedHeap, (Matcher)Matchers.equalTo((Object)(this.meter.measureDeep((Object)q2) - this.DATABASE_ID_SIZE)));
    }

    private void assertEstimatedMemory(LocalMemoryTracker memoryTracker, RecentQueryBuffer buffer, TruncatedQuerySnapshot ... queries) {
        long notExpected = this.meter.measureDeep((Object)memoryTracker);
        boolean hasEmptyParamQuery = Stream.of(queries).anyMatch(q -> q.queryParameters == VirtualValues.EMPTY_MAP);
        if (queries.length > 0) {
            notExpected += this.DATABASE_ID_SIZE;
        }
        if (hasEmptyParamQuery) {
            notExpected += this.EMPTY_MAP_SIZE;
        }
        MatcherAssert.assertThat((Object)memoryTracker.estimatedHeapMemory(), (Matcher)Matchers.equalTo((Object)(this.meter.measureDeep((Object)buffer) - notExpected)));
    }

    private TruncatedQuerySnapshot query(String query, MapValue params) {
        return new TruncatedQuerySnapshot(DATABASE_ID, query, this.freshSupplier(42), params, 1L, 2L, 3L, 1000);
    }

    private Supplier<ExecutionPlanDescription> freshSupplier(int i) {
        return () -> i == 0 ? null : null;
    }
}

