/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.collector.RingRecentBuffer;

class RingRecentBufferTest {
    RingRecentBufferTest() {
    }

    @Test
    void shouldJustWork() {
        long i;
        int bufferSize = 4;
        RingRecentBuffer buffer = new RingRecentBuffer(bufferSize, q -> {});
        buffer.foreach(l -> Assertions.fail((String)"boom"));
        for (i = 0L; i < 10L; ++i) {
            buffer.produce((Object)i);
            buffer.foreach(Assertions::assertNotNull);
        }
        buffer.clearIf(l -> true);
        buffer.foreach(l -> Assertions.fail((String)"boom"));
        for (i = 0L; i < 10L; ++i) {
            buffer.produce((Object)i);
        }
        buffer.foreach(Assertions::assertNotNull);
        Assertions.assertEquals((long)0L, (long)buffer.numSilentQueryDrops());
    }

    @Test
    void shouldHandleSize0() {
        RingRecentBuffer buffer = new RingRecentBuffer(0, q -> {});
        buffer.foreach(l -> Assertions.fail((String)"boom"));
        buffer.clearIf(l -> true);
        buffer.produce((Object)0L);
        buffer.foreach(l -> Assertions.fail((String)"boom"));
        buffer.clearIf(l -> true);
        Assertions.assertEquals((long)0L, (long)buffer.numSilentQueryDrops());
    }

    @Test
    void shouldClearIf() {
        int bufferSize = 4;
        RingRecentBuffer buffer = new RingRecentBuffer(bufferSize, q -> {});
        for (long i2 = 0L; i2 < 4L; ++i2) {
            buffer.produce((Object)i2);
        }
        buffer.clearIf(i -> i % 2L == 0L);
        ArrayList retained = new ArrayList();
        buffer.foreach(retained::add);
        Assertions.assertEquals((int)2, (int)retained.size());
        Assertions.assertEquals((long)1L, (Long)((Long)retained.get(0)));
        Assertions.assertEquals((long)3L, (Long)((Long)retained.get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotReadSameElementTwice() throws ExecutionException, InterruptedException {
        int n = 1000;
        int bufferSize = 16;
        RingRecentBuffer buffer = new RingRecentBuffer(bufferSize, q -> {});
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            UniqueElementsConsumer consumer = new UniqueElementsConsumer();
            CountDownLatch latch = new CountDownLatch(1);
            Future<?> produce = executor.submit(this.stressUntil(latch, arg_0 -> ((RingRecentBuffer)buffer).produce(arg_0)));
            Future<?> consume = executor.submit(this.stress(n, i -> {
                consumer.reset();
                buffer.foreach((Consumer)consumer);
                Assertions.assertTrue((consumer.values.size() <= bufferSize ? 1 : 0) != 0, (String)String.format("Should see at most %d elements", bufferSize));
            }));
            consume.get();
            latch.countDown();
            produce.get();
        }
        finally {
            executor.shutdown();
        }
        Assertions.assertEquals((long)0L, (long)buffer.numSilentQueryDrops());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNeverReadUnwrittenElements() throws ExecutionException, InterruptedException {
        int n = 1000000;
        int bufferSize = 16;
        RingRecentBuffer buffer = new RingRecentBuffer(bufferSize, q -> {});
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            Future<?> produce = executor.submit(this.stressUntil(latch, arg_0 -> ((RingRecentBuffer)buffer).produce(arg_0)));
            Future<?> consume = executor.submit(this.stress(n, i -> {
                buffer.clearIf(l -> true);
                buffer.foreach(Assertions::assertNotNull);
            }));
            consume.get();
            latch.countDown();
            produce.get();
        }
        finally {
            executor.shutdown();
        }
        Assertions.assertEquals((long)0L, (long)buffer.numSilentQueryDrops());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldWorkWithManyConcurrentProducers() throws ExecutionException, InterruptedException {
        int n = 1000000;
        int bufferSize = 16;
        RingRecentBuffer buffer = new RingRecentBuffer(bufferSize, q -> {});
        ExecutorService executor = Executors.newFixedThreadPool(4);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            Future<?> produce1 = executor.submit(this.stressUntil(latch, arg_0 -> ((RingRecentBuffer)buffer).produce(arg_0)));
            Future<?> produce2 = executor.submit(this.stressUntil(latch, arg_0 -> ((RingRecentBuffer)buffer).produce(arg_0)));
            Future<?> produce3 = executor.submit(this.stressUntil(latch, arg_0 -> ((RingRecentBuffer)buffer).produce(arg_0)));
            Future<?> consume = executor.submit(this.stress(n, i -> {
                buffer.clearIf(l -> true);
                buffer.foreach(Assertions::assertNotNull);
            }));
            consume.get();
            latch.countDown();
            produce1.get();
            produce2.get();
            produce3.get();
        }
        finally {
            executor.shutdown();
        }
        Assertions.assertTrue((buffer.numSilentQueryDrops() < 1000L ? 1 : 0) != 0, (String)"only a few silent drops expected");
    }

    private <T> Runnable stress(int n, LongConsumer action) {
        return () -> {
            for (long i = 0L; i < (long)n; ++i) {
                action.accept(i);
            }
        };
    }

    private <T> Runnable stressUntil(CountDownLatch latch, LongConsumer action) {
        return () -> {
            long i = 0L;
            while (latch.getCount() != 0L) {
                action.accept(i++);
            }
        };
    }

    static class UniqueElementsConsumer
    implements Consumer<Long> {
        MutableLongSet values = LongSets.mutable.empty();

        UniqueElementsConsumer() {
        }

        void reset() {
            this.values.clear();
        }

        @Override
        public void accept(Long newValue) {
            Assertions.assertTrue((boolean)this.values.add(newValue.longValue()), (String)String.format("Value %d was seen twice", newValue));
        }
    }
}

