/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

class TruncatedQuerySnapshotTest {
    static final NodeValue NODE = VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"Phone"}), (MapValue)TruncatedQuerySnapshotTest.map("number", (AnyValue)Values.stringValue((String)"07303725xx")));
    static final RelationshipValue RELATIONSHIP = VirtualValues.relationshipValue((long)100L, (NodeValue)NODE, (NodeValue)NODE, (TextValue)Values.stringValue((String)"CALL"), (MapValue)TruncatedQuerySnapshotTest.map("duration", (AnyValue)Values.stringValue((String)"3 hours")));

    TruncatedQuerySnapshotTest() {
    }

    @Test
    void shouldTruncateNode() {
        TruncatedQuerySnapshot x = new TruncatedQuerySnapshot(null, "", null, TruncatedQuerySnapshotTest.map("n", (AnyValue)NODE), -1L, -1L, -1L, 100);
        AnyValue truncatedNode = x.queryParameters.get("n");
        Assertions.assertTrue((boolean)(truncatedNode instanceof NodeReference));
        Assertions.assertEquals((long)NODE.id(), (long)((NodeReference)truncatedNode).id());
    }

    @Test
    void shouldTruncateRelationship() {
        TruncatedQuerySnapshot x = new TruncatedQuerySnapshot(null, "", null, TruncatedQuerySnapshotTest.map("r", (AnyValue)RELATIONSHIP), -1L, -1L, -1L, 100);
        AnyValue truncatedRelationship = x.queryParameters.get("r");
        Assertions.assertTrue((boolean)(truncatedRelationship instanceof RelationshipReference));
        Assertions.assertEquals((long)RELATIONSHIP.id(), (long)((RelationshipReference)truncatedRelationship).id());
    }

    private static MapValue map(String key, AnyValue value) {
        String[] keys = new String[]{key};
        AnyValue[] values = new AnyValue[]{value};
        return VirtualValues.map((String[])keys, (AnyValue[])values);
    }
}

