/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TargetDirectory;

public class StoreMigratorFrom21IT {
    @Rule
    public final TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void mustMendDuplicatePropertiesWhenUpgradingFromVersion21() throws Exception {
        File dir = MigrationTestUtils.find21FormatStoreDirectoryWithDuplicateProperties((File)this.storeDir.directory());
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir.getAbsolutePath()).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
        GraphDatabaseService database = builder.newGraphDatabase();
        database.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        ConsistencyCheckService.Result result = service.runFullConsistencyCheck(dir.getAbsoluteFile(), new Config(), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((boolean)result.isSuccessful());
        database = builder.newGraphDatabase();
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)database).getDependencyResolver();
        NeoStoresSupplier supplier = (NeoStoresSupplier)dependencyResolver.resolveDependency(NeoStoresSupplier.class);
        NeoStores store = (NeoStores)supplier.get();
        NodeStore nodeStore = store.getNodeStore();
        RelationshipStore relStore = store.getRelationshipStore();
        PropertyStore propertyStore = store.getPropertyStore();
        try (Transaction ignore = database.beginTx();){
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(0L), Pair.of((Object)"keyA", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(1L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(2L), Pair.of((Object)"keyA", (Object)"real1"), Pair.of((Object)"keyD", (Object)"real2"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(3L), Pair.of((Object)"keyA", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"real1"), Pair.of((Object)"keyD", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_1", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_2", (Object)"real2"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(4L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"keyB", (Object)"actual"), Pair.of((Object)"keyC", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getRelationshipById(0L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getRelationshipById(1L), Pair.of((Object)"keyA", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"real1"), Pair.of((Object)"keyD", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_1", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_2", (Object)"real2"));
            this.verifyPropertiesEqual((PropertyContainer)database.getRelationshipById(2L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"keyB", (Object)"actual"), Pair.of((Object)"keyC", (Object)"actual"));
        }
        this.verifyNoDuplicatePropertyKeys(propertyStore, nodeStore.getRecord(0L).getNextProp());
        this.verifyNoDuplicatePropertyKeys(propertyStore, nodeStore.getRecord(1L).getNextProp());
        this.verifyNoDuplicatePropertyKeys(propertyStore, nodeStore.getRecord(2L).getNextProp());
        this.verifyNoDuplicatePropertyKeys(propertyStore, relStore.getRecord(0L).getNextProp());
        this.verifyNoDuplicatePropertyKeys(propertyStore, relStore.getRecord(1L).getNextProp());
        database.shutdown();
    }

    private void verifyNoDuplicatePropertyKeys(PropertyStore propertyStore, long firstPropertyId) {
        HashSet<Integer> propertiesInUse = new HashSet<Integer>();
        long nextPropertyId = firstPropertyId;
        while (nextPropertyId != -1L) {
            PropertyRecord propertyRecord = propertyStore.getRecord(nextPropertyId);
            nextPropertyId = propertyRecord.getNextProp();
            if (!propertyRecord.inUse()) continue;
            for (PropertyBlock propertyBlock : propertyRecord) {
                if (!propertiesInUse.add(propertyBlock.getKeyIndexId())) {
                    throw new AssertionError((Object)String.format("Found a duplicate property in use: %s", propertyBlock.getKeyIndexId()));
                }
            }
        }
    }

    private void verifyPropertiesEqual(PropertyContainer entity, Pair<String, String> ... expectedProperties) {
        Map properties = entity.getAllProperties();
        Assert.assertThat((Object)properties, (Matcher)Matchers.is((Object)IteratorUtil.asMap(Arrays.asList(expectedProperties))));
    }
}

