/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class CompositeConstraintIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void compositeNodeKeyConstraintUpdate() throws Exception {
        Node node;
        File storeDir = this.testDirectory.graphDbDir();
        GraphDatabaseService database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        Label label = Label.label((String)"label");
        try (Transaction transaction = database.beginTx();){
            node = database.createNode(new Label[]{label});
            node.setProperty("b", (Object)3);
            node.setProperty("a", (Object)new double[]{0.6, 0.4, 0.2});
            transaction.success();
        }
        transaction = database.beginTx();
        var5_5 = null;
        try {
            String query = String.format("CREATE CONSTRAINT ON (n:%s) ASSERT (n.%s,n.%s) IS NODE KEY", label.name(), "a", "b");
            database.execute(query);
            transaction.success();
        }
        catch (Throwable query) {
            var5_5 = query;
            throw query;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable query) {
                        var5_5.addSuppressed(query);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        CompositeConstraintIT.awaitIndex(database);
        transaction = database.beginTx();
        var5_5 = null;
        try {
            node = database.createNode(new Label[]{label});
            node.setProperty("a", (Object)7);
            node.setProperty("b", (Object)new double[]{0.7, 0.5, 0.3});
            transaction.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        database.shutdown();
        ConsistencyCheckService.Result consistencyCheckResult = CompositeConstraintIT.checkDbConsistency(storeDir);
        Assert.assertTrue((String)"Database is consistent", (boolean)consistencyCheckResult.isSuccessful());
    }

    private static ConsistencyCheckService.Result checkDbConsistency(File storeDir) throws ConsistencyCheckTool.ToolFailureException {
        return ConsistencyCheckTool.runConsistencyCheckTool((String[])new String[]{storeDir.getAbsolutePath()}, (PrintStream)System.out, (PrintStream)System.err);
    }

    private static void awaitIndex(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            database.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.success();
        }
    }
}

