/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.SyntaxException;

class SyntaxExceptionTest {
    SyntaxExceptionTest() {
    }

    @Test
    void messageWithoutOffset() {
        String message = "Message";
        SyntaxException e = new SyntaxException(message);
        Assertions.assertEquals((Object)message, (Object)e.getMessage());
    }

    @Test
    void messageWithEmptyQuery() {
        String message = "Message";
        String query = "";
        int offset = 0;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "", "^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithJustNewlineQuery() {
        String message = "Message";
        String query = "\n";
        int offset = 0;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "", "^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithJustWindowsNewlineQuery() {
        String message = "Message";
        String query = "\r\n";
        int offset = 0;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "", "^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithSingleLineQuery() {
        String message = "Message";
        String query = "The error is here.";
        int offset = 13;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "             ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithSingleLineQueryAndOffsetTooHigh() {
        String message = "Message";
        String query = "The error is here.";
        int offset = 100;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "                  ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithMultiLineQueryAndOffsetInFirstLine() {
        String message = "Message";
        String query = "The error is here.\nSome random text.";
        int offset = 13;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "             ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithWindowsMultiLineQueryAndOffsetInFirstLine() {
        String message = "Message";
        String query = "The error is here.\r\nSome random text.";
        int offset = 13;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "             ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithMultiLineQueryAndOffsetAtEndOfFirstLine() {
        String message = "Message";
        String query = "The error is here.\nSome random text.";
        int offset = 18;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "                  ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithWindowsMultiLineQueryAndOffsetAtEndOfFirstLine() {
        String message = "Message";
        String query = "The error is here.\r\nSome random text.";
        int offset = 18;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "                  ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithMultiLineQueryAndOffsetAtBeginningOfSecondLine() {
        String message = "Message";
        String query = "The error is here.\nSome random text.";
        int offset = 19;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "Some random text.", "^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithWindowsMultiLineQueryAndOffsetAtBeginningOfSecondLine() {
        String message = "Message";
        String query = "The error is here.\r\nSome random text.";
        int offset = 20;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "Some random text.", "^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithMultiLineQueryAndOffsetInSecondLine() {
        String message = "Message";
        String query = "Some random text.\nThe error is here.";
        int offset = 31;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "             ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithWindowsMultiLineQueryAndOffsetInSecondLine() {
        String message = "Message";
        String query = "Some random text.\r\nThe error is here.";
        int offset = 32;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "             ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithMultiLineQueryAndOffsetTooHigh() {
        String message = "Message";
        String query = "Some random text.\nThe error is here.";
        int offset = 100;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "                  ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    @Test
    void messageWithWindowsMultiLineQueryAndOffsetTooHigh() {
        String message = "Message";
        String query = "Some random text.\r\nThe error is here.";
        int offset = 100;
        SyntaxException e = new SyntaxException(message, query, offset);
        String expected = SyntaxExceptionTest.formatExpectedString("Message", "The error is here.", "                  ^");
        Assertions.assertEquals((Object)expected, (Object)e.getMessage());
    }

    private static String formatExpectedString(String messageLine, String errorLine, String caretLine) {
        return String.format("%s%s\"%s\"%s %s", messageLine, System.lineSeparator(), errorLine, System.lineSeparator(), caretLine);
    }
}

