/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.expressions;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.CollectAll;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.GetDegree;
import org.neo4j.cypher.internal.expressions.HasDegree;
import org.neo4j.cypher.internal.expressions.HasDegreeGreaterThan;
import org.neo4j.cypher.internal.expressions.HasDegreeGreaterThanOrEqual;
import org.neo4j.cypher.internal.expressions.HasDegreeLessThan;
import org.neo4j.cypher.internal.expressions.HasDegreeLessThanOrEqual;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153Aa\u0002\u0005\u0001'!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n#\t\u0003B\u0002\u0014\u0001A\u0003%!\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003<\u0001\u0011\u0005A\bC\u0003C\u0001\u0011\u00051I\u0001\u0011FqB\u0014Xm]:j_:\u001c\u0015M\\8oS\u000e\fGn\u0015;sS:<g+\u00197UKN$(BA\u0005\u000b\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u00033)\tA!\u001e;jY&\u00111D\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001\"A\u0002q_N,\u0012A\t\t\u0003G\u0011j\u0011\u0001G\u0005\u0003Ka\u0011Q\"\u00138qkR\u0004vn]5uS>t\u0017\u0001\u00029pg\u0002\naA^1s\r>\u0014HCA\u0015-!\ty\"&\u0003\u0002,\u0011\tAa+\u0019:jC\ndW\rC\u0003.\t\u0001\u0007a&\u0001\u0003oC6,\u0007CA\u00189\u001d\t\u0001d\u0007\u0005\u00022i5\t!G\u0003\u00024%\u00051AH]8pizR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011q\u0007N\u0001\fe\u0016dG+\u001f9f\u001d\u0006lW\r\u0006\u0002>\u0001B\u0011qDP\u0005\u0003\u007f!\u00111BU3m)f\u0004XMT1nK\")\u0011)\u0002a\u0001]\u0005\t1/\u0001\u0006mSR,'/\u00197J]R$\"\u0001R$\u0011\u0005})\u0015B\u0001$\t\u0005m\u0019\u0016n\u001a8fI\u0012+7-[7bY&sG/Z4fe2KG/\u001a:bY\")\u0001J\u0002a\u0001\u0013\u0006)a/\u00197vKB\u0011!jS\u0007\u0002i%\u0011A\n\u000e\u0002\u0005\u0019>tw\r")
public class ExpressionCanonicalStringValTest
extends CypherFunSuite {
    private final InputPosition pos = InputPosition$.MODULE$.NONE();

    public InputPosition pos() {
        return this.pos;
    }

    public Variable varFor(String name) {
        return new Variable(name, this.pos());
    }

    public RelTypeName relTypeName(String s) {
        return new RelTypeName(s, this.pos());
    }

    public SignedDecimalIntegerLiteral literalInt(long value) {
        return new SignedDecimalIntegerLiteral(Long.toString(value), this.pos());
    }

    public ExpressionCanonicalStringValTest() {
        this.test("collect all should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.convertToStringShouldWrapper(new CollectAll((Expression)this.varFor("x"), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33), Prettifier$.MODULE$.default()).should(this.equal("collect_all(x)"), (Object)Equality$.MODULE$.default()), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("get degree should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.convertToStringShouldWrapper(new GetDegree((Expression)this.varFor("x"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37), Prettifier$.MODULE$.default()).should(this.equal("getDegree((x)-->())"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new GetDegree((Expression)this.varFor("x"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38), Prettifier$.MODULE$.default()).should(this.equal("getDegree((x)<--())"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new GetDegree((Expression)this.varFor("x"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.BOTH$.MODULE$, this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default()).should(this.equal("getDegree((x)--())"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new GetDegree((Expression)this.varFor("x"), (Option)new Some((Object)this.relTypeName("Rel")), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40), Prettifier$.MODULE$.default()).should(this.equal("getDegree((x)-[:Rel]->())"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new GetDegree((Expression)this.varFor("x"), (Option)new Some((Object)this.relTypeName("Rel")), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).should(this.equal("getDegree((x)<-[:Rel]-())"), (Object)Equality$.MODULE$.default());
            return this.convertToStringShouldWrapper(new GetDegree((Expression)this.varFor("x"), (Option)new Some((Object)this.relTypeName("Rel")), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46), Prettifier$.MODULE$.default()).should(this.equal("getDegree((x)-[:Rel]-())"), (Object)Equality$.MODULE$.default());
        }, new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("has degree greater than should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.convertToStringShouldWrapper(new HasDegreeGreaterThan((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)--()) > 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThan((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<--()) > 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThan((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-->()) > 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThan((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]-()) > 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThan((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<-[:Rel]-()) > 10"), (Object)Equality$.MODULE$.default());
            return this.convertToStringShouldWrapper(new HasDegreeGreaterThan((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]->()) > 10"), (Object)Equality$.MODULE$.default());
        }, new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("HasDegreeLessThan should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.convertToStringShouldWrapper(new HasDegreeLessThan((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)--()) < 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThan((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<--()) < 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThan((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-->()) < 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThan((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]-()) < 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThan((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<-[:Rel]-()) < 10"), (Object)Equality$.MODULE$.default());
            return this.convertToStringShouldWrapper(new HasDegreeLessThan((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]->()) < 10"), (Object)Equality$.MODULE$.default());
        }, new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("HasDegreeLessThanOrEqual should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.convertToStringShouldWrapper(new HasDegreeLessThanOrEqual((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)--()) <= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThanOrEqual((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<--()) <= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThanOrEqual((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-->()) <= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThanOrEqual((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]-()) <= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeLessThanOrEqual((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<-[:Rel]-()) <= 10"), (Object)Equality$.MODULE$.default());
            return this.convertToStringShouldWrapper(new HasDegreeLessThanOrEqual((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]->()) <= 10"), (Object)Equality$.MODULE$.default());
        }, new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("HasDegreeGreaterThanOrEqual should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.convertToStringShouldWrapper(new HasDegreeGreaterThanOrEqual((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)--()) >= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThanOrEqual((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<--()) >= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThanOrEqual((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-->()) >= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThanOrEqual((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]-()) >= 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegreeGreaterThanOrEqual((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<-[:Rel]-()) >= 10"), (Object)Equality$.MODULE$.default());
            return this.convertToStringShouldWrapper(new HasDegreeGreaterThanOrEqual((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]->()) >= 10"), (Object)Equality$.MODULE$.default());
        }, new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("HasDegree should render nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.convertToStringShouldWrapper(new HasDegree((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)--()) = 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegree((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<--()) = 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegree((Expression)this.varFor("node"), (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-->()) = 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegree((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]-()) = 10"), (Object)Equality$.MODULE$.default());
            this.convertToStringShouldWrapper(new HasDegree((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)<-[:Rel]-()) = 10"), (Object)Equality$.MODULE$.default());
            return this.convertToStringShouldWrapper(new HasDegree((Expression)this.varFor("node"), (Option)new Some((Object)new RelTypeName("Rel", this.pos())), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Expression)this.literalInt(10L), this.pos()).asCanonicalStringVal(), new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148), Prettifier$.MODULE$.default()).should(this.equal("getDegree((node)-[:Rel]->()) = 10"), (Object)Equality$.MODULE$.default());
        }, new Position("ExpressionCanonicalStringValTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
    }
}

