/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.time.Clock;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.impl.fulltext.AsyncFulltextIndexOperation;
import org.neo4j.kernel.api.impl.fulltext.FulltextUpdateApplier;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltext;
import org.neo4j.kernel.api.impl.fulltext.StubGraphDatabaseService;
import org.neo4j.kernel.api.impl.fulltext.StubLuceneFulltext;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltext;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;

public class FulltextUpdateApplierTest {
    private LifeSupport life;
    private FulltextUpdateApplier applier;
    private AvailabilityGuard availabilityGuard;
    private JobScheduler scheduler;
    private Log log;

    @Before
    public void setUp() throws Throwable {
        this.life = new LifeSupport();
        this.log = NullLog.getInstance();
        this.availabilityGuard = new AvailabilityGuard(Clock.systemUTC(), this.log);
        this.scheduler = (JobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
        this.life.start();
    }

    private void startApplier() {
        this.applier = (FulltextUpdateApplier)this.life.add((Lifecycle)new FulltextUpdateApplier(this.log, this.availabilityGuard, this.scheduler));
    }

    @After
    public void tearDown() {
        this.life.shutdown();
    }

    @Test
    public void exceptionsDuringIndexUpdateMustPropagateToTheCaller() throws Exception {
        this.startApplier();
        AsyncFulltextIndexOperation op = this.applier.updatePropertyData(null, null);
        try {
            op.awaitCompletion();
            Assert.fail((String)"awaitCompletion should have thrown");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NullPointerException.class)));
        }
    }

    @Test
    public void exceptionsDuringNodePopulationMustBeLoggedAndMarkTheIndexAsFailed() throws Exception {
        this.startApplier();
        StubLuceneFulltext index = new StubLuceneFulltext();
        StubGraphDatabaseService db = new StubGraphDatabaseService();
        WritableFulltext writableFulltext = new WritableFulltext((LuceneFulltext)index);
        AsyncFulltextIndexOperation op = this.applier.populateNodes(writableFulltext, (GraphDatabaseService)db);
        try {
            op.awaitCompletion();
            Assert.fail((String)"awaitCompletion should have thrown");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NullPointerException.class)));
        }
        Assert.assertThat((Object)index.getState(), (Matcher)Matchers.is((Object)InternalIndexState.FAILED));
    }

    @Test
    public void exceptionsDuringRelationshipPopulationMustBeLoggedAndMarkTheIndexAsFailed() throws Exception {
        this.startApplier();
        StubLuceneFulltext index = new StubLuceneFulltext();
        StubGraphDatabaseService db = new StubGraphDatabaseService();
        WritableFulltext writableFulltext = new WritableFulltext((LuceneFulltext)index);
        AsyncFulltextIndexOperation op = this.applier.populateRelationships(writableFulltext, (GraphDatabaseService)db);
        try {
            op.awaitCompletion();
            Assert.fail((String)"awaitCompletion should have thrown");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NullPointerException.class)));
        }
        Assert.assertThat((Object)index.getState(), (Matcher)Matchers.is((Object)InternalIndexState.FAILED));
    }
}

