/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;

public class ScoreEntityIteratorTest {
    @Test
    public void concatShouldReturnOrderedResults() {
        ScoreEntityIterator one = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{this.e(3L, 10.0f), this.e(10L, 3.0f), this.e(12L, 1.0f)});
        ScoreEntityIterator two = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{this.e(1L, 12.0f), this.e(5L, 8.0f), this.e(7L, 6.0f), this.e(8L, 5.0f), this.e(11L, 2.0f)});
        ScoreEntityIterator three = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{this.e(2L, 11.0f), this.e(4L, 9.0f), this.e(6L, 7.0f), this.e(9L, 4.0f)});
        ScoreEntityIterator concat = ScoreEntityIterator.concat(Arrays.asList(one, two, three));
        for (int i = 1; i <= 12; ++i) {
            Assert.assertTrue((boolean)concat.hasNext());
            ScoreEntityIterator.ScoreEntry entry = concat.next();
            Assert.assertEquals((long)i, (long)entry.entityId());
            Assert.assertEquals((double)(13 - i), (double)entry.score(), (double)0.001);
        }
        Assert.assertFalse((boolean)concat.hasNext());
    }

    private ScoreEntityIterator.ScoreEntry e(long id, float s) {
        return new ScoreEntityIterator.ScoreEntry(id, s);
    }

    @Test
    public void concatShouldHandleEmptyIterators() {
        ScoreEntityIterator one = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[0]);
        ScoreEntityIterator two = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{this.e(1L, 5.0f), this.e(2L, 4.0f), this.e(3L, 3.0f), this.e(4L, 2.0f), this.e(5L, 1.0f)});
        ScoreEntityIterator three = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[0]);
        ScoreEntityIterator concat = ScoreEntityIterator.concat(Arrays.asList(one, two, three));
        for (int i = 1; i <= 5; ++i) {
            Assert.assertTrue((boolean)concat.hasNext());
            ScoreEntityIterator.ScoreEntry entry = concat.next();
            Assert.assertEquals((long)i, (long)entry.entityId());
            Assert.assertEquals((double)(6 - i), (double)entry.score(), (double)0.001);
        }
        Assert.assertFalse((boolean)concat.hasNext());
    }

    @Test
    public void concatShouldHandleAllEmptyIterators() {
        ScoreEntityIterator one = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[0]);
        ScoreEntityIterator two = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[0]);
        ScoreEntityIterator three = this.iteratorOf(new ScoreEntityIterator.ScoreEntry[0]);
        ScoreEntityIterator concat = ScoreEntityIterator.concat(Arrays.asList(one, two, three));
        Assert.assertFalse((boolean)concat.hasNext());
    }

    private ScoreEntityIterator iteratorOf(final ScoreEntityIterator.ScoreEntry[] input) {
        return new ScoreEntityIterator(null){
            Iterator<ScoreEntityIterator.ScoreEntry> entries;
            {
                super(x0);
                this.entries = Arrays.asList(input).iterator();
            }

            public boolean hasNext() {
                return this.entries.hasNext();
            }

            public ScoreEntityIterator.ScoreEntry next() {
                return this.entries.next();
            }
        };
    }
}

