/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext.integrations.bloom;

import java.util.concurrent.ThreadLocalRandom;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.impl.fulltext.integrations.bloom.BloomFulltextConfig;
import org.neo4j.kernel.api.impl.fulltext.integrations.bloom.BloomProcedures;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.TestDirectory;

@Ignore(value="These are rudimentary benchmarks, but implemented via the jUnit framework to make them easy to run from an IDE.")
public class BloomFulltextIndexBenchmarks {
    private static final String[] WORDS = "dui nunc mattis enim ut tellus elementum sagittis vitae et leo duis ut diam quam nulla porttitor massa id neque aliquam vestibulum morbi blandit cursus risus at ultrices mi tempus imperdiet nulla malesuada pellentesque elit eget gravida cum sociis natoque penatibus et magnis dis parturient montes nascetur ridiculus mus mauris".split(" ");
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseFactory factory;
    private GraphDatabaseService db;

    private void createTestGraphDatabaseFactory() {
        this.factory = new GraphDatabaseFactory();
    }

    private void registerBloomProcedures() throws KernelException {
        ((Procedures)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Procedures.class)).registerProcedure(BloomProcedures.class);
    }

    private static void clearAndCreateRandomSentence(ThreadLocalRandom rng, StringBuilder sb) {
        sb.setLength(0);
        int wordCount = rng.nextInt(3, 7);
        for (int k = 0; k < wordCount; ++k) {
            sb.append(WORDS[rng.nextInt(WORDS.length)]).append(' ');
        }
        sb.setLength(sb.length() - 1);
    }

    private void setupDb() throws KernelException {
        this.createTestGraphDatabaseFactory();
        GraphDatabaseBuilder builder = this.factory.newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir());
        builder.setConfig(BloomFulltextConfig.bloom_enabled, "true");
        this.db = builder.newGraphDatabase();
        this.registerBloomProcedures();
    }

    @Test
    public void fiveHundredThousandOnlineUpdates() throws Exception {
        this.setupDb();
        this.db.execute("call db.fulltext.bloomFulltextSetPropertyKeys([\"prop\"])");
        int trials = 50;
        int threadCount = 10;
        int updatesPerThread = 1000;
        int updatesPerIteration = 10;
        int iterationsPerThread = updatesPerThread / updatesPerIteration;
        Runnable work = () -> {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < iterationsPerThread; ++i) {
                try (Transaction tx = this.db.beginTx();){
                    for (int j = 0; j < updatesPerIteration; ++j) {
                        BloomFulltextIndexBenchmarks.clearAndCreateRandomSentence(rng, sb);
                        this.db.createNode().setProperty("prop", (Object)sb.toString());
                    }
                    tx.success();
                    continue;
                }
            }
        };
        for (int i = 0; i < trials; ++i) {
            long startMillis = System.currentTimeMillis();
            Thread[] threads = new Thread[threadCount];
            for (int j = 0; j < threadCount; ++j) {
                threads[j] = new Thread(work);
            }
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
            long elapsedMillis = System.currentTimeMillis() - startMillis;
            System.out.printf("online update elapsed: %s ms.%n", elapsedMillis);
        }
    }

    @Test
    public void fiveHundredThousandNodesForPopulation() throws Exception {
        this.createTestGraphDatabaseFactory();
        GraphDatabaseBuilder builder = this.factory.newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir());
        this.db = builder.newGraphDatabase();
        try (Transaction tx = this.db.beginTx();){
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 500000; ++i) {
                BloomFulltextIndexBenchmarks.clearAndCreateRandomSentence(rng, sb);
                this.db.createNode().setProperty("prop", (Object)sb.toString());
            }
            tx.success();
        }
        this.db.shutdown();
        builder = this.factory.newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir());
        builder.setConfig(BloomFulltextConfig.bloom_enabled, "true");
        this.db = builder.newGraphDatabase();
        this.registerBloomProcedures();
        for (int i = 0; i < 50; ++i) {
            long startMillis = System.currentTimeMillis();
            this.db.execute("call db.fulltext.bloomFulltextSetPropertyKeys([\"prop\"])");
            this.db.execute("CALL db.fulltext.bloomAwaitPopulation").close();
            long elapsedMillis = System.currentTimeMillis() - startMillis;
            System.out.printf("startup populate elapsed: %s ms.%n", elapsedMillis);
            this.db.execute("call db.fulltext.bloomFulltextSetPropertyKeys([])");
            this.db.execute("CALL db.fulltext.bloomAwaitPopulation").close();
        }
        this.db.shutdown();
        this.db = null;
    }

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }
}

