/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProgressor;
import org.neo4j.kernel.api.impl.fulltext.StubValuesIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.values.storable.Value;

class FulltextIndexProgressorTest {
    FulltextIndexProgressorTest() {
    }

    @Test
    void mustSkipAndLimitEntriesPerConstraints() {
        boolean keepGoing;
        StubValuesIterator iterator = new StubValuesIterator();
        iterator.add(1L, 1.0f);
        iterator.add(2L, 2.0f);
        iterator.add(3L, 3.0f);
        iterator.add(4L, 4.0f);
        IndexQueryConstraints constraints = IndexQueryConstraints.unconstrained().skip(1L).limit(2L);
        StubEntityValueClient client = new StubEntityValueClient();
        FulltextIndexProgressor progressor = new FulltextIndexProgressor((ValuesIterator)iterator, (IndexProgressor.EntityValueClient)client, constraints);
        while (keepGoing = progressor.next()) {
        }
        Assertions.assertThat(client.entityIds).containsExactly((Object[])new Long[]{2L, 3L});
        Assertions.assertThat(client.scores).containsExactly((Object[])new Float[]{Float.valueOf(2.0f), Float.valueOf(3.0f)});
    }

    @Test
    void mustLimitToOneEntryPerConstraints() {
        boolean keepGoing;
        StubValuesIterator iterator = new StubValuesIterator();
        iterator.add(1L, 1.0f);
        iterator.add(2L, 2.0f);
        iterator.add(3L, 3.0f);
        iterator.add(4L, 4.0f);
        IndexQueryConstraints constraints = IndexQueryConstraints.unconstrained().skip(1L).limit(1L);
        StubEntityValueClient client = new StubEntityValueClient();
        FulltextIndexProgressor progressor = new FulltextIndexProgressor((ValuesIterator)iterator, (IndexProgressor.EntityValueClient)client, constraints);
        while (keepGoing = progressor.next()) {
        }
        Assertions.assertThat(client.entityIds).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(client.scores).containsExactly((Object[])new Float[]{Float.valueOf(2.0f)});
    }

    @Test
    void mustReturnNoElementsWhenSkipIsGreaterThanIterator() {
        boolean keepGoing;
        StubValuesIterator iterator = new StubValuesIterator();
        iterator.add(1L, 1.0f);
        iterator.add(2L, 2.0f);
        iterator.add(3L, 3.0f);
        iterator.add(4L, 4.0f);
        IndexQueryConstraints constraints = IndexQueryConstraints.unconstrained().skip(4L).limit(1L);
        StubEntityValueClient client = new StubEntityValueClient();
        FulltextIndexProgressor progressor = new FulltextIndexProgressor((ValuesIterator)iterator, (IndexProgressor.EntityValueClient)client, constraints);
        while (keepGoing = progressor.next()) {
        }
        Assertions.assertThat(client.entityIds).isEmpty();
        Assertions.assertThat(client.scores).isEmpty();
    }

    @Test
    void mustExhaustIteratorWhenLimitIsGreaterThanIterator() {
        boolean keepGoing;
        StubValuesIterator iterator = new StubValuesIterator();
        iterator.add(1L, 1.0f);
        iterator.add(2L, 2.0f);
        iterator.add(3L, 3.0f);
        iterator.add(4L, 4.0f);
        IndexQueryConstraints constraints = IndexQueryConstraints.unconstrained().limit(5L);
        StubEntityValueClient client = new StubEntityValueClient();
        FulltextIndexProgressor progressor = new FulltextIndexProgressor((ValuesIterator)iterator, (IndexProgressor.EntityValueClient)client, constraints);
        while (keepGoing = progressor.next()) {
        }
        Assertions.assertThat(client.entityIds).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L});
        Assertions.assertThat(client.scores).containsExactly((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)});
    }

    private static class StubEntityValueClient
    implements IndexProgressor.EntityValueClient {
        private final List<Long> entityIds = new ArrayList<Long>();
        private final List<Float> scores = new ArrayList<Float>();

        private StubEntityValueClient() {
        }

        public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexQueryConstraints constraints, boolean indexIncludesTransactionState) {
        }

        public boolean acceptEntity(long reference, float score, Value ... values) {
            this.entityIds.add(reference);
            this.scores.add(Float.valueOf(score));
            return true;
        }

        public boolean needsValues() {
            return false;
        }
    }
}

