/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongFloatProcedure;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.impl.fulltext.FulltextResultCollector;

class FulltextResultCollectorTest {
    FulltextResultCollectorTest() {
    }

    @Nested
    class EntityResultsMinQueueIteratorTest {
        EntityResultsMinQueueIteratorTest() {
        }

        @Test
        void mustReturnEntriesFromMinQueueInDescendingOrder() {
            FulltextResultCollector.EntityScorePriorityQueue pq = new FulltextResultCollector.EntityScorePriorityQueue(false);
            pq.insert(1L, 2.0f);
            pq.insert(2L, 3.0f);
            pq.insert(3L, 1.0f);
            FulltextResultCollector.EntityResultsMinQueueIterator iterator = new FulltextResultCollector.EntityResultsMinQueueIterator(pq);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertThat((long)iterator.next()).isEqualTo(2L);
            Assertions.assertThat((long)iterator.current()).isEqualTo(2L);
            Assertions.assertThat((float)iterator.currentScore()).isEqualTo(3.0f);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertThat((long)iterator.next()).isEqualTo(1L);
            Assertions.assertThat((long)iterator.current()).isEqualTo(1L);
            Assertions.assertThat((float)iterator.currentScore()).isEqualTo(2.0f);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertThat((long)iterator.next()).isEqualTo(3L);
            Assertions.assertThat((long)iterator.current()).isEqualTo(3L);
            Assertions.assertThat((float)iterator.currentScore()).isEqualTo(1.0f);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Nested
    class EntityResultsMaxQueueIteratorTest {
        EntityResultsMaxQueueIteratorTest() {
        }

        @RepeatedTest(value=200)
        void randomizedPriorityQueueTest() {
            long seed = ThreadLocalRandom.current().nextLong();
            SplittableRandom rng = new SplittableRandom(seed);
            int count = rng.nextInt(50, 100);
            try {
                FulltextResultCollector.EntityScorePriorityQueue actualQueue = new FulltextResultCollector.EntityScorePriorityQueue();
                PriorityQueue<EntityScore> expectedQueue = new PriorityQueue<EntityScore>(count);
                int i = 0;
                int j = 1;
                while (i < count) {
                    float score = (float)rng.nextDouble();
                    expectedQueue.add(new EntityScore(i, score));
                    actualQueue.insert((long)i, score);
                    ++i;
                    ++j;
                }
                FulltextResultCollector.EntityResultsMaxQueueIterator iterator = new FulltextResultCollector.EntityResultsMaxQueueIterator(actualQueue);
                EntityScore entityScore = new EntityScore(0L, 0.0f);
                int i2 = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                    entityScore.value(iterator.current(), iterator.currentScore());
                    ((AbstractComparableAssert)Assertions.assertThat((Comparable)entityScore).as("iteration %s", new Object[]{i2++})).isEqualTo(expectedQueue.remove());
                }
                Assertions.assertThat(expectedQueue).isEmpty();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed using seed = " + seed, e);
            }
        }
    }

    @Nested
    class PriorityQueueTest {
        PriorityQueueTest() {
        }

        @Test
        void queueMustCollectAndOrderResultsByScore() {
            FulltextResultCollector.EntityScorePriorityQueue pq = new FulltextResultCollector.EntityScorePriorityQueue();
            Assertions.assertThat((boolean)pq.isEmpty()).isTrue();
            pq.insert(1L, 3.0f);
            Assertions.assertThat((boolean)pq.isEmpty()).isFalse();
            pq.insert(2L, 1.0f);
            pq.insert(3L, 4.0f);
            pq.insert(4L, 2.0f);
            pq.insert(5L, 7.0f);
            pq.insert(6L, 5.0f);
            pq.insert(7L, 6.0f);
            ArrayList ids = new ArrayList(7);
            LongFloatProcedure & Serializable receiver = (LongFloatProcedure & Serializable)(id, score) -> ids.add((int)id);
            Assertions.assertThat((int)pq.size()).isEqualTo(7);
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(6);
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(5);
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(4);
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(3);
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(2);
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(1);
            Assertions.assertThat((boolean)pq.isEmpty()).isFalse();
            pq.removeTop((LongFloatProcedure)receiver);
            Assertions.assertThat((int)pq.size()).isEqualTo(0);
            Assertions.assertThat((boolean)pq.isEmpty()).isTrue();
            Assertions.assertThat(ids).containsExactly((Object[])new Integer[]{5, 7, 6, 3, 1, 4, 2});
        }

        @Test
        void queueMustCollectAndMinOrderResultsByScore() {
            FulltextResultCollector.EntityScorePriorityQueue pq = new FulltextResultCollector.EntityScorePriorityQueue(false);
            Assertions.assertThat((boolean)pq.isEmpty()).isTrue();
            pq.insert(1L, 3.0f);
            Assertions.assertThat((boolean)pq.isEmpty()).isFalse();
            pq.insert(2L, 1.0f);
            pq.insert(3L, 4.0f);
            pq.insert(4L, 2.0f);
            pq.insert(5L, 7.0f);
            pq.insert(6L, 5.0f);
            pq.insert(7L, 6.0f);
            ArrayList ids = new ArrayList(7);
            LongFloatProcedure & Serializable receiver = (LongFloatProcedure & Serializable)(id, score) -> ids.add((int)id);
            while (!pq.isEmpty()) {
                pq.removeTop((LongFloatProcedure)receiver);
            }
            Assertions.assertThat(ids).containsExactly((Object[])new Integer[]{2, 4, 1, 3, 6, 7, 5});
        }

        @RepeatedTest(value=200)
        void randomizedMaxPriorityQueueTest() {
            long seed = ThreadLocalRandom.current().nextLong();
            SplittableRandom rng = new SplittableRandom(seed);
            int count = rng.nextInt(5, 100);
            try {
                FulltextResultCollector.EntityScorePriorityQueue actualQueue = new FulltextResultCollector.EntityScorePriorityQueue();
                PriorityQueue<EntityScore> expectedQueue = new PriorityQueue<EntityScore>();
                for (int i = 0; i < count; ++i) {
                    float score = (float)rng.nextDouble();
                    expectedQueue.add(new EntityScore(i, score));
                    actualQueue.insert((long)i, score);
                }
                Assertions.assertThat((int)actualQueue.size()).isEqualTo(expectedQueue.size());
                EntityScore entityScore = new EntityScore(0L, 0.0f);
                while (!actualQueue.isEmpty()) {
                    actualQueue.removeTop((LongFloatProcedure)entityScore);
                    Assertions.assertThat((Comparable)entityScore).isEqualTo(expectedQueue.remove());
                }
                Assertions.assertThat(expectedQueue).isEmpty();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed using seed = " + seed, e);
            }
        }

        @RepeatedTest(value=200)
        void randomizedMinPriorityQueueTest() {
            long seed = ThreadLocalRandom.current().nextLong();
            SplittableRandom rng = new SplittableRandom(seed);
            int count = rng.nextInt(5, 100);
            try {
                FulltextResultCollector.EntityScorePriorityQueue actualQueue = new FulltextResultCollector.EntityScorePriorityQueue(false);
                PriorityQueue expectedQueue = new PriorityQueue(Comparator.reverseOrder());
                for (int i = 0; i < count; ++i) {
                    float score = (float)rng.nextDouble();
                    expectedQueue.add(new EntityScore(i, score));
                    actualQueue.insert((long)i, score);
                }
                Assertions.assertThat((int)actualQueue.size()).isEqualTo(expectedQueue.size());
                EntityScore entityScore = new EntityScore(0L, 0.0f);
                while (!actualQueue.isEmpty()) {
                    actualQueue.removeTop((LongFloatProcedure)entityScore);
                    Assertions.assertThat((Comparable)entityScore).isEqualTo(expectedQueue.remove());
                }
                Assertions.assertThat(expectedQueue).isEmpty();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed using seed = " + seed, e);
            }
        }
    }

    static class EntityScore
    implements Comparable<EntityScore>,
    LongFloatProcedure {
        long entity;
        float score;

        EntityScore(long entity, float score) {
            this.entity = entity;
            this.score = score;
        }

        @Override
        public int compareTo(EntityScore o) {
            return Float.compare(o.score, this.score);
        }

        public String toString() {
            return "EntityScore{entity=" + this.entity + ", score=" + this.score + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityScore that = (EntityScore)o;
            if (this.entity != that.entity) {
                return false;
            }
            return Float.compare(that.score, this.score) == 0;
        }

        public int hashCode() {
            int result = (int)(this.entity ^ this.entity >>> 32);
            result = 31 * result + (this.score != 0.0f ? Float.floatToIntBits(this.score) : 0);
            return result;
        }

        public void value(long entity, float score) {
            this.entity = entity;
            this.score = score;
        }
    }
}

