/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.impl.fulltext.StubValuesIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

class ScoreEntityIteratorTest {
    ScoreEntityIteratorTest() {
    }

    @Test
    void mergeShouldReturnOrderedResults() {
        StubValuesIterator one = new StubValuesIterator().add(3L, 10.0f).add(10L, 3.0f).add(12L, 1.0f);
        StubValuesIterator two = new StubValuesIterator().add(1L, 12.0f).add(5L, 8.0f).add(7L, 6.0f).add(8L, 5.0f).add(11L, 2.0f);
        StubValuesIterator three = new StubValuesIterator().add(2L, 11.0f).add(4L, 9.0f).add(6L, 7.0f).add(9L, 4.0f);
        ValuesIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two, three));
        for (int i = 1; i <= 12; ++i) {
            Assertions.assertTrue((boolean)concat.hasNext());
            Assertions.assertEquals((long)i, (long)concat.next());
            Assertions.assertEquals((long)i, (long)concat.current());
            Assertions.assertEquals((double)(13 - i), (double)concat.currentScore(), (double)0.001);
        }
        Assertions.assertFalse((boolean)concat.hasNext());
    }

    @Test
    void mergeShouldCorrectlyOrderSpecialValues() {
        StubValuesIterator one = new StubValuesIterator().add(2L, Float.POSITIVE_INFINITY).add(4L, 1.0f).add(6L, Float.MIN_VALUE).add(8L, -1.0f);
        StubValuesIterator two = new StubValuesIterator().add(1L, Float.NaN).add(3L, Float.MAX_VALUE).add(5L, Float.MIN_NORMAL).add(7L, 0.0f).add(9L, Float.NEGATIVE_INFINITY);
        ValuesIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two));
        Assertions.assertTrue((boolean)concat.hasNext());
        Assertions.assertEquals((long)1L, (long)concat.next());
        Assertions.assertTrue((boolean)Double.isNaN(concat.currentScore()));
        Assertions.assertEquals((long)2L, (long)concat.next());
        Assertions.assertTrue((boolean)Double.isInfinite(concat.currentScore()));
        Assertions.assertTrue((concat.currentScore() > 0.0f ? 1 : 0) != 0);
        Assertions.assertEquals((long)3L, (long)concat.next());
        Assertions.assertEquals((long)4L, (long)concat.next());
        Assertions.assertEquals((long)5L, (long)concat.next());
        Assertions.assertEquals((long)6L, (long)concat.next());
        Assertions.assertEquals((long)7L, (long)concat.next());
        Assertions.assertEquals((long)8L, (long)concat.next());
        Assertions.assertEquals((long)9L, (long)concat.next());
        Assertions.assertFalse((boolean)concat.hasNext());
    }

    @Test
    void mergeShouldHandleEmptyIterators() {
        StubValuesIterator one = new StubValuesIterator();
        StubValuesIterator two = new StubValuesIterator().add(1L, 5.0f).add(2L, 4.0f).add(3L, 3.0f).add(4L, 2.0f).add(5L, 1.0f);
        StubValuesIterator three = new StubValuesIterator();
        ValuesIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two, three));
        for (int i = 1; i <= 5; ++i) {
            Assertions.assertTrue((boolean)concat.hasNext());
            Assertions.assertEquals((long)i, (long)concat.next());
            Assertions.assertEquals((long)i, (long)concat.current());
            Assertions.assertEquals((double)(6 - i), (double)concat.currentScore(), (double)0.001);
        }
        Assertions.assertFalse((boolean)concat.hasNext());
    }

    @Test
    void mergeShouldHandleAllEmptyIterators() {
        StubValuesIterator one = new StubValuesIterator();
        StubValuesIterator two = new StubValuesIterator();
        StubValuesIterator three = new StubValuesIterator();
        ValuesIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two, three));
        Assertions.assertFalse((boolean)concat.hasNext());
    }
}

