/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.GraphDefinition;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public enum StandardGraphs implements GraphDefinition,
RelationshipType
{
    CROSS_PATHS_GRAPH{

        @Override
        public Node create(GraphDatabaseService graphdb) {
            Node start = graphdb.createNode();
            Node end = graphdb.createNode();
            Node a = graphdb.createNode();
            Node b = graphdb.createNode();
            Node c = graphdb.createNode();
            Node d = graphdb.createNode();
            start.createRelationshipTo(a, (RelationshipType)this);
            start.createRelationshipTo(b, (RelationshipType)this);
            a.createRelationshipTo(c, (RelationshipType)this);
            a.createRelationshipTo(d, (RelationshipType)this);
            b.createRelationshipTo(c, (RelationshipType)this);
            b.createRelationshipTo(d, (RelationshipType)this);
            c.createRelationshipTo(end, (RelationshipType)this);
            d.createRelationshipTo(end, (RelationshipType)this);
            return end;
        }
    }
    ,
    SMALL_CIRCLE{

        @Override
        public Node create(GraphDatabaseService graphdb) {
            Node start = graphdb.createNode();
            Node end = graphdb.createNode();
            start.createRelationshipTo(end, (RelationshipType)this);
            end.createRelationshipTo(start, (RelationshipType)this);
            return end;
        }
    }
    ,
    MATRIX_EXAMPLE{

        @Override
        public Node create(GraphDatabaseService graphdb) {
            Node neo = graphdb.createNode();
            neo.setProperty("name", (Object)"Thomas Anderson");
            neo.setProperty("age", (Object)29);
            Node trinity = graphdb.createNode();
            trinity.setProperty("name", (Object)"Trinity");
            Node morpheus = graphdb.createNode();
            morpheus.setProperty("name", (Object)"Morpheus");
            morpheus.setProperty("rank", (Object)"Captain");
            morpheus.setProperty("occupation", (Object)"Total badass");
            Node cypher = graphdb.createNode();
            cypher.setProperty("name", (Object)"Cypher");
            cypher.setProperty("last name", (Object)"Reagan");
            Node smith = graphdb.createNode();
            smith.setProperty("name", (Object)"Agent Smith");
            smith.setProperty("version", (Object)"1.0b");
            smith.setProperty("language", (Object)"C++");
            Node architect = graphdb.createNode();
            architect.setProperty("name", (Object)"The Architect");
            Relationship relationship = neo.createRelationshipTo(morpheus, (RelationshipType)MatrixTypes.KNOWS);
            relationship = neo.createRelationshipTo(trinity, (RelationshipType)MatrixTypes.KNOWS);
            relationship = morpheus.createRelationshipTo(trinity, (RelationshipType)MatrixTypes.KNOWS);
            relationship.setProperty("since", (Object)"a year before the movie");
            relationship.setProperty("cooporates on", (Object)"The Nebuchadnezzar");
            relationship = trinity.createRelationshipTo(neo, (RelationshipType)MatrixTypes.LOVES);
            relationship.setProperty("since", (Object)"meeting the oracle");
            relationship = morpheus.createRelationshipTo(cypher, (RelationshipType)MatrixTypes.KNOWS);
            relationship.setProperty("disclosure", (Object)"public");
            relationship = cypher.createRelationshipTo(smith, (RelationshipType)MatrixTypes.KNOWS);
            relationship.setProperty("disclosure", (Object)"secret");
            relationship = smith.createRelationshipTo(architect, (RelationshipType)MatrixTypes.CODED_BY);
            return neo;
        }
    };


    public static enum MatrixTypes implements RelationshipType
    {
        KNOWS,
        CODED_BY,
        LOVES;

    }
}

