/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.impl.path.Dijkstra;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.kernel.Traversal;

public class DijkstraTest
extends Neo4jAlgoTestCase {
    @Test
    public void canGetPathsInTriangleGraph() throws Exception {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        Node nodeC = graph.makeNode("C");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("B", "C", "length", 3.0);
        graph.makeEdge("A", "C", "length", 10.0);
        Dijkstra algo = new Dijkstra(PathExpanders.allTypesAndDirections(), CommonEvaluators.doubleCostEvaluator((String)"length"));
        Iterator paths = algo.findAllPaths(nodeA, nodeC).iterator();
        Assert.assertTrue((String)"expected at least one path", (boolean)paths.hasNext());
        this.assertPath((Path)paths.next(), nodeA, nodeB, nodeC);
        Assert.assertFalse((String)"expected at most one path", (boolean)paths.hasNext());
        this.assertPath((Path)algo.findSinglePath(nodeA, nodeC), nodeA, nodeB, nodeC);
    }

    @Test
    public void canContinueGettingPathsByDiminishingCost() throws Exception {
        Node nodeA = graph.makeNode("A");
        graph.makeNode("B");
        graph.makeNode("C");
        Node nodeD = graph.makeNode("D");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("B", "C", "length", 3.0);
        graph.makeEdge("C", "D", "length", 1.0);
        graph.makeEdge("B", "D", "length", 5.0);
        graph.makeEdge("A", "D", "length", 6.0);
        Dijkstra algo = new Dijkstra((RelationshipExpander)Traversal.expanderForAllTypes((Direction)Direction.OUTGOING), CommonEvaluators.doubleCostEvaluator((String)"length"), false);
        this.assertPaths(algo.findAllPaths(nodeA, nodeD), "A,B,C,D", "A,B,D", "A,D");
    }

    @Test
    public void canGetMultiplePathsInTriangleGraph() throws Exception {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        Node nodeC = graph.makeNode("C");
        HashSet<Relationship> expectedFirsts = new HashSet<Relationship>();
        expectedFirsts.add(graph.makeEdge("A", "B", "length", 1.0));
        expectedFirsts.add(graph.makeEdge("A", "B", "length", 1.0));
        Relationship expectedSecond = graph.makeEdge("B", "C", "length", 2.0);
        graph.makeEdge("A", "C", "length", 5.0);
        Dijkstra algo = new Dijkstra(PathExpanders.allTypesAndDirections(), CommonEvaluators.doubleCostEvaluator((String)"length"));
        Iterator paths = algo.findAllPaths(nodeA, nodeC).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((String)"expected more paths", (boolean)paths.hasNext());
            Path path = (Path)paths.next();
            this.assertPath(path, nodeA, nodeB, nodeC);
            Iterator relationships = path.relationships().iterator();
            Assert.assertTrue((String)"found shorter path than expected", (boolean)relationships.hasNext());
            Assert.assertTrue((String)"path contained unexpected relationship", (boolean)expectedFirsts.remove(relationships.next()));
            Assert.assertTrue((String)"found shorter path than expected", (boolean)relationships.hasNext());
            Assert.assertEquals((Object)expectedSecond, relationships.next());
            Assert.assertFalse((String)"found longer path than expected", (boolean)relationships.hasNext());
        }
        Assert.assertFalse((String)"expected at most two paths", (boolean)paths.hasNext());
    }

    @Test
    public void canGetMultiplePathsInASmallRoadNetwork() throws Exception {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        Node nodeC = graph.makeNode("C");
        Node nodeD = graph.makeNode("D");
        Node nodeE = graph.makeNode("E");
        Node nodeF = graph.makeNode("F");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("A", "C", "length", 2.5);
        graph.makeEdge("C", "D", "length", 7.3);
        graph.makeEdge("B", "D", "length", 2.5);
        graph.makeEdge("D", "E", "length", 3.0);
        graph.makeEdge("C", "E", "length", 5.0);
        graph.makeEdge("E", "F", "length", 5.0);
        graph.makeEdge("C", "F", "length", 12.0);
        graph.makeEdge("A", "F", "length", 25.0);
        Dijkstra algo = new Dijkstra(PathExpanders.allTypesAndDirections(), CommonEvaluators.doubleCostEvaluator((String)"length"));
        for (Node[] nodes : new Node[][]{{nodeA, nodeF}, {nodeF, nodeA}}) {
            int found = 0;
            Iterator paths = algo.findAllPaths(nodes[0], nodes[1]).iterator();
            for (int i = 0; i < 2; ++i) {
                Assert.assertTrue((String)"expected more paths", (boolean)paths.hasNext());
                Path path = (Path)paths.next();
                if (path.length() != found && path.length() == 3) {
                    this.assertContains(path.nodes(), nodeA, nodeC, nodeE, nodeF);
                } else if (path.length() != found && path.length() == 4) {
                    this.assertContains(path.nodes(), nodeA, nodeB, nodeD, nodeE, nodeF);
                } else {
                    Assert.fail((String)("unexpected path length: " + path.length()));
                }
                found = path.length();
            }
            Assert.assertFalse((String)"expected at most two paths", (boolean)paths.hasNext());
        }
    }
}

