/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import common.SimpleGraphBuilder;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.shortestpath.Dijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;

public class DijkstraTest
extends Neo4jAlgoTestCase {
    protected Dijkstra<Double> getDijkstra(SimpleGraphBuilder graph, Double startCost, String startNode, String endNode) {
        return new Dijkstra((Object)startCost, graph.getNode(startNode), graph.getNode(endNode), CommonEvaluators.doubleCostEvaluator((String)"cost"), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    @Test
    public void testDijkstraMinimal() {
        graph.makeNode("lonely");
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "lonely", "lonely");
        Assert.assertTrue(((Double)dijkstra.getCost() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 1 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra(graph, 3.0, "lonely", "lonely");
        Assert.assertTrue(((Double)dijkstra.getCost() == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDijkstraMinimal2() {
        graph.makeEdge("a", "b", "cost", 1.0);
        graph.makeEdge("a", "c", "cost", 1.0);
        graph.makeEdge("a", "d", "cost", 1.0);
        graph.makeEdge("a", "e", "cost", 1.0);
        graph.makeEdge("b", "c", "cost", 1.0);
        graph.makeEdge("c", "d", "cost", 1.0);
        graph.makeEdge("d", "e", "cost", 1.0);
        graph.makeEdge("e", "f", "cost", 1.0);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "a");
        Assert.assertTrue(((Double)dijkstra.getCost() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 1 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra(graph, 3.0, "a", "a");
        Assert.assertTrue(((Double)dijkstra.getCost() == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsRelationships().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPath().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDijkstraChain() {
        graph.makeEdge("a", "b", "cost", 1.0);
        graph.makeEdge("b", "c", "cost", 2.0);
        graph.makeEdge("c", "d", "cost", 3.0);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "d");
        Assert.assertTrue(((Double)dijkstra.getCost() == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes() != null ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 1 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra(graph, 0.0, "d", "a");
        Assert.assertTrue(((Double)dijkstra.getCost() == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 4 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra(graph, 0.0, "d", "b");
        Assert.assertTrue(((Double)dijkstra.getCost() == 5.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsRelationships().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPath().size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testDijstraTraverserMeeting() {
        graph.makeEdge("s", "c", "cost", 7.0);
        graph.makeEdge("c", "e", "cost", 7.0);
        graph.makeEdge("s", "a", "cost", 2.0);
        graph.makeEdge("a", "b", "cost", 7.0);
        graph.makeEdge("b", "e", "cost", 2.0);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "s", "e");
        Assert.assertTrue(((Double)dijkstra.getCost() == 11.0 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes() != null ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathAsNodes().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 1 ? 1 : 0) != 0);
    }
}

