/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.shortestpath.FloydWarshall;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class FloydWarshallTest
extends Neo4jAlgoTestCase {
    @Test
    public void testMinimal() {
        graph.makeEdge("a", "b", "cost", 1.0);
        graph.makeEdge("a", "c", "cost", 1.0);
        graph.makeEdge("a", "d", "cost", 1.0);
        graph.makeEdge("a", "e", "cost", 1.0);
        graph.makeEdge("b", "c", "cost", 1.0);
        graph.makeEdge("c", "d", "cost", 1.0);
        graph.makeEdge("d", "e", "cost", 1.0);
        graph.makeEdge("e", "b", "cost", 1.0);
        FloydWarshall floydWarshall = new FloydWarshall((Object)0.0, (Object)Double.MAX_VALUE, Direction.OUTGOING, CommonEvaluators.doubleCostEvaluator((String)"cost"), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), graph.getAllNodes(), graph.getAllEdges());
        Assert.assertTrue(((Double)floydWarshall.getCost(graph.getNode("a"), graph.getNode("a")) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)floydWarshall.getCost(graph.getNode("a"), graph.getNode("b")) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)floydWarshall.getCost(graph.getNode("b"), graph.getNode("a")) == Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testPath() {
        graph.makeEdge("a", "b", "cost", 1.0);
        graph.makeEdge("b", "c", "cost", 1.0);
        graph.makeEdge("c", "d", "cost", 1.0);
        graph.makeEdge("d", "e", "cost", 1.0);
        graph.makeEdge("e", "f", "cost", 1.0);
        FloydWarshall floydWarshall = new FloydWarshall((Object)0.0, (Object)Double.MAX_VALUE, Direction.OUTGOING, CommonEvaluators.doubleCostEvaluator((String)"cost"), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), graph.getAllNodes(), graph.getAllEdges());
        List path = floydWarshall.getPath(graph.getNode("a"), graph.getNode("f"));
        Assert.assertTrue((path.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Node)path.get(0)).equals(graph.getNode("a")));
        Assert.assertTrue((boolean)((Node)path.get(1)).equals(graph.getNode("b")));
        Assert.assertTrue((boolean)((Node)path.get(2)).equals(graph.getNode("c")));
        Assert.assertTrue((boolean)((Node)path.get(3)).equals(graph.getNode("d")));
        Assert.assertTrue((boolean)((Node)path.get(4)).equals(graph.getNode("e")));
        Assert.assertTrue((boolean)((Node)path.get(5)).equals(graph.getNode("f")));
    }

    @Test
    public void testDirection() {
        graph.makeEdge("a", "b");
        graph.makeEdge("b", "c");
        graph.makeEdge("c", "d");
        graph.makeEdge("d", "a");
        graph.makeEdge("s", "a");
        graph.makeEdge("b", "s");
        graph.makeEdge("e", "c");
        graph.makeEdge("d", "e");
        new FloydWarshall((Object)0.0, (Object)Double.MAX_VALUE, Direction.OUTGOING, (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Assert.assertEquals((Object)Direction.OUTGOING, (Object)direction);
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), graph.getAllNodes(), graph.getAllEdges()).calculate();
        new FloydWarshall((Object)0.0, (Object)Double.MAX_VALUE, Direction.INCOMING, (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Assert.assertEquals((Object)Direction.INCOMING, (Object)direction);
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), graph.getAllNodes(), graph.getAllEdges()).calculate();
    }
}

