/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class AbstractTestBase {
    private static GraphDatabaseService graphdb;

    @BeforeClass
    public static void beforeSuite() {
        graphdb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @AfterClass
    public static void afterSuite() {
        graphdb.shutdown();
        graphdb = null;
    }

    protected static Node getNode(long id) {
        return graphdb.getNodeById(id);
    }

    protected static Transaction beginTx() {
        return graphdb.beginTx();
    }

    protected static <T> void expect(Iterable<? extends T> items, Representation<T> representation, String ... expected) {
        AbstractTestBase.expect(items, representation, new HashSet<String>(Arrays.asList(expected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> void expect(Iterable<? extends T> items, Representation<T> representation, Set<String> expected) {
        Transaction tx = AbstractTestBase.beginTx();
        try {
            for (T item : items) {
                String repr = representation.represent(item);
                Assert.assertTrue((String)(repr + " not expected "), (boolean)expected.remove(repr));
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        if (!expected.isEmpty()) {
            Assert.fail((String)("The exepected elements " + expected + " were not returned."));
        }
    }

    protected static final class RelationshipRepresentation
    implements Representation<Relationship> {
        private final Representation<? super Node> nodes;
        private final Representation<? super Relationship> rel;

        public RelationshipRepresentation(Representation<? super Node> nodes, Representation<? super Relationship> rel) {
            this.nodes = nodes;
            this.rel = rel;
        }

        @Override
        public String represent(Relationship item) {
            return this.nodes.represent((Node)item.getStartNode()) + " " + this.rel.represent((Relationship)item) + " " + this.nodes.represent((Node)item.getEndNode());
        }
    }

    protected static interface Representation<T> {
        public String represent(T var1);
    }
}

