/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.SimpleGraphBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class Neo4jAlgoTestCase {
    protected static GraphDatabaseService graphDb;
    protected static SimpleGraphBuilder graph;
    protected Transaction tx;

    @BeforeClass
    public static void setUpGraphDb() throws Exception {
        graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        graph = new SimpleGraphBuilder(graphDb, MyRelTypes.R1);
    }

    @Before
    public void setUpTransaction() {
        this.tx = graphDb.beginTx();
    }

    @AfterClass
    public static void tearDownGraphDb() throws Exception {
        graphDb.shutdown();
    }

    @After
    public void tearDownTransactionAndGraph() {
        graph.clear();
        this.tx.success();
        this.tx.finish();
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : (File[])SillyUtils.nonNull((Object)file.listFiles())) {
                Neo4jAlgoTestCase.deleteFileOrDirectory(child);
            }
        } else {
            Assert.assertTrue((String)("delete " + file), (boolean)file.delete());
        }
    }

    protected void assertPathDef(Path path, String ... names) {
        int i = 0;
        for (Node node : path.nodes()) {
            Assert.assertEquals((String)("Wrong node " + i + " in " + this.getPathDef(path)), (Object)names[i++], (Object)node.getProperty("name"));
        }
        Assert.assertEquals((long)names.length, (long)i);
    }

    protected void assertPath(Path path, Node ... nodes) {
        int i = 0;
        for (Node node : path.nodes()) {
            Assert.assertEquals((String)("Wrong node " + i + " in " + this.getPathDef(path)), (Object)nodes[i++].getProperty("name"), (Object)node.getProperty("name"));
        }
        Assert.assertEquals((long)nodes.length, (long)i);
    }

    protected <E> void assertContains(Iterable<E> actual, E ... expected) {
        HashSet<E> expectation = new HashSet<E>(Arrays.asList(expected));
        for (E element : actual) {
            if (expectation.remove(element)) continue;
            Assert.fail((String)("unexpected element <" + element + ">"));
        }
        if (!expectation.isEmpty()) {
            Assert.fail((String)("the expected elements <" + expectation + "> were not contained"));
        }
    }

    public String getPathDef(Path path) {
        StringBuilder builder = new StringBuilder();
        for (Node node : path.nodes()) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(node.getProperty("name"));
        }
        return builder.toString();
    }

    public void assertPaths(Iterable<? extends Path> paths, String ... pathDefinitions) {
        ArrayList<String> pathDefs = new ArrayList<String>(Arrays.asList(pathDefinitions));
        ArrayList<String> unexpectedDefs = new ArrayList<String>();
        for (Path path : paths) {
            String pathDef = this.getPathDef(path);
            int index = pathDefs.indexOf(pathDef);
            if (index != -1) {
                pathDefs.remove(index);
                continue;
            }
            unexpectedDefs.add(this.getPathDef(path));
        }
        Assert.assertTrue((String)("These unexpected paths were found: " + unexpectedDefs + ". In addition these expected paths weren't found:" + pathDefs), (boolean)unexpectedDefs.isEmpty());
        Assert.assertTrue((String)("These were expected, but not found: " + ((Object)pathDefs).toString()), (boolean)pathDefs.isEmpty());
    }

    static {
        graph = null;
    }

    public static enum MyRelTypes implements RelationshipType
    {
        R1,
        R2,
        R3;

    }
}

