/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.ClosenessCentrality;
import org.neo4j.graphalgo.impl.centrality.CostDivider;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class ClosenessCentralityTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    ClosenessCentrality<Double> getCentralityAlgorithm() {
        return new ClosenessCentrality(this.getSingleSourceShortestPath(), (CostAccumulator)new DoubleAdder(), (Object)0.0, graph.getAllNodes(), (CostDivider)new CostDivider<Double>(){

            public Double divideByCost(Double d, Double c) {
                return d / c;
            }

            public Double divideCost(Double c, Double d) {
                return c / d;
            }
        });
    }

    protected void assertCentrality(ClosenessCentrality<Double> closenessCentrality, String nodeId, Double value) {
        Assert.assertTrue((boolean)((Double)closenessCentrality.getCentrality(graph.getNode(nodeId))).equals(value));
    }

    @Test
    public void testBox() {
        graph.makeEdgeChain("a,b,c,d,a");
        ClosenessCentrality<Double> closenessCentrality = this.getCentralityAlgorithm();
        this.assertCentrality(closenessCentrality, "a", 0.25);
        this.assertCentrality(closenessCentrality, "b", 0.25);
        this.assertCentrality(closenessCentrality, "c", 0.25);
        this.assertCentrality(closenessCentrality, "d", 0.25);
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("d,b,e");
        ClosenessCentrality<Double> closenessCentrality = this.getCentralityAlgorithm();
        this.assertCentrality(closenessCentrality, "a", 0.14285714285714285);
        this.assertCentrality(closenessCentrality, "b", 0.25);
        this.assertCentrality(closenessCentrality, "c", 0.14285714285714285);
        this.assertCentrality(closenessCentrality, "d", 0.14285714285714285);
        this.assertCentrality(closenessCentrality, "e", 0.14285714285714285);
    }

    @Test
    public void testChain() {
        graph.makeEdgeChain("a,b,c,d,e");
        ClosenessCentrality<Double> closenessCentrality = this.getCentralityAlgorithm();
        this.assertCentrality(closenessCentrality, "a", 0.1);
        this.assertCentrality(closenessCentrality, "b", 0.14285714285714285);
        this.assertCentrality(closenessCentrality, "c", 0.16666666666666666);
        this.assertCentrality(closenessCentrality, "d", 0.14285714285714285);
        this.assertCentrality(closenessCentrality, "e", 0.1);
    }
}

