/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentrality;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentralityPower;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public abstract class EigenvectorCentralityTest
extends Neo4jAlgoTestCase {
    protected void assertCentrality(EigenvectorCentralityPower eigenvectorCentralityPower, String nodeId, Double value) {
        Assert.assertEquals((Object)value, (Object)eigenvectorCentralityPower.getCentrality(graph.getNode(nodeId)));
    }

    protected void assertApproximateCentrality(EigenvectorCentrality eigenvectorCentrality, String nodeId, Double value, Double precision) {
        Double centrality = eigenvectorCentrality.getCentrality(graph.getNode(nodeId));
        Assert.assertEquals((double)value, (double)centrality, (double)precision);
    }

    public abstract EigenvectorCentrality getEigenvectorCentrality(Direction var1, CostEvaluator<Double> var2, Set<Node> var3, Set<Relationship> var4, double var5);

    @Test
    public void testRun() {
        graph.makeEdgeChain("a,b,c,d");
        graph.makeEdges("b,a,c,a");
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.693, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.523, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.395, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.298, 0.01);
    }

    @Test
    public void testDirection() {
        graph.makeEdgeChain("d,c,b,a");
        graph.makeEdges("a,b,a,c");
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.INCOMING, new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.693, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.523, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.395, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.298, 0.01);
    }

    @Test
    public void testWeight() {
        graph.makeEdgeChain("a,b", "cost", 1.0);
        graph.makeEdgeChain("b,c", "cost", 1.0);
        graph.makeEdgeChain("c,d", "cost", 1.0);
        graph.makeEdgeChain("c,b", "cost", 0.1);
        graph.makeEdgeChain("c,a", "cost", 0.1);
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, (CostEvaluator<Double>)CommonEvaluators.doubleCostEvaluator((String)"cost"), graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.0851, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.244, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.456, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.852, 0.01);
    }

    @Test
    public void testWeightAndDirection() {
        graph.makeEdgeChain("a,b");
        graph.makeEdgeChain("b,c");
        graph.makeEdgeChain("c,d");
        graph.makeEdgeChain("c,a");
        final HashMap<String, Double> costs = new HashMap<String, Double>();
        costs.put("a,b", 1.0);
        costs.put("b,c", 1.0);
        costs.put("c,d", 1.0);
        costs.put("c,b", 0.1);
        costs.put("c,a", 0.1);
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.BOTH, new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Double value;
                String start = graph.getNodeId(relationship.getStartNode());
                String end = graph.getNodeId(relationship.getEndNode());
                if (direction == Direction.INCOMING) {
                    String tmp = end;
                    end = start;
                    start = tmp;
                }
                if ((value = (Double)costs.get(start + "," + end)) == null) {
                    return 0.0;
                }
                return value;
            }
        }, graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.0851, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.244, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.456, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.852, 0.01);
    }
}

