/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;

public class PathImplTest {
    @Test
    public void pathsWithTheSameContentsShouldBeEqual() throws Exception {
        Path firstPath = new PathImpl.Builder(this.node(1337L)).push(this.rel(1337L, 7331L)).build();
        Path secondPath = new PathImpl.Builder(this.node(1337L)).push(this.rel(1337L, 7331L)).build();
        Assert.assertEquals((Object)firstPath, (Object)secondPath);
        Assert.assertEquals((Object)secondPath, (Object)firstPath);
    }

    @Test
    public void pathsWithDifferentLengthAreNotEqual() throws Exception {
        Path firstPath = new PathImpl.Builder(this.node(1337L)).push(this.rel(1337L, 7331L)).build();
        Path secondPath = new PathImpl.Builder(this.node(1337L)).push(this.rel(1337L, 7331L)).push(this.rel(7331L, 13L)).build();
        Assert.assertThat((Object)firstPath, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)secondPath)));
        Assert.assertThat((Object)secondPath, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)firstPath)));
    }

    private Node node(long id) {
        return new MockNode(id);
    }

    private Relationship rel(long fromId, long toId) {
        return new MockRelationship(fromId, toId);
    }

    class MockRelationship
    extends MockPropertyContainer
    implements Relationship {
        private final long fromNode;
        private final long toNode;

        public MockRelationship(long fromNode, long toNode) {
            this.fromNode = fromNode;
            this.toNode = toNode;
        }

        public long getId() {
            return this.fromNode ^ this.toNode;
        }

        public boolean equals(Object other) {
            return other instanceof Relationship && ((Relationship)other).getId() == this.getId();
        }

        public Node getOtherNode(Node node) {
            return node.getId() == this.fromNode ? new MockNode(this.toNode) : new MockNode(this.fromNode);
        }

        public Node getStartNode() {
            return new MockNode(this.fromNode);
        }

        public RelationshipType getType() {
            return DynamicRelationshipType.withName((String)"Banana");
        }

        public void delete() {
        }

        public Node getEndNode() {
            return null;
        }

        public Node[] getNodes() {
            return new Node[0];
        }

        public boolean isType(RelationshipType type) {
            return false;
        }
    }

    class MockNode
    extends MockPropertyContainer
    implements Node {
        private final long id;

        public MockNode(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object other) {
            return other instanceof Node && ((Node)other).getId() == this.id;
        }

        public void delete() {
        }

        public Iterable<Relationship> getRelationships() {
            return null;
        }

        public boolean hasRelationship() {
            return false;
        }

        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            return null;
        }

        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return null;
        }

        public boolean hasRelationship(RelationshipType ... types) {
            return false;
        }

        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return false;
        }

        public Iterable<Relationship> getRelationships(Direction dir) {
            return null;
        }

        public boolean hasRelationship(Direction dir) {
            return false;
        }

        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            return null;
        }

        public boolean hasRelationship(RelationshipType type, Direction dir) {
            return false;
        }

        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return null;
        }

        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            return null;
        }

        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
            return null;
        }

        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
            return null;
        }

        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
            return null;
        }

        public void addLabel(Label label) {
        }

        public void removeLabel(Label label) {
        }

        public boolean hasLabel(Label label) {
            return false;
        }

        public ResourceIterable<Label> getLabels() {
            return null;
        }

        public Iterable<RelationshipType> getRelationshipTypes() {
            return null;
        }

        public int getDegree() {
            return 0;
        }

        public int getDegree(RelationshipType type) {
            return 0;
        }

        public int getDegree(Direction direction) {
            return 0;
        }

        public int getDegree(RelationshipType type, Direction direction) {
            return 0;
        }
    }

    class MockPropertyContainer
    implements PropertyContainer {
        MockPropertyContainer() {
        }

        public GraphDatabaseService getGraphDatabase() {
            return null;
        }

        public boolean hasProperty(String key) {
            return false;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public void setProperty(String key, Object value) {
        }

        public Object removeProperty(String key) {
            return null;
        }

        public Iterable<String> getPropertyKeys() {
            return null;
        }
    }
}

