/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.shortestpath.Dijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class DijkstraMultipleRelationshipTypesTest
extends Neo4jAlgoTestCase {
    protected Dijkstra<Double> getDijkstra(String startNode, String endNode, RelationshipType ... relTypes) {
        return new Dijkstra((Object)0.0, graph.getNode(startNode), graph.getNode(endNode), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, relTypes);
    }

    @Test
    public void testRun() {
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R1);
        graph.makeEdgeChain("a,b,c,d,e");
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R2);
        graph.makeEdges("a,c");
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R3);
        graph.makeEdges("c,e");
        Dijkstra<Double> dijkstra = this.getDijkstra("a", "e", Neo4jAlgoTestCase.MyRelTypes.R1);
        Assert.assertTrue(((Double)dijkstra.getCost() == 4.0 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra("a", "e", Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R2);
        Assert.assertTrue(((Double)dijkstra.getCost() == 3.0 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra("a", "e", Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R3);
        Assert.assertTrue(((Double)dijkstra.getCost() == 3.0 ? 1 : 0) != 0);
        dijkstra = this.getDijkstra("a", "e", Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R2, Neo4jAlgoTestCase.MyRelTypes.R3);
        Assert.assertTrue(((Double)dijkstra.getCost() == 2.0 ? 1 : 0) != 0);
    }
}

