/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.BetweennessCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class BetweennessCentralityTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R2, Neo4jAlgoTestCase.MyRelTypes.R3});
    }

    protected void assertCentrality(BetweennessCentrality<Double> betweennessCentrality, String nodeId, Double value) {
        Assert.assertTrue((boolean)((Double)betweennessCentrality.getCentrality(graph.getNode(nodeId))).equals(value));
    }

    @Test
    public void testBox() {
        graph.makeEdgeChain("a,b,c,d,a");
        BetweennessCentrality betweennessCentrality = new BetweennessCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        betweennessCentrality.calculate();
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "a", 0.5);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "b", 0.5);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "c", 0.5);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "d", 0.5);
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R3);
        graph.makeEdgeChain("d,b,e");
        BetweennessCentrality betweennessCentrality = new BetweennessCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        betweennessCentrality.calculate();
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "a", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "b", 6.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "c", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "d", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "e", 0.0);
    }

    @Test
    public void testChain() {
        graph.makeEdgeChain("a,b,c,d,e");
        BetweennessCentrality betweennessCentrality = new BetweennessCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        betweennessCentrality.calculate();
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "a", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "b", 3.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "c", 4.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "d", 3.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "e", 0.0);
    }

    @Test
    public void testXlike() {
        graph.makeEdgeChain("a,c,a");
        graph.makeEdgeChain("b,c,b");
        graph.makeEdgeChain("b,d,b");
        graph.makeEdgeChain("c,d,c");
        graph.makeEdgeChain("d,e,d");
        graph.makeEdgeChain("d,f,d");
        BetweennessCentrality betweennessCentrality = new BetweennessCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        betweennessCentrality.calculate();
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "a", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "b", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "c", 4.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "d", 7.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "e", 0.0);
        this.assertCentrality((BetweennessCentrality<Double>)betweennessCentrality, "f", 0.0);
    }

    @Test
    public void testDependencyUpdating() {
        graph.makeEdgeChain("a,b,d,e,f,h");
        graph.makeEdgeChain("a,c,d");
        graph.makeEdgeChain("e,g,h");
        new DependencyTest(this.getSingleSourceShortestPath(), graph.getAllNodes()).test();
    }

    class DependencyTest
    extends BetweennessCentrality<Double> {
        public DependencyTest(SingleSourceShortestPath<Double> singleSourceShortestPath, Set<Node> nodeSet) {
            super(singleSourceShortestPath, nodeSet);
        }

        public void test() {
            this.doneCalculation = true;
            Node startNode = graph.getNode("a");
            this.singleSourceShortestPath.reset();
            this.singleSourceShortestPath.setStartNode(startNode);
            Map predecessors = this.singleSourceShortestPath.getPredecessors();
            Map successors = Util.reversedPredecessors((Map)predecessors);
            Util.PathCounter counter = new Util.PathCounter(predecessors);
            this.getAndUpdateNodeDependency(startNode, true, successors, counter, new HashMap());
            Double adjustment = 0.5;
            BetweennessCentralityTest.this.assertCentrality(this, "a", 0.0 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "b", 2.5 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "c", 2.5 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "d", 4.0 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "e", 3.0 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "f", 0.5 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "g", 0.5 * adjustment);
            BetweennessCentralityTest.this.assertCentrality(this, "h", 0.0 * adjustment);
        }
    }
}

