/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class GeoDataGenerator {
    private final Random random = new Random();
    private final int numberOfNodes;
    private final int numberOfConnections;
    private final int width;
    private final int height;
    private int maxDistance = 3;
    private double neighborConnectionFactor = 0.6;

    public GeoDataGenerator(int numberOfNodes, double connectionDensity, int width, int height) {
        this.numberOfNodes = numberOfNodes;
        this.numberOfConnections = (int)((double)numberOfNodes * connectionDensity);
        this.width = width;
        this.height = height;
    }

    public GeoDataGenerator withMaxNeighborDistance(int maxDistance, double neighborConnectionFactor) {
        this.maxDistance = maxDistance;
        this.neighborConnectionFactor = neighborConnectionFactor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(File storeDir) {
        BatchInserter inserter = BatchInserters.inserter((String)storeDir.getAbsolutePath());
        Grid grid = new Grid();
        try {
            int i;
            for (i = 0; i < this.numberOfNodes; ++i) {
                grid.createNodeAtRandomLocation(this.random, inserter);
            }
            for (i = 0; i < this.numberOfConnections; ++i) {
                grid.createConnection(this.random, inserter);
            }
        }
        finally {
            inserter.shutdown();
        }
    }

    public static EstimateEvaluator<Double> estimateEvaluator() {
        return new FlatEstimateEvaluator();
    }

    private static class FlatEstimateEvaluator
    implements EstimateEvaluator<Double> {
        private double[] cachedGoal;

        private FlatEstimateEvaluator() {
        }

        public Double getCost(Node node, Node goal) {
            if (this.cachedGoal == null) {
                this.cachedGoal = new double[]{(Double)goal.getProperty("x"), (Double)goal.getProperty("y")};
            }
            double x = (Double)node.getProperty("x");
            double y = (Double)node.getProperty("y");
            double deltaX = Math.abs(x - this.cachedGoal[0]);
            double deltaY = Math.abs(y - this.cachedGoal[1]);
            return Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
        }
    }

    public static enum RelationshipTypes implements RelationshipType
    {
        CONNECTION;

    }

    private class Grid {
        private final int cellsX;
        private final int cellsY;
        private final double sizeX;
        private final double sizeY;
        private final Cell[][] cells;
        private final Map<String, Object> nodePropertyScratchMap = new HashMap<String, Object>();
        private final Map<String, Object> relationshipPropertyScratchMap = new HashMap<String, Object>();

        Grid() {
            this.cellsX = 100;
            this.cellsY = 100;
            this.sizeX = (double)GeoDataGenerator.this.width / (double)this.cellsX;
            this.sizeY = (double)GeoDataGenerator.this.height / (double)this.cellsY;
            this.cells = new Cell[this.cellsX][this.cellsY];
            for (int x = 0; x < this.cellsX; ++x) {
                for (int y = 0; y < this.cellsY; ++y) {
                    this.cells[x][y] = new Cell();
                }
            }
        }

        void createNodeAtRandomLocation(Random random, BatchInserter inserter) {
            double x = (float)random.nextInt(GeoDataGenerator.this.width - 1) + random.nextFloat();
            double y = (float)random.nextInt(GeoDataGenerator.this.height - 1) + random.nextFloat();
            this.nodePropertyScratchMap.put("x", x);
            this.nodePropertyScratchMap.put("y", y);
            long node = inserter.createNode(this.nodePropertyScratchMap, new Label[0]);
            this.cells[(int)(x / this.sizeX)][(int)(y / this.sizeY)].add(new PositionedNode(node, x, y));
        }

        void createConnection(Random random, BatchInserter inserter) {
            int firstCellX = random.nextInt(this.cellsX);
            int firstCellY = random.nextInt(this.cellsY);
            int otherCellX = this.vicinity(random, firstCellX, this.cellsX);
            int otherCellY = this.vicinity(random, firstCellY, this.cellsY);
            Cell firstCell = this.cells[firstCellX][firstCellY];
            Cell otherCell = this.cells[otherCellX][otherCellY];
            PositionedNode firstNode = firstCell.get(random);
            PositionedNode otherNode = otherCell.get(random);
            this.relationshipPropertyScratchMap.put("weight", this.factor(random, firstNode.distanceTo(otherNode), 0.5));
            inserter.createRelationship(firstNode.node, otherNode.node, (RelationshipType)RelationshipTypes.CONNECTION, this.relationshipPropertyScratchMap);
        }

        private int vicinity(Random random, int position, int maxPosition) {
            int distance = this.distance(random, GeoDataGenerator.this.maxDistance);
            int result = position + distance * (random.nextBoolean() ? 1 : -1);
            if (result < 0) {
                result = 0;
            }
            if (result >= maxPosition) {
                result = maxPosition - 1;
            }
            return result;
        }

        private int distance(Random random, int max) {
            for (int i = 0; i < max; ++i) {
                if (!((double)random.nextFloat() < GeoDataGenerator.this.neighborConnectionFactor)) continue;
                return i;
            }
            return max;
        }

        private double factor(Random random, double value, double maxDivergence) {
            double divergence = random.nextDouble() * maxDivergence;
            divergence = random.nextBoolean() ? 1.0 - divergence : 1.0 + divergence;
            return value * divergence;
        }
    }

    private static class Cell {
        private final List<PositionedNode> nodes = new ArrayList<PositionedNode>();

        private Cell() {
        }

        void add(PositionedNode node) {
            this.nodes.add(node);
        }

        PositionedNode get(Random random) {
            return this.nodes.get(random.nextInt(this.nodes.size()));
        }
    }

    private static class PositionedNode {
        private final long node;
        private final double x;
        private final double y;

        PositionedNode(long node, double x, double y) {
            this.node = node;
            this.x = x;
            this.y = y;
        }

        public double distanceTo(PositionedNode other) {
            return Math.sqrt(Math.pow(Math.abs(this.x - other.x), 2.0) + Math.pow(Math.abs(this.y - other.y), 2.0));
        }
    }
}

