/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import org.junit.Test;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;

public class TestAllPaths
extends Neo4jAlgoTestCase {
    protected PathFinder<Path> instantiatePathFinder(int maxDepth) {
        return GraphAlgoFactory.allPaths((PathExpander)PathExpanders.allTypesAndDirections(), (int)maxDepth);
    }

    @Test
    public void testCircularGraph() {
        graph.makeEdge("a", "b");
        graph.makeEdge("b", "c");
        graph.makeEdge("b", "c");
        graph.makeEdge("b", "d");
        graph.makeEdge("c", "d");
        graph.makeEdge("c", "e");
        PathFinder<Path> finder = this.instantiatePathFinder(10);
        Iterable paths = finder.findAllPaths(graph.getNode("a"), graph.getNode("e"));
        this.assertPaths(paths, "a,b,c,e", "a,b,c,e", "a,b,d,c,e", "a,b,c,d,b,c,e", "a,b,c,d,b,c,e", "a,b,c,b,d,c,e", "a,b,c,b,d,c,e", "a,b,d,c,b,c,e", "a,b,d,c,b,c,e");
    }

    @Test
    public void testTripleRelationshipGraph() {
        graph.makeEdge("a", "b");
        graph.makeEdge("b", "c");
        graph.makeEdge("b", "c");
        graph.makeEdge("b", "c");
        graph.makeEdge("c", "d");
        PathFinder<Path> finder = this.instantiatePathFinder(10);
        Iterable paths = finder.findAllPaths(graph.getNode("a"), graph.getNode("d"));
        this.assertPaths(paths, "a,b,c,d", "a,b,c,d", "a,b,c,d", "a,b,c,b,c,d", "a,b,c,b,c,d", "a,b,c,b,c,d", "a,b,c,b,c,d", "a,b,c,b,c,d", "a,b,c,b,c,d");
    }
}

