/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.helpers.collection.MapUtil;

public class TestDijkstra
extends Neo4jAlgoTestCase {
    private Relationship createGraph(boolean includeOnes) {
        Map propertiesForOnes = includeOnes ? MapUtil.map((Object[])new Object[]{"cost", 1.0}) : MapUtil.map((Object[])new Object[0]);
        graph.makeEdge("start", "a", "cost", 1.0);
        graph.makeEdge("a", "x", "cost", (short)9);
        graph.makeEdge("a", "b", propertiesForOnes);
        graph.makeEdge("b", "x", "cost", 7.0);
        graph.makeEdge("b", "c", propertiesForOnes);
        graph.makeEdge("c", "x", "cost", 5);
        Relationship shortCTOXRelationship = graph.makeEdge("c", "x", "cost", Float.valueOf(3.0f));
        graph.makeEdge("c", "d", propertiesForOnes);
        graph.makeEdge("d", "x", "cost", 3.0);
        graph.makeEdge("d", "e", propertiesForOnes);
        graph.makeEdge("e", "x", propertiesForOnes);
        graph.makeEdge("e", "f", "cost", (byte)2);
        graph.makeEdge("x", "y", "cost", 2.0);
        return shortCTOXRelationship;
    }

    @Test
    public void testSmallGraph() {
        Relationship shortCTOXRelationship = this.createGraph(true);
        PathFinder finder = GraphAlgoFactory.dijkstra((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), (String)"cost");
        PathFinder finder2 = GraphAlgoFactory.dijkstra((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)"cost"));
        Node startNode = graph.getNode("start");
        Node endNode = graph.getNode("x");
        this.assertPaths(finder.findAllPaths(startNode, endNode), "start,a,b,c,x", "start,a,b,c,d,e,x");
        this.assertPaths(finder2.findAllPaths(startNode, endNode), "start,a,b,c,x", "start,a,b,c,d,e,x");
        for (WeightedPath path : finder.findAllPaths(startNode, endNode)) {
            if (!this.getPathDef((Path)path).equals("start,a,b,c,x")) continue;
            this.assertContainsRelationship(path, shortCTOXRelationship);
        }
    }

    @Test
    public void testSmallGraphWithDefaults() {
        Relationship shortCTOXRelationship = this.createGraph(true);
        PathFinder finder = GraphAlgoFactory.dijkstra((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)"cost", (double)1.0));
        Node startNode = graph.getNode("start");
        Node endNode = graph.getNode("x");
        this.assertPaths(finder.findAllPaths(startNode, endNode), "start,a,b,c,x", "start,a,b,c,d,e,x");
        for (WeightedPath path : finder.findAllPaths(startNode, endNode)) {
            if (!this.getPathDef((Path)path).equals("start,a,b,c,x")) continue;
            this.assertContainsRelationship(path, shortCTOXRelationship);
        }
    }

    private void assertContainsRelationship(WeightedPath path, Relationship relationship) {
        for (Relationship rel : path.relationships()) {
            if (!rel.equals(relationship)) continue;
            return;
        }
        Assert.fail((String)(path + " should've contained " + relationship));
    }

    @Ignore(value="See issue #627")
    @Test
    public void determineLongestPath() throws Exception {
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"EDGE");
        graph.setCurrentRelType((RelationshipType)type);
        graph.makeEdgeChain("0,1,2,3,4");
        graph.makeEdge("0", "2");
        graph.makeEdge("0", "3");
        graph.makeEdge("0", "4");
        this.setWeight("0", "1", -0.1);
        this.setWeight("1", "2", -0.1);
        this.setWeight("2", "3", -1.0);
        this.setWeight("3", "4", -0.1);
        this.setWeight("0", "2", -0.1);
        this.setWeight("0", "3", -1.0);
        this.setWeight("0", "4", -0.1);
        Node node0 = graph.getNode("0");
        Node node1 = graph.getNode("1");
        Node node2 = graph.getNode("2");
        Node node3 = graph.getNode("3");
        Node node4 = graph.getNode("4");
        PathFinder pathFinder = GraphAlgoFactory.dijkstra((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)type, (Direction)Direction.OUTGOING), (String)"weight");
        WeightedPath wPath = (WeightedPath)pathFinder.findSinglePath(node0, node4);
        this.assertPath((Path)wPath, node0, node1, node2, node3, node4);
    }

    @Test
    public void withState() throws Exception {
        graph.makeEdgeChain("a,b,c,d");
        this.setWeight("a", "b", 1.0);
        this.setWeight("b", "c", 2.0);
        this.setWeight("c", "d", 5.0);
        InitialBranchState.State state = new InitialBranchState.State((Object)0, (Object)0);
        final HashMap encounteredState = new HashMap();
        PathExpander<Integer> expander = new PathExpander<Integer>(){

            public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
                if (path.length() > 0) {
                    int newState = (Integer)state.getState() + ((Number)path.lastRelationship().getProperty("weight")).intValue();
                    state.setState((Object)newState);
                    encounteredState.put(path.endNode(), newState);
                }
                return path.endNode().getRelationships();
            }

            public PathExpander<Integer> reverse() {
                return this;
            }
        };
        this.assertPaths(GraphAlgoFactory.dijkstra((PathExpander)expander, (InitialBranchState)state, (String)"weight").findAllPaths(graph.getNode("a"), graph.getNode("d")), "a,b,c,d");
        Assert.assertEquals((long)1L, (long)((Integer)encounteredState.get(graph.getNode("b"))).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)encounteredState.get(graph.getNode("c"))).intValue());
        Assert.assertEquals((long)8L, (long)((Integer)encounteredState.get(graph.getNode("d"))).intValue());
    }

    private void setWeight(String start, String end, double weight) {
        Node startNode = graph.getNode(start);
        Node endNode = graph.getNode(end);
        for (Relationship rel : startNode.getRelationships()) {
            if (!rel.getOtherNode(startNode).equals(endNode)) continue;
            rel.setProperty("weight", (Object)weight);
            return;
        }
        throw new RuntimeException("No relationship between nodes " + start + " and " + end);
    }
}

