/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.path.ShortestPath;
import org.neo4j.graphalgo.impl.path.TraversalShortestPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;

public class TestShortestPath
extends Neo4jAlgoTestCase {
    @Test
    public void testSimplestGraph() {
        graph.makeEdge("s", "t");
        graph.makeEdge("s", "t");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                Iterable paths = finder.findAllPaths(graph.getNode("s"), graph.getNode("t"));
                TestShortestPath.this.assertPaths(paths, "s,t", "s,t");
                TestShortestPath.this.assertPaths(Arrays.asList(finder.findSinglePath(graph.getNode("s"), graph.getNode("t"))), "s,t");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 1);
    }

    @Test
    public void testAnotherSimpleGraph() {
        graph.makeEdge("s", "m");
        graph.makeEdge("m", "o");
        graph.makeEdge("s", "n");
        graph.makeEdge("n", "p");
        graph.makeEdge("p", "q");
        graph.makeEdge("q", "t");
        graph.makeEdge("n", "o");
        graph.makeEdge("o", "t");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                Iterable paths = finder.findAllPaths(graph.getNode("s"), graph.getNode("t"));
                TestShortestPath.this.assertPaths(paths, "s,m,o,t", "s,n,o,t");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 6);
    }

    @Test
    public void testCrossedCircle() {
        graph.makeEdge("s", "1");
        graph.makeEdge("s", "3");
        graph.makeEdge("1", "2");
        graph.makeEdge("1", "4");
        graph.makeEdge("3", "2");
        graph.makeEdge("3", "4");
        graph.makeEdge("2", "t");
        graph.makeEdge("4", "t");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("s"), graph.getNode("t")), "s,1,2,t", "s,1,4,t", "s,3,2,t", "s,3,4,t");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 3);
    }

    @Test
    public void testDirectedFinder() {
        graph.makeEdgeChain("a,b,c,d,e,f,m");
        graph.makeEdgeChain("a,g,h,i,j,k,l,m");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("a"), graph.getNode("j")), "a,g,h,i,j");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), 4);
    }

    @Test
    public void testExactDepthFinder() {
        graph.makeEdgeChain("a,c,g,k");
        graph.makeEdgeChain("a,b,d,j,k");
        graph.makeEdgeChain("b,e,f,h,i,j");
        graph.makeEdgeChain("d,h");
        Expander expander = Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING);
        Node a = graph.getNode("a");
        Node k = graph.getNode("k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)3).findAllPaths(a, k), "a,c,g,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)4).findAllPaths(a, k), "a,b,d,j,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)5).findAllPaths(a, k), new String[0]);
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)6).findAllPaths(a, k), "a,b,d,h,i,j,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)7).findAllPaths(a, k), "a,b,e,f,h,i,j,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)8).findAllPaths(a, k), new String[0]);
    }

    @Test
    public void makeSureShortestPathsReturnsNoLoops() {
        graph.makeEdgeChain("a,b,c,d,b,c,e");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                Node a = graph.getNode("a");
                Node e = graph.getNode("e");
                TestShortestPath.this.assertPaths(finder.findAllPaths(a, e), "a,b,c,e", "a,b,c,e");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 6);
    }

    @Test
    public void testExactDepthPathsReturnsNoLoops() {
        graph.makeEdgeChain("a,b,c,d,b,c,e");
        Node a = graph.getNode("a");
        Node e = graph.getNode("e");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), (int)3).findAllPaths(a, e), "a,b,c,e", "a,b,c,e");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), (int)4).findAllPaths(a, e), "a,b,d,c,e");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), (int)6).findAllPaths(a, e), new String[0]);
    }

    @Test
    public void withFilters() throws Exception {
        graph.makeEdgeChain("a,b,c,d");
        graph.makeEdgeChain("a,g,h,d");
        final Node a = graph.getNode("a");
        final Node d = graph.getNode("d");
        Node b = graph.getNode("b");
        b.setProperty("skip", (Object)true);
        Predicate<Node> filter = new Predicate<Node>(){

            public boolean accept(Node item) {
                boolean skip = (Boolean)item.getProperty("skip", (Object)false);
                return !skip;
            }
        };
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(a, d), "a,g,h,d");
            }
        }, (PathExpander)((StandardExpander)PathExpanders.allTypesAndDirections()).addNodeFilter((Predicate)filter), 10);
    }

    @Test
    public void testFinderShouldNotFindAnythingBeyondLimit() {
        graph.makeEdgeChain("a,b,c,d,e");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("a"), graph.getNode("b")), new String[0]);
            }
        }, PathExpanders.allTypesAndDirections(), 0);
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("a"), graph.getNode("c")), new String[0]);
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("a"), graph.getNode("d")), new String[0]);
            }
        }, PathExpanders.allTypesAndDirections(), 1);
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("a"), graph.getNode("d")), new String[0]);
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("a"), graph.getNode("e")), new String[0]);
            }
        }, PathExpanders.allTypesAndDirections(), 2);
    }

    @Test
    public void makeSureDescentStopsWhenPathIsFound() throws Exception {
        graph.makeEdgeChain("a,b,c,d,e");
        graph.makeEdgeChain("a,b,c,d,e");
        graph.makeEdgeChain("a,f,g,h,i");
        Node a = graph.getNode("a");
        Node b = graph.getNode("b");
        Node c = graph.getNode("c");
        final HashSet<Node> allowedNodes = new HashSet<Node>(Arrays.asList(a, b, c));
        ShortestPath finder = new ShortestPath(100, (RelationshipExpander)Traversal.expanderForAllTypes((Direction)Direction.OUTGOING)){

            protected Collection<Node> filterNextLevelNodes(Collection<Node> nextNodes) {
                for (Node node : nextNodes) {
                    if (allowedNodes.contains(node)) continue;
                    Assert.fail((String)("Node " + node.getProperty("name") + " shouldn't be expanded"));
                }
                return nextNodes;
            }
        };
        finder.findAllPaths(a, c);
    }

    @Test
    public void makeSureRelationshipNotConnectedIssueNotThere() throws Exception {
        graph.makeEdgeChain("i,g,f,e,d,c,b,a");
        graph.makeEdgeChain("i,h,f");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                Node start = graph.getNode("a");
                Node end = graph.getNode("i");
                TestShortestPath.this.assertPaths(finder.findAllPaths(start, end), "a,b,c,d,e,f,g,i", "a,b,c,d,e,f,h,i");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.INCOMING), 10);
    }

    @Test
    public void makeSureShortestPathCanBeFetchedEvenIfANodeHasLoops() throws Exception {
        graph.makeEdgeChain("m,s,n,p");
        graph.makeEdgeChain("m,o,n");
        graph.makeEdge("o", "o");
        graph.makeEdge("n", "n");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPaths(finder.findAllPaths(graph.getNode("m"), graph.getNode("p")), "m,s,n,p", "m,o,n,p");
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 3);
    }

    @Test
    public void makeSureAMaxResultCountIsObeyed() {
        graph.makeEdgeChain("a,b,c,d,e");
        graph.makeEdgeChain("a,f,g,h,e");
        graph.makeEdgeChain("f,i,j,e");
        graph.makeEdgeChain("i,k,e");
        final Node a = graph.getNode("a");
        final Node e = graph.getNode("e");
        PathExpander expander = PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING);
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                Assert.assertEquals((long)4L, (long)IteratorUtil.count((Iterable)finder.findAllPaths(a, e)));
            }
        }, expander, 10, 10);
        int i = 4;
        while (i >= 1) {
            final int count = i--;
            this.testShortestPathFinder(new PathFinderTester(){

                @Override
                public void test(PathFinder<Path> finder) {
                    Assert.assertEquals((long)count, (long)IteratorUtil.count((Iterable)finder.findAllPaths(a, e)));
                }
            }, expander, 10, count);
        }
    }

    @Test
    public void unfortunateRelationshipOrderingInTriangle() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("a,c");
        final Node a = graph.getNode("a");
        final Node c = graph.getNode("c");
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPathDef(finder.findSinglePath(a, c), new String[]{"a", "c"});
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), 2);
        this.testShortestPathFinder(new PathFinderTester(){

            @Override
            public void test(PathFinder<Path> finder) {
                TestShortestPath.this.assertPathDef(finder.findSinglePath(c, a), new String[]{"c", "a"});
            }
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.INCOMING), 2);
    }

    @Ignore(value="Exposes a problem where the expected path isn't returned")
    @Test
    public void pathsWithLengthProblem() throws Exception {
        graph.makeEdgeChain("f,c");
        graph.makeEdgeChain("c,e");
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("a,d,b");
        Node a = graph.getNode("a");
        Node c = graph.getNode("c");
        this.assertPaths(new ShortestPath(3, PathExpanders.forType((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), 10, true).findAllPaths(a, c), "a,d,b,c");
    }

    @Test
    public void shouldFindShortestPathWhenOneSideFindsLongerPathFirst() throws Exception {
        graph.makeEdge("start", "c");
        graph.makeEdge("start", "a");
        graph.makeEdge("b", "end");
        graph.makeEdge("d", "end");
        graph.makeEdge("c", "e");
        graph.makeEdge("f", "end");
        graph.makeEdge("c", "b");
        graph.makeEdge("e", "end");
        graph.makeEdge("a", "end");
        Node start = graph.getNode("start");
        Node end = graph.getNode("end");
        Assert.assertThat((Object)new ShortestPath(2, PathExpanders.allTypesAndDirections(), 42).findSinglePath(start, end).length(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)new ShortestPath(3, PathExpanders.allTypesAndDirections(), 42).findSinglePath(start, end).length(), (Matcher)CoreMatchers.is((Object)2));
    }

    private void testShortestPathFinder(PathFinderTester tester, PathExpander expander, int maxDepth) {
        this.testShortestPathFinder(tester, expander, maxDepth, null);
    }

    private void testShortestPathFinder(PathFinderTester tester, PathExpander expander, int maxDepth, Integer maxResultCount) {
        LengthCheckingExpanderWrapper lengthChecker = new LengthCheckingExpanderWrapper(expander);
        ArrayList<Object> finders = new ArrayList<Object>();
        finders.add(maxResultCount != null ? GraphAlgoFactory.shortestPath((PathExpander)lengthChecker, (int)maxDepth, (int)maxResultCount) : GraphAlgoFactory.shortestPath((PathExpander)lengthChecker, (int)maxDepth));
        finders.add(maxResultCount != null ? new TraversalShortestPath((PathExpander)lengthChecker, maxDepth, maxResultCount.intValue()) : new TraversalShortestPath((PathExpander)lengthChecker, maxDepth));
        for (PathFinder pathFinder : finders) {
            tester.test((PathFinder<Path>)pathFinder);
        }
    }

    private static class LengthCheckingExpanderWrapper
    implements PathExpander<Object> {
        private PathExpander expander;

        LengthCheckingExpanderWrapper(PathExpander expander) {
            this.expander = expander;
        }

        public Iterable<Relationship> expand(Path path, BranchState<Object> state) {
            if (path.startNode().equals(path.endNode())) {
                Assert.assertTrue((String)"Path length must be zero", (path.length() == 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)"Path length must be positive", (path.length() > 0 ? 1 : 0) != 0);
            }
            return this.expander.expand(path, state);
        }

        public PathExpander<Object> reverse() {
            return new LengthCheckingExpanderWrapper(this.expander.reverse());
        }
    }

    private static interface PathFinderTester {
        public void test(PathFinder<Path> var1);
    }
}

