/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.NetworkRadius;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NetworkRadiusTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    @Test
    public void testBox() {
        graph.makeEdgeChain("a,b,c,d,a");
        NetworkRadius radius = new NetworkRadius(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
        Assert.assertTrue(((Double)radius.getCentrality(null) == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("d,b,e");
        NetworkRadius radius = new NetworkRadius(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
        Assert.assertTrue(((Double)radius.getCentrality(null) == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testChain() {
        graph.makeEdgeChain("a,b,c,d,e");
        NetworkRadius radius = new NetworkRadius(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
        Assert.assertTrue(((Double)radius.getCentrality(null) == 2.0 ? 1 : 0) != 0);
    }
}

