/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.path.ExactDepthPathFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.Traversal;

public class TestExactDepthPathFinder
extends Neo4jAlgoTestCase {
    public void createGraph() {
        graph.makeEdgeChain("SOURCE,SUPER,c,d");
        graph.makeEdgeChain("SUPER,e,f");
        graph.makeEdgeChain("SUPER,5,6");
        graph.makeEdgeChain("SUPER,7,8");
        graph.makeEdgeChain("SUPER,r,SPIDER");
        graph.makeEdgeChain("SUPER,g,h,i,j,SPIDER");
        graph.makeEdgeChain("SUPER,k,l,m,SPIDER");
        graph.makeEdgeChain("SUPER,s,t,u,SPIDER");
        graph.makeEdgeChain("SUPER,v,w,x,y,SPIDER");
        graph.makeEdgeChain("SPIDER,n,o");
        graph.makeEdgeChain("SPIDER,p,q");
        graph.makeEdgeChain("SPIDER,1,2");
        graph.makeEdgeChain("SPIDER,3,4");
        graph.makeEdgeChain("SPIDER,TARGET");
        graph.makeEdgeChain("SOURCE,a,b,TARGET");
        graph.makeEdgeChain("SOURCE,z,9,0,TARGET");
    }

    private PathFinder<Path> newFinder() {
        return new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 4, 4, true);
    }

    @Test
    public void testSingle() {
        this.createGraph();
        PathFinder<Path> finder = this.newFinder();
        Path path = finder.findSinglePath(graph.getNode("SOURCE"), graph.getNode("TARGET"));
        Assert.assertNotNull((Object)path);
        this.assertPathDef(path, "SOURCE", "z", "9", "0", "TARGET");
    }

    @Test
    public void testAll() {
        this.createGraph();
        this.assertPaths(this.newFinder().findAllPaths(graph.getNode("SOURCE"), graph.getNode("TARGET")), "SOURCE,z,9,0,TARGET", "SOURCE,SUPER,r,SPIDER,TARGET");
    }

    @Test
    public void shouldHandleDirectionalGraph() {
        graph.makeEdgeChain("a,b,c,g");
        graph.makeEdgeChain("a,d,e,f,g");
        graph.makeEdgeChain("a,h,i,j,k,g");
        Node a = graph.getNode("a");
        Node g = graph.getNode("g");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.forDirection((Direction)Direction.OUTGOING), 3, Integer.MAX_VALUE, false).findAllPaths(a, g), "a,b,c,g");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.forDirection((Direction)Direction.OUTGOING), 4, Integer.MAX_VALUE, false).findAllPaths(a, g), "a,d,e,f,g");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.forDirection((Direction)Direction.OUTGOING), 5, Integer.MAX_VALUE, false).findAllPaths(a, g), "a,h,i,j,k,g");
    }

    @Test
    public void shouldHandleNondirectedGraph() {
        graph.makeEdgeChain("a,b,c,g");
        graph.makeEdgeChain("a,d,e,f,g");
        graph.makeEdgeChain("a,h,i,j,k,g");
        Node a = graph.getNode("a");
        Node g = graph.getNode("g");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 3, Integer.MAX_VALUE, false).findAllPaths(a, g), "a,b,c,g");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 4, Integer.MAX_VALUE, false).findAllPaths(a, g), "a,d,e,f,g");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 5, Integer.MAX_VALUE, false).findAllPaths(a, g), "a,h,i,j,k,g");
    }

    @Test
    public void shouldHandleSimpleChainEvenDepth() {
        graph.makeEdgeChain("a,b,c");
        Node a = graph.getNode("a");
        Node c = graph.getNode("c");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 2, Integer.MAX_VALUE, false).findAllPaths(a, c), "a,b,c");
        this.assertPaths(new ExactDepthPathFinder((RelationshipExpander)Traversal.expanderForAllTypes(), 2, Integer.MAX_VALUE, false).findAllPaths(a, c), "a,b,c");
    }

    @Test
    public void shouldHandleSimpleChainOddDepth() {
        graph.makeEdgeChain("a,b,c,d");
        Node a = graph.getNode("a");
        Node d = graph.getNode("d");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 3, Integer.MAX_VALUE, false).findAllPaths(a, d), "a,b,c,d");
        this.assertPaths(new ExactDepthPathFinder((RelationshipExpander)Traversal.expanderForAllTypes(), 3, Integer.MAX_VALUE, false).findAllPaths(a, d), "a,b,c,d");
    }

    @Test
    public void shouldHandleNeighbouringNodes() {
        graph.makeEdgeChain("a,b");
        Node a = graph.getNode("a");
        Node b = graph.getNode("b");
        ExactDepthPathFinder pathFinder = new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 1, Integer.MAX_VALUE, false);
        Iterable allPaths = pathFinder.findAllPaths(a, b);
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 1, Integer.MAX_VALUE, false).findAllPaths(a, b), "a,b");
        this.assertPaths(new ExactDepthPathFinder((RelationshipExpander)Traversal.expanderForAllTypes(), 1, Integer.MAX_VALUE, false).findAllPaths(a, b), "a,b");
    }

    @Test
    public void shouldHandleNeighbouringNodesWhenNotAlone() {
        graph.makeEdge("a", "b");
        graph.makeEdge("a", "c");
        Node a = graph.getNode("a");
        Node b = graph.getNode("b");
        ExactDepthPathFinder pathFinder = new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 1, Integer.MAX_VALUE, false);
        Iterable allPaths = pathFinder.findAllPaths(a, b);
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 1, Integer.MAX_VALUE, false).findAllPaths(a, b), "a,b");
        this.assertPaths(new ExactDepthPathFinder((RelationshipExpander)Traversal.expanderForAllTypes(), 1, Integer.MAX_VALUE, false).findAllPaths(a, b), "a,b");
    }

    @Test
    public void shouldHandleNeighbouringNodesMultiplePaths() {
        graph.makeEdgeChain("a,b");
        graph.makeEdgeChain("a,b");
        graph.makeEdgeChain("a,c");
        Node a = graph.getNode("a");
        Node b = graph.getNode("b");
        ExactDepthPathFinder pathFinder = new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 1, Integer.MAX_VALUE, false);
        Iterable allPaths = pathFinder.findAllPaths(a, b);
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.allTypesAndDirections(), 1, Integer.MAX_VALUE, false).findAllPaths(a, b), "a,b", "a,b");
        this.assertPaths(new ExactDepthPathFinder((RelationshipExpander)Traversal.expanderForAllTypes(), 1, Integer.MAX_VALUE, false).findAllPaths(a, b), "a,b", "a,b");
    }

    @Test
    public void testExactDepthFinder() {
        graph.makeEdgeChain("a,c,g,k");
        graph.makeEdgeChain("a,b,d,j,k");
        graph.makeEdgeChain("b,e,f,h,i,j");
        graph.makeEdgeChain("d,h");
        Expander expander = Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING);
        Node a = graph.getNode("a");
        Node k = graph.getNode("k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)3).findAllPaths(a, k), "a,c,g,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)4).findAllPaths(a, k), "a,b,d,j,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)5).findAllPaths(a, k), new String[0]);
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)6).findAllPaths(a, k), "a,b,d,h,i,j,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)7).findAllPaths(a, k), "a,b,e,f,h,i,j,k");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)expander, (int)8).findAllPaths(a, k), new String[0]);
    }

    @Test
    public void testExactDepthPathsReturnsNoLoops() {
        graph.makeEdgeChain("a,b,c,d,b,c,e");
        Node a = graph.getNode("a");
        Node e = graph.getNode("e");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), (int)3).findAllPaths(a, e), "a,b,c,e", "a,b,c,e");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), (int)4).findAllPaths(a, e), "a,b,d,c,e");
        this.assertPaths(GraphAlgoFactory.pathsWithLength((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1), (int)6).findAllPaths(a, e), new String[0]);
    }

    @Test
    public void testExactDepthPathsLoopsAllowed() {
        graph.makeEdgeChain("a,b,c,d,b,c,e");
        Node a = graph.getNode("a");
        Node e = graph.getNode("e");
        this.assertPaths(new ExactDepthPathFinder(PathExpanders.forDirection((Direction)Direction.OUTGOING), 6, Integer.MAX_VALUE, true).findAllPaths(a, e), "a,b,c,d,b,c,e");
    }
}

