/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.shortestpath.Dijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class DijkstraDirectionTest
extends Neo4jAlgoTestCase {
    @Test
    public void testDijkstraDirection1() {
        graph.makeEdge("s", "e");
        Dijkstra dijkstra = new Dijkstra((Object)0.0, graph.getNode("s"), graph.getNode("e"), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Assert.assertEquals((Object)Direction.OUTGOING, (Object)direction);
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.OUTGOING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        dijkstra.getCost();
        dijkstra = new Dijkstra((Object)0.0, graph.getNode("s"), graph.getNode("e"), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Assert.assertEquals((Object)Direction.INCOMING, (Object)direction);
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.INCOMING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        dijkstra.getCost();
    }

    @Test
    public void testDijkstraDirection2() {
        graph.makeEdge("a", "b");
        graph.makeEdge("b", "c");
        graph.makeEdge("c", "d");
        graph.makeEdge("d", "a");
        graph.makeEdge("s", "a");
        graph.makeEdge("b", "s");
        graph.makeEdge("e", "c");
        graph.makeEdge("d", "e");
        Dijkstra dijkstra = new Dijkstra((Object)0.0, graph.getNode("s"), graph.getNode("e"), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Assert.assertEquals((Object)Direction.OUTGOING, (Object)direction);
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.OUTGOING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        dijkstra.getCost();
        dijkstra = new Dijkstra((Object)0.0, graph.getNode("s"), graph.getNode("e"), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                Assert.assertEquals((Object)Direction.INCOMING, (Object)direction);
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.INCOMING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        dijkstra.getCost();
    }

    @Test
    public void testDijkstraDirection3() {
        Relationship r1 = graph.makeEdge("start", "b");
        Relationship r2 = graph.makeEdge("c", "b");
        Relationship r3 = graph.makeEdge("c", "d");
        Relationship r4 = graph.makeEdge("e", "d");
        Relationship r5 = graph.makeEdge("e", "f");
        Relationship r6 = graph.makeEdge("g", "f");
        Relationship r7 = graph.makeEdge("g", "end");
        HashMap<Relationship, Direction> dirs = new HashMap<Relationship, Direction>();
        Dijkstra dijkstra = new Dijkstra((Object)0.0, graph.getNode("start"), graph.getNode("end"), (CostEvaluator)new directionSavingCostEvaluator(dirs), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        dijkstra.getCost();
        Assert.assertEquals((Object)Direction.OUTGOING, (Object)dirs.get(r1));
        Assert.assertEquals((Object)Direction.INCOMING, (Object)dirs.get(r2));
        Assert.assertEquals((Object)Direction.OUTGOING, (Object)dirs.get(r3));
        Assert.assertEquals((Object)Direction.INCOMING, (Object)dirs.get(r4));
        Assert.assertEquals((Object)Direction.OUTGOING, (Object)dirs.get(r5));
        Assert.assertEquals((Object)Direction.INCOMING, (Object)dirs.get(r6));
        Assert.assertEquals((Object)Direction.OUTGOING, (Object)dirs.get(r7));
    }

    class directionSavingCostEvaluator
    implements CostEvaluator<Double> {
        HashMap<Relationship, Direction> dirs;

        public directionSavingCostEvaluator(HashMap<Relationship, Direction> dirs) {
            this.dirs = dirs;
        }

        public Double getCost(Relationship relationship, Direction direction) {
            if (!this.dirs.containsKey(relationship)) {
                this.dirs.put(relationship, direction);
            }
            return 1.0;
        }
    }
}

