/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CsvFileReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class SimpleGraphBuilder {
    public static final String KEY_ID = "name";
    GraphDatabaseService graphDb;
    HashMap<String, Node> nodes;
    HashMap<Node, String> nodeNames;
    Set<Relationship> edges;
    RelationshipType currentRelType = null;

    public SimpleGraphBuilder(GraphDatabaseService graphDb, RelationshipType relationshipType) {
        this.graphDb = graphDb;
        this.nodes = new HashMap();
        this.nodeNames = new HashMap();
        this.edges = new HashSet<Relationship>();
        this.setCurrentRelType(relationshipType);
    }

    public void clear() {
        for (Node node : this.nodes.values()) {
            for (Relationship relationship : node.getRelationships()) {
                relationship.delete();
            }
            node.delete();
        }
        this.nodes.clear();
        this.nodeNames.clear();
        this.edges.clear();
    }

    public Set<Relationship> getAllEdges() {
        return this.edges;
    }

    public Set<Node> getAllNodes() {
        return this.nodeNames.keySet();
    }

    public void setCurrentRelType(RelationshipType currentRelType) {
        this.currentRelType = currentRelType;
    }

    public Node makeNode(String id) {
        return this.makeNode(id, Collections.emptyMap());
    }

    public Node makeNode(String id, Object ... keyValuePairs) {
        return this.makeNode(id, this.toMap(keyValuePairs));
    }

    private Map<String, Object> toMap(Object[] keyValuePairs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; ++i) {
            map.put(keyValuePairs[i++].toString(), keyValuePairs[i]);
        }
        return map;
    }

    public Node makeNode(String id, Map<String, Object> properties) {
        Node node = this.graphDb.createNode();
        this.nodes.put(id, node);
        this.nodeNames.put(node, id);
        node.setProperty(KEY_ID, (Object)id);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (property.getKey().equals(KEY_ID)) {
                throw new RuntimeException("Can't use '" + property.getKey() + "'");
            }
            node.setProperty(property.getKey(), property.getValue());
        }
        return node;
    }

    public Node getNode(String id) {
        return this.getNode(id, false);
    }

    public Node getNode(String id, boolean force) {
        Node node = this.nodes.get(id);
        if (node == null && force) {
            node = this.makeNode(id);
        }
        return node;
    }

    public String getNodeId(Node node) {
        return this.nodeNames.get(node);
    }

    public Relationship makeEdge(String node1, String node2) {
        return this.makeEdge(node1, node2, Collections.emptyMap());
    }

    public Relationship makeEdge(String node1, String node2, Map<String, Object> edgeProperties) {
        Node n1 = this.getNode(node1, true);
        Node n2 = this.getNode(node2, true);
        Relationship relationship = n1.createRelationshipTo(n2, this.currentRelType);
        for (Map.Entry<String, Object> property : edgeProperties.entrySet()) {
            relationship.setProperty(property.getKey(), property.getValue());
        }
        this.edges.add(relationship);
        return relationship;
    }

    public Relationship makeEdge(String node1, String node2, Object ... keyValuePairs) {
        return this.makeEdge(node1, node2, this.toMap(keyValuePairs));
    }

    public void makeEdgeChain(String commaSeparatedNodeNames) {
        String[] nodeNames = commaSeparatedNodeNames.split(",");
        for (int i = 0; i < nodeNames.length - 1; ++i) {
            this.makeEdge(nodeNames[i], nodeNames[i + 1]);
        }
    }

    public void makeEdgeChain(String commaSeparatedNodeNames, String propertyName, Object propertyValue) {
        String[] nodeNames = commaSeparatedNodeNames.split(",");
        for (int i = 0; i < nodeNames.length - 1; ++i) {
            this.makeEdge(nodeNames[i], nodeNames[i + 1], propertyName, propertyValue);
        }
    }

    public void makeEdges(String commaSeparatedNodeNames) {
        String[] nodeNames = commaSeparatedNodeNames.split(",");
        for (int i = 0; i < nodeNames.length / 2; ++i) {
            this.makeEdge(nodeNames[i * 2], nodeNames[i * 2 + 1]);
        }
    }

    public void importEdges(File file) {
        try {
            CsvFileReader reader = new CsvFileReader(file);
            while (reader.hasNext()) {
                String[] line = (String[])reader.next();
                this.makeEdge(line[0], line[1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeEdges(String commaSeparatedNodeNames, String propertyName, Object propertyValue) {
        String[] nodeNames = commaSeparatedNodeNames.split(",");
        for (int i = 0; i < nodeNames.length / 2; ++i) {
            this.makeEdge(nodeNames[i * 2], nodeNames[i * 2 + 1], propertyName, propertyValue);
        }
    }

    public Relationship getRelationship(String node1Id, String node2Id) {
        Node node1 = this.getNode(node1Id);
        Node node2 = this.getNode(node2Id);
        if (node1 == null || node2 == null) {
            return null;
        }
        Iterable relationships = node1.getRelationships();
        for (Relationship relationship : relationships) {
            if (!relationship.getOtherNode(node1).equals(node2)) continue;
            return relationship;
        }
        return null;
    }

    public Path makePathWithRelProperty(String relPropertyName, String dashSeparatedNodeNamesAndRelationshipProperty) {
        String[] nodeNamesAndRelationshipProperties = dashSeparatedNodeNamesAndRelationshipProperty.split("-");
        Node startNode = this.getNode(nodeNamesAndRelationshipProperties[0], true);
        PathImpl.Builder builder = new PathImpl.Builder(startNode);
        if (nodeNamesAndRelationshipProperties.length < 1) {
            return builder.build();
        }
        for (int i = 0; i < nodeNamesAndRelationshipProperties.length - 2; i += 2) {
            String from = nodeNamesAndRelationshipProperties[i];
            String to = nodeNamesAndRelationshipProperties[i + 2];
            String prop = nodeNamesAndRelationshipProperties[i + 1];
            Relationship relationship = this.makeEdge(from, to, relPropertyName, prop);
            builder = builder.push(relationship);
        }
        return builder.build();
    }
}

