/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import common.Neo4jAlgoTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.util.TopFetchingWeightedPathIterator;
import org.neo4j.graphdb.Path;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class TestTopFetchingWeightedPathIterator
extends Neo4jAlgoTestCase {
    private final double epsilon = NoneStrictMath.EPSILON;
    private final String length = "length";
    private CostEvaluator evaluator = CommonEvaluators.doubleCostEvaluator((String)"length");
    private TopFetchingWeightedPathIterator topFetcher;

    @Test
    public void shouldHandleEmptySource() {
        this.topFetcher = new TopFetchingWeightedPathIterator(Collections.emptyIterator(), this.evaluator);
        Assert.assertFalse((String)"Expected iterator to be empty", (boolean)this.topFetcher.hasNext());
        Assert.assertNull((String)"Expected null after report has no next", (Object)this.topFetcher.fetchNextOrNull());
    }

    @Test
    public void shouldHandleSinglePath() {
        Path a = graph.makePathWithRelProperty("length", "a1-1-a2");
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(a);
        this.topFetcher = new TopFetchingWeightedPathIterator(list.iterator(), this.evaluator, this.epsilon);
        Assert.assertTrue((String)"Expected at least one element", (boolean)this.topFetcher.hasNext());
        this.assertPathDef(a, (Path)this.topFetcher.next());
        Assert.assertFalse((String)"Expected no more elements", (boolean)this.topFetcher.hasNext());
        Assert.assertNull((String)"Expected null after report has no next", (Object)this.topFetcher.fetchNextOrNull());
    }

    @Test
    public void shouldHandleMultipleShortest() {
        Path a = graph.makePathWithRelProperty("length", "a1-1-a2");
        Path b = graph.makePathWithRelProperty("length", "b1-0-b2-1-b3-0-b4");
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(a);
        list.add(b);
        this.topFetcher = new TopFetchingWeightedPathIterator(list.iterator(), this.evaluator, this.epsilon);
        ArrayList<Object> result = new ArrayList<Object>();
        while (this.topFetcher.hasNext()) {
            result.add(this.topFetcher.next());
        }
        this.assertPathsWithPaths(result, a, b);
    }

    @Test
    public void shouldHandleUnsortedSource() {
        Path a = graph.makePathWithRelProperty("length", "a1-1-a2-2-a3");
        Path b = graph.makePathWithRelProperty("length", "b1-3-b2-3-b3");
        Path c = graph.makePathWithRelProperty("length", "c1-0-c2-1-c3");
        Path d = graph.makePathWithRelProperty("length", "d1-3-d2-0-d3");
        Path e = graph.makePathWithRelProperty("length", "e1-0-e2-0-e3-0-e4-1-e5");
        List<Path> list = Arrays.asList(a, b, c, d, e);
        this.topFetcher = new TopFetchingWeightedPathIterator(list.iterator(), this.evaluator, this.epsilon);
        ArrayList<Object> result = new ArrayList<Object>();
        while (this.topFetcher.hasNext()) {
            result.add(this.topFetcher.next());
        }
        this.assertPathsWithPaths(result, c, e);
    }
}

