/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="Not a test, merely a performance measurement. Convert into a proper performance benchmark at some point")
public class PathExplosionIT {
    private static final boolean FIND_MULTIPLE_PATHS = false;
    private static final int MIN_PATH_LENGTH = 2;
    private static final int MAX_PATH_LENGTH = 10;
    private static final int MIN_PATH_WIDTH = 2;
    private static final int MAX_PATH_WIDTH = 6;
    private static final int WARMUP_RUNS = 2;
    private static final long TOLERATED_DURATION = 10000L;
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    private final PathExpander<?> expander = PathExpanders.forDirection((Direction)Direction.BOTH);
    private final CostEvaluator<Double> constantEvaluator = new CostEvaluator<Double>(){

        public Double getCost(Relationship relationship, Direction direction) {
            return 1.0;
        }
    };
    private final EstimateEvaluator<Double> estimateEvaluator = new EstimateEvaluator<Double>(){

        public Double getCost(Node node, Node goal) {
            return 1.0;
        }
    };

    @Test
    public void aStarShouldFinishWithinToleratedDuration() throws IOException {
        this.assertPathFinderCompletesWithinToleratedDuration(10000L, (PathFinder<? extends Path>)GraphAlgoFactory.aStar(this.expander, this.constantEvaluator, this.estimateEvaluator));
    }

    @Test
    public void dijkstraShouldFinishWithinToleratedDuration() throws IOException {
        this.assertPathFinderCompletesWithinToleratedDuration(10000L, (PathFinder<? extends Path>)GraphAlgoFactory.dijkstra(this.expander, this.constantEvaluator));
    }

    @Test
    public void shortestPathShouldFinishWithinToleratedDuration() throws IOException {
        this.assertPathFinderCompletesWithinToleratedDuration(10000L, (PathFinder<? extends Path>)GraphAlgoFactory.shortestPath(this.expander, (int)Integer.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertPathFinderCompletesWithinToleratedDuration(long toleratedRuntime, PathFinder<? extends Path> pathFinder) throws IOException {
        for (int pathWidth = 2; pathWidth <= 6; ++pathWidth) {
            for (int pathLength = 2; pathLength <= 10; ++pathLength) {
                FileUtils.deleteRecursively((File)this.testDir.directory());
                GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
                try {
                    long[] startEndNodeIds = this.createPathGraphAndReturnStartAndEnd(pathLength, pathWidth, db);
                    long runTime = this.findPath(startEndNodeIds[0], startEndNodeIds[1], db, pathFinder, 2);
                    System.out.println(String.format("Runtime[pathWidth:%s, pathLength:%s] = %s", pathWidth, pathLength, runTime));
                    Assert.assertTrue((runTime < toleratedRuntime ? 1 : 0) != 0);
                    continue;
                }
                finally {
                    db.shutdown();
                }
            }
        }
    }

    long findPath(long startId, long endId, GraphDatabaseService db, PathFinder<? extends Path> pathFinder, int warmUpRuns) {
        long runTime = -1L;
        try (Transaction tx = db.beginTx();){
            Node startNode = db.getNodeById(startId);
            Node endNode = db.getNodeById(endId);
            for (int run = 0; run < warmUpRuns; ++run) {
                this.runPathOnce(startNode, endNode, db, pathFinder);
            }
            runTime = this.runPathOnce(startNode, endNode, db, pathFinder);
            tx.success();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return runTime;
    }

    long runPathOnce(Node startNode, Node endNode, GraphDatabaseService db, PathFinder<? extends Path> pathFinder) {
        long startTime = System.currentTimeMillis();
        Path path = pathFinder.findSinglePath(startNode, endNode);
        Iterables.count((Iterable)path);
        return System.currentTimeMillis() - startTime;
    }

    long[] createPathGraphAndReturnStartAndEnd(int length, int width, GraphDatabaseService db) {
        long startId = -1L;
        long endId = -1L;
        try (Transaction tx = db.beginTx();){
            Node startNode = null;
            Node endNode = db.createNode();
            startId = endNode.getId();
            for (int l = 0; l < length; ++l) {
                startNode = endNode;
                endNode = db.createNode();
                for (int w = 0; w < width; ++w) {
                    startNode.createRelationshipTo(endNode, (RelationshipType)RelTypes.SomeRelType);
                }
            }
            endId = endNode.getId();
            tx.success();
        }
        return new long[]{startId, endId};
    }

    private static enum RelTypes implements RelationshipType
    {
        SomeRelType;

    }
}

