/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import common.Neo4jAlgoTestCase;
import java.util.HashMap;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class UtilTest
extends Neo4jAlgoTestCase {
    @Test
    public void testPathCounter() {
        Node a = graphDb.createNode();
        Node b = graphDb.createNode();
        Node c = graphDb.createNode();
        Node d = graphDb.createNode();
        Node e = graphDb.createNode();
        Node f = graphDb.createNode();
        LinkedList ap = new LinkedList();
        LinkedList<Relationship> bp = new LinkedList<Relationship>();
        LinkedList<Relationship> cp = new LinkedList<Relationship>();
        LinkedList<Relationship> dp = new LinkedList<Relationship>();
        LinkedList<Relationship> ep = new LinkedList<Relationship>();
        LinkedList<Relationship> fp = new LinkedList<Relationship>();
        HashMap predecessors = new HashMap();
        predecessors.put(a, ap);
        predecessors.put(b, bp);
        predecessors.put(c, cp);
        predecessors.put(d, dp);
        predecessors.put(e, ep);
        predecessors.put(f, fp);
        fp.add(f.createRelationshipTo(c, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        fp.add(f.createRelationshipTo(e, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        ep.add(e.createRelationshipTo(b, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        ep.add(e.createRelationshipTo(d, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        dp.add(d.createRelationshipTo(a, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        cp.add(c.createRelationshipTo(b, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        bp.add(b.createRelationshipTo(a, (RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1));
        Util.PathCounter counter = new Util.PathCounter(predecessors);
        Assert.assertTrue((counter.getNumberOfPathsToNode(a) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(b) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(c) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(d) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(e) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(f) == 3 ? 1 : 0) != 0);
        counter = new Util.PathCounter(Util.reversedPredecessors(predecessors));
        Assert.assertTrue((counter.getNumberOfPathsToNode(a) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(b) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(c) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(d) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(e) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((counter.getNumberOfPathsToNode(f) == 1 ? 1 : 0) != 0);
    }
}

