/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;

public class PathImplTest {
    private NodeProxy.NodeActions nodeActions = (NodeProxy.NodeActions)Mockito.mock(NodeProxy.NodeActions.class);
    private RelationshipProxy.RelationshipActions relationshipActions = (RelationshipProxy.RelationshipActions)Mockito.mock(RelationshipProxy.RelationshipActions.class);

    @Test
    public void singularNodeWorksForwardsAndBackwards() {
        Node node = this.createNode(1337L);
        Path path = PathImpl.singular((Node)node);
        Assert.assertEquals((Object)node, (Object)path.startNode());
        Assert.assertEquals((Object)node, (Object)path.endNode());
        Iterator forwardIterator = path.nodes().iterator();
        Assert.assertTrue((boolean)forwardIterator.hasNext());
        Assert.assertEquals((Object)node, forwardIterator.next());
        Assert.assertFalse((boolean)forwardIterator.hasNext());
        Iterator reverseIterator = path.reverseNodes().iterator();
        Assert.assertTrue((boolean)reverseIterator.hasNext());
        Assert.assertEquals((Object)node, reverseIterator.next());
        Assert.assertFalse((boolean)reverseIterator.hasNext());
    }

    @Test
    public void pathsWithTheSameContentsShouldBeEqual() throws Exception {
        Node node = this.createNode(1337L);
        Relationship relationship = this.createRelationship(1337L, 7331L);
        Path firstPath = new PathImpl.Builder(node).push(relationship).build();
        Path secondPath = new PathImpl.Builder(node).push(relationship).build();
        Assert.assertEquals((Object)firstPath, (Object)secondPath);
        Assert.assertEquals((Object)secondPath, (Object)firstPath);
    }

    @Test
    public void pathsWithDifferentLengthAreNotEqual() throws Exception {
        Node node = this.createNode(1337L);
        Relationship relationship = this.createRelationship(1337L, 7331L);
        Path firstPath = new PathImpl.Builder(node).push(relationship).build();
        Path secondPath = new PathImpl.Builder(node).push(relationship).push(this.createRelationship(1337L, 7331L)).build();
        Assert.assertThat((Object)firstPath, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)secondPath)));
        Assert.assertThat((Object)secondPath, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)firstPath)));
    }

    @Test
    public void testPathReverseNodes() {
        Mockito.when((Object)this.relationshipActions.newNodeProxy(Mockito.anyLong())).thenAnswer((Answer)new NodeProxyAnswer());
        Path path = new PathImpl.Builder((Node)this.createNodeProxy(1)).push((Relationship)this.createRelationshipProxy(1, 2)).push((Relationship)this.createRelationshipProxy(2, 3)).build(new PathImpl.Builder((Node)this.createNodeProxy(3)));
        Iterable nodes = path.reverseNodes();
        List nodeList = Iterables.toList((Iterable)nodes);
        Assert.assertEquals((long)3L, (long)nodeList.size());
        Assert.assertEquals((long)3L, (long)((Node)nodeList.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Node)nodeList.get(1)).getId());
        Assert.assertEquals((long)1L, (long)((Node)nodeList.get(2)).getId());
    }

    @Test
    public void testPathNodes() {
        Mockito.when((Object)this.relationshipActions.newNodeProxy(Mockito.anyLong())).thenAnswer((Answer)new NodeProxyAnswer());
        Path path = new PathImpl.Builder((Node)this.createNodeProxy(1)).push((Relationship)this.createRelationshipProxy(1, 2)).push((Relationship)this.createRelationshipProxy(2, 3)).build(new PathImpl.Builder((Node)this.createNodeProxy(3)));
        Iterable nodes = path.nodes();
        List nodeList = Iterables.toList((Iterable)nodes);
        Assert.assertEquals((long)3L, (long)nodeList.size());
        Assert.assertEquals((long)1L, (long)((Node)nodeList.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Node)nodeList.get(1)).getId());
        Assert.assertEquals((long)3L, (long)((Node)nodeList.get(2)).getId());
    }

    private RelationshipProxy createRelationshipProxy(int startNodeId, int endNodeId) {
        return new RelationshipProxy(this.relationshipActions, 1L, (long)startNodeId, 1, (long)endNodeId);
    }

    private NodeProxy createNodeProxy(int nodeId) {
        return new NodeProxy(this.nodeActions, (long)nodeId);
    }

    private Node createNode(long nodeId) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)nodeId);
        return node;
    }

    private Relationship createRelationship(long startNodeId, long endNodeId) {
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        Node startNode = this.createNode(startNodeId);
        Node endNode = this.createNode(endNodeId);
        Mockito.when((Object)relationship.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)relationship.getEndNode()).thenReturn((Object)endNode);
        return relationship;
    }

    private class NodeProxyAnswer
    implements Answer<NodeProxy> {
        private NodeProxyAnswer() {
        }

        public NodeProxy answer(InvocationOnMock invocation) throws Throwable {
            return PathImplTest.this.createNodeProxy(((Number)invocation.getArguments()[0]).intValue());
        }
    }
}

