/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import common.SimpleGraphBuilder;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.shortestpath.Dijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class DijkstraMultiplePathsTest
extends Neo4jAlgoTestCase {
    protected Dijkstra<Double> getDijkstra(SimpleGraphBuilder graph, Double startCost, String startNode, String endNode) {
        return new Dijkstra((Object)startCost, graph.getNode(startNode), graph.getNode(endNode), CommonEvaluators.doubleCostEvaluator((String)"cost"), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    @Test
    public void testTriangle() {
        String[] nodes;
        graph.makeEdge("a", "b", "cost", 0.0);
        graph.makeEdge("b", "c", "cost", 0.0);
        graph.makeEdge("c", "a", "cost", 0.0);
        for (String node1 : nodes = new String[]{"a", "b", "c"}) {
            for (String node2 : nodes) {
                Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, node1, node2);
                int nrPaths = dijkstra.getPathsAsNodes().size();
                if (!node1.equals(node2)) {
                    Assert.assertTrue((String)("Number of paths (" + node1 + "->" + node2 + "): " + nrPaths), (nrPaths == 2 ? 1 : 0) != 0);
                }
                Assert.assertTrue(((Double)dijkstra.getCost() == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void test1() {
        graph.makeEdge("a", "b", "cost", 1.0);
        graph.makeEdge("b", "d", "cost", Float.valueOf(1.0f));
        graph.makeEdge("a", "c", "cost", 1);
        graph.makeEdge("c", "d", "cost", 1L);
        graph.makeEdge("d", "e", "cost", (short)1);
        graph.makeEdge("e", "f", "cost", (byte)1);
        graph.makeEdge("f", "h", "cost", Float.valueOf(1.0f));
        graph.makeEdge("e", "g", "cost", 1.0);
        graph.makeEdge("g", "h", "cost", 1.0);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "h");
        Assert.assertTrue((dijkstra.getPaths().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsRelationships().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)dijkstra.getCost() == 5.0 ? 1 : 0) != 0);
    }

    @Test
    public void test2() {
        graph.makeEdge("a", "b", "cost", 1.0);
        graph.makeEdge("a", "f", "cost", Float.valueOf(1.0f));
        graph.makeEdge("b", "c", "cost", 1L);
        graph.makeEdge("f", "g", "cost", 1);
        graph.makeEdge("c", "d", "cost", (short)1);
        graph.makeEdge("g", "h", "cost", (byte)1);
        graph.makeEdge("d", "e", "cost", Float.valueOf(1.0f));
        graph.makeEdge("h", "e", "cost", 1.0);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "e");
        Assert.assertTrue((dijkstra.getPaths().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((dijkstra.getPathsAsRelationships().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)dijkstra.getCost() == 4.0 ? 1 : 0) != 0);
    }

    @Test
    public void test3() {
        graph.makeEdge("a", "b", "cost", 0.0);
        graph.makeEdge("b", "c", "cost", Float.valueOf(0.0f));
        graph.makeEdge("c", "d", "cost", 0L);
        graph.makeEdge("d", "e", "cost", 0);
        graph.makeEdge("e", "f", "cost", (byte)0);
        graph.makeEdge("f", "g", "cost", Float.valueOf(0.0f));
        graph.makeEdge("g", "h", "cost", (short)0);
        graph.makeEdge("h", "i", "cost", 0.0);
        graph.makeEdge("i", "j", "cost", 0.0);
        graph.makeEdge("j", "k", "cost", 0.0);
        graph.makeEdge("z", "y", "cost", 0.0);
        graph.makeEdge("y", "x", "cost", 0.0);
        graph.makeEdge("x", "w", "cost", 0.0);
        graph.makeEdge("w", "b", "cost", 1.0);
        graph.makeEdge("x", "b", "cost", Float.valueOf(2.0f));
        graph.makeEdge("y", "b", "cost", 1L);
        graph.makeEdge("z", "b", "cost", 1);
        graph.makeEdge("zz", "z", "cost", 0.0);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "zz");
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)dijkstra.getCost() == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void test4() {
        graph.makeEdge("a", "b", "cost", 0.0);
        graph.makeEdge("b", "c", "cost", 0.0);
        graph.makeEdge("c", "d", "cost", 0.0);
        graph.makeEdge("d", "e", "cost", 0.0);
        graph.makeEdge("e", "f", "cost", 0.0);
        graph.makeEdge("f", "g", "cost", 0.0);
        graph.makeEdge("g", "h", "cost", 0.0);
        graph.makeEdge("h", "i", "cost", 0.0);
        graph.makeEdge("i", "j", "cost", 0.0);
        graph.makeEdge("j", "k", "cost", 0.0);
        graph.makeEdge("z", "y", "cost", 0.0);
        graph.makeEdge("y", "x", "cost", 0.0);
        graph.makeEdge("x", "w", "cost", 0.0);
        graph.makeEdge("w", "b", "cost", 1.0);
        graph.makeEdge("x", "b", "cost", Float.valueOf(2.0f));
        graph.makeEdge("y", "b", "cost", 1L);
        graph.makeEdge("z", "b", "cost", 1);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "z");
        Assert.assertTrue((dijkstra.getPathsAsNodes().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)dijkstra.getCost() == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void test5() {
        graph.makeEdge("a", "b", "cost", 0.0);
        graph.makeEdge("z", "y", "cost", Float.valueOf(0.0f));
        graph.makeEdge("y", "b", "cost", 1L);
        graph.makeEdge("z", "b", "cost", 1);
        graph.makeEdge("y", "a", "cost", (byte)1);
        Dijkstra<Double> dijkstra = this.getDijkstra(graph, 0.0, "a", "z");
        List paths = dijkstra.getPathsAsNodes();
        Assert.assertTrue((paths.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)dijkstra.getCost() == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void test6() {
        graph.makeEdgeChain("a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,z", "cost", 1.0);
        graph.makeEdge("a", "b2", "cost", 4.0);
        graph.makeEdge("b2", "c", "cost", -2);
        Dijkstra dijkstra = new Dijkstra((Object)0.0, graph.getNode("a"), graph.getNode("z"), CommonEvaluators.doubleCostEvaluator((String)"cost"), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.OUTGOING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        List paths = dijkstra.getPathsAsNodes();
        Assert.assertTrue((paths.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void test7() {
        Relationship edgeAB = graph.makeEdge("a", "b");
        Relationship edgeBC = graph.makeEdge("b", "c");
        Relationship edgeCD = graph.makeEdge("c", "d");
        Relationship edgeDE = graph.makeEdge("d", "e");
        Relationship edgeAB2 = graph.makeEdge("a", "b2");
        Relationship edgeB2C = graph.makeEdge("b2", "c");
        Relationship edgeCD2 = graph.makeEdge("c", "d2");
        Relationship edgeD2E = graph.makeEdge("d2", "e");
        Dijkstra dijkstra = new Dijkstra((Object)0.0, graph.getNode("a"), graph.getNode("e"), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.OUTGOING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        boolean pathBD = false;
        boolean pathB2D = false;
        boolean pathBD2 = false;
        boolean pathB2D2 = false;
        List paths = dijkstra.getPaths();
        Assert.assertTrue((paths.size() == 4 ? 1 : 0) != 0);
        for (List path : paths) {
            Assert.assertTrue((path.size() == 9 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((PropertyContainer)path.get(0)).equals(graph.getNode("a")));
            Assert.assertTrue((boolean)((PropertyContainer)path.get(4)).equals(graph.getNode("c")));
            Assert.assertTrue((boolean)((PropertyContainer)path.get(8)).equals(graph.getNode("e")));
            if (((PropertyContainer)path.get(2)).equals(graph.getNode("b"))) {
                Assert.assertTrue((boolean)((PropertyContainer)path.get(1)).equals(edgeAB));
                Assert.assertTrue((boolean)((PropertyContainer)path.get(3)).equals(edgeBC));
            } else {
                Assert.assertTrue((boolean)((PropertyContainer)path.get(1)).equals(edgeAB2));
                Assert.assertTrue((boolean)((PropertyContainer)path.get(2)).equals(graph.getNode("b2")));
                Assert.assertTrue((boolean)((PropertyContainer)path.get(3)).equals(edgeB2C));
            }
            if (((PropertyContainer)path.get(6)).equals(graph.getNode("d"))) {
                Assert.assertTrue((boolean)((PropertyContainer)path.get(5)).equals(edgeCD));
                Assert.assertTrue((boolean)((PropertyContainer)path.get(7)).equals(edgeDE));
            } else {
                Assert.assertTrue((boolean)((PropertyContainer)path.get(5)).equals(edgeCD2));
                Assert.assertTrue((boolean)((PropertyContainer)path.get(6)).equals(graph.getNode("d2")));
                Assert.assertTrue((boolean)((PropertyContainer)path.get(7)).equals(edgeD2E));
            }
            if (((PropertyContainer)path.get(2)).equals(graph.getNode("b"))) {
                if (((PropertyContainer)path.get(6)).equals(graph.getNode("d"))) {
                    pathBD = true;
                    continue;
                }
                if (!((PropertyContainer)path.get(6)).equals(graph.getNode("d2"))) continue;
                pathBD2 = true;
                continue;
            }
            if (((PropertyContainer)path.get(6)).equals(graph.getNode("d"))) {
                pathB2D = true;
                continue;
            }
            if (!((PropertyContainer)path.get(6)).equals(graph.getNode("d2"))) continue;
            pathB2D2 = true;
        }
        Assert.assertTrue((boolean)pathBD);
        Assert.assertTrue((boolean)pathB2D);
        Assert.assertTrue((boolean)pathBD2);
        Assert.assertTrue((boolean)pathB2D2);
    }

    @Test
    public void test8() {
        Relationship edgeAB = graph.makeEdge("a", "b");
        Relationship edgeBC = graph.makeEdge("b", "c");
        Relationship edgeCD = graph.makeEdge("c", "d");
        Relationship edgeDE = graph.makeEdge("d", "e");
        Relationship edgeAB2 = graph.makeEdge("a", "b2");
        Relationship edgeB2C = graph.makeEdge("b2", "c");
        Relationship edgeCD2 = graph.makeEdge("c", "d2");
        Relationship edgeD2E = graph.makeEdge("d2", "e");
        Dijkstra dijkstra = new Dijkstra((Object)0.0, graph.getNode("a"), graph.getNode("e"), (CostEvaluator)new CostEvaluator<Double>(){

            public Double getCost(Relationship relationship, Direction direction) {
                return 1.0;
            }
        }, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.OUTGOING, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        boolean pathBD = false;
        boolean pathB2D = false;
        boolean pathBD2 = false;
        boolean pathB2D2 = false;
        List paths = dijkstra.getPathsAsRelationships();
        Assert.assertTrue((paths.size() == 4 ? 1 : 0) != 0);
        for (List path : paths) {
            Assert.assertTrue((path.size() == 4 ? 1 : 0) != 0);
            if (((Relationship)path.get(0)).equals(edgeAB)) {
                Assert.assertTrue((boolean)((Relationship)path.get(1)).equals(edgeBC));
            } else {
                Assert.assertTrue((boolean)((Relationship)path.get(0)).equals(edgeAB2));
                Assert.assertTrue((boolean)((Relationship)path.get(1)).equals(edgeB2C));
            }
            if (((Relationship)path.get(2)).equals(edgeCD)) {
                Assert.assertTrue((boolean)((Relationship)path.get(3)).equals(edgeDE));
            } else {
                Assert.assertTrue((boolean)((Relationship)path.get(2)).equals(edgeCD2));
                Assert.assertTrue((boolean)((Relationship)path.get(3)).equals(edgeD2E));
            }
            if (((Relationship)path.get(0)).equals(edgeAB)) {
                if (((Relationship)path.get(2)).equals(edgeCD)) {
                    pathBD = true;
                    continue;
                }
                if (!((Relationship)path.get(2)).equals(edgeCD2)) continue;
                pathBD2 = true;
                continue;
            }
            if (((Relationship)path.get(2)).equals(edgeCD)) {
                pathB2D = true;
                continue;
            }
            if (!((Relationship)path.get(2)).equals(edgeCD2)) continue;
            pathB2D2 = true;
        }
        Assert.assertTrue((boolean)pathBD);
        Assert.assertTrue((boolean)pathB2D);
        Assert.assertTrue((boolean)pathBD2);
        Assert.assertTrue((boolean)pathB2D2);
    }
}

