/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.ancestor;

import java.util.ArrayList;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphalgo.impl.ancestor.AncestorsUtil;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.TestGraphDatabaseFactory;

public class AncestorTestCase
implements GraphHolder {
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));
    private static GraphDatabaseService gdb;

    @Test
    @GraphDescription.Graph(value={"root contains child1", "child1 contains child11", "child1 contains child12", "root contains child2", "child12 contains child121", "child1 contains child13"})
    public void test() {
        PathExpander expander = PathExpanders.forTypeAndDirection((RelationshipType)Rels.contains, (Direction)Direction.INCOMING);
        ArrayList nodeSet = new ArrayList();
        Map graph = (Map)this.data.get();
        nodeSet.add(graph.get("child1"));
        nodeSet.add(graph.get("root"));
        try (Transaction transaction = gdb.beginTx();){
            Node ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("root"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child12"));
            nodeSet.add(graph.get("child11"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("child1"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child121"));
            nodeSet.add(graph.get("child12"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("child12"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child11"));
            nodeSet.add(graph.get("child13"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("child1"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child2"));
            nodeSet.add(graph.get("child121"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("root"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child11"));
            nodeSet.add(graph.get("child12"));
            nodeSet.add(graph.get("child13"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("child1"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child11"));
            nodeSet.add(graph.get("child12"));
            nodeSet.add(graph.get("child13"));
            nodeSet.add(graph.get("child121"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("child1"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child11"));
            nodeSet.add(graph.get("child12"));
            nodeSet.add(graph.get("child13"));
            nodeSet.add(graph.get("child121"));
            nodeSet.add(graph.get("child2"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("root"), (Object)ancestor);
            nodeSet.clear();
            nodeSet.add(graph.get("child11"));
            nodeSet.add(graph.get("child12"));
            nodeSet.add(graph.get("child13"));
            nodeSet.add(graph.get("child121"));
            nodeSet.add(graph.get("child12"));
            nodeSet.add(graph.get("root"));
            ancestor = AncestorsUtil.lowestCommonAncestor(nodeSet, (PathExpander)expander);
            Assert.assertEquals(graph.get("root"), (Object)ancestor);
        }
    }

    public GraphDatabaseService graphdb() {
        return gdb;
    }

    @BeforeClass
    public static void before() {
        gdb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @AfterClass
    public static void after() {
        gdb.shutdown();
    }

    static enum Rels implements RelationshipType
    {
        contains;

    }
}

